/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.artifacts;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.ListMap;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.analysis.artifacts.ContextAccumulator;
import picard.analysis.artifacts.SequencingArtifactMetrics;
import picard.analysis.artifacts.Transition;

class ArtifactCounter {
    private final String sampleAlias;
    private final String library;
    private final Set<String> fullContexts;
    private final Map<String, String> leadingContextMap;
    private final Map<String, String> trailingContextMap;
    private final Map<String, String> zeroContextMap;
    private final ContextAccumulator fullContextAccumulator;
    private final ContextAccumulator halfContextAccumulator;
    private final ContextAccumulator zeroContextAccumulator;
    private final List<SequencingArtifactMetrics.PreAdapterSummaryMetrics> preAdapterSummaryMetricsList;
    private final List<SequencingArtifactMetrics.PreAdapterDetailMetrics> preAdapterDetailMetricsList;
    private final List<SequencingArtifactMetrics.BaitBiasSummaryMetrics> baitBiasSummaryMetricsList;
    private final List<SequencingArtifactMetrics.BaitBiasDetailMetrics> baitBiasDetailMetricsList;

    public ArtifactCounter(String string, String string2, int n, boolean bl) {
        Object object;
        Object object22;
        this.sampleAlias = string;
        this.library = string2;
        this.fullContexts = new HashSet<String>();
        for (Object object22 : SequenceUtil.generateAllKmers((int)(2 * n + 1))) {
            this.fullContexts.add(StringUtil.bytesToString((byte[])object22));
        }
        String string3 = StringUtil.repeatCharNTimes((char)'N', (int)n);
        this.leadingContextMap = new HashMap<String, String>();
        this.trailingContextMap = new HashMap<String, String>();
        this.zeroContextMap = new HashMap<String, String>();
        object22 = this.fullContexts.iterator();
        while (object22.hasNext()) {
            object = (String)object22.next();
            String string4 = ((String)object).substring(0, n);
            String string5 = ((String)object).substring(n + 1, ((String)object).length());
            char c = ((String)object).charAt(n);
            this.leadingContextMap.put((String)object, string4 + c + (String)string3);
            this.trailingContextMap.put((String)object, (String)string3 + c + string5);
            this.zeroContextMap.put((String)object, (String)string3 + c + (String)string3);
        }
        object22 = new HashSet();
        object22.addAll(this.leadingContextMap.values());
        object22.addAll(this.trailingContextMap.values());
        object = new HashSet();
        object.addAll(this.zeroContextMap.values());
        this.fullContextAccumulator = new ContextAccumulator(this.fullContexts, bl);
        this.halfContextAccumulator = new ContextAccumulator((Set<String>)object22, bl);
        this.zeroContextAccumulator = new ContextAccumulator((Set<String>)object, bl);
        this.preAdapterSummaryMetricsList = new ArrayList<SequencingArtifactMetrics.PreAdapterSummaryMetrics>();
        this.preAdapterDetailMetricsList = new ArrayList<SequencingArtifactMetrics.PreAdapterDetailMetrics>();
        this.baitBiasSummaryMetricsList = new ArrayList<SequencingArtifactMetrics.BaitBiasSummaryMetrics>();
        this.baitBiasDetailMetricsList = new ArrayList<SequencingArtifactMetrics.BaitBiasDetailMetrics>();
    }

    public void countRecord(String string, char c, SAMRecord sAMRecord) {
        if (this.fullContexts.contains(string)) {
            this.fullContextAccumulator.countRecord(string, c, sAMRecord);
            this.halfContextAccumulator.countRecord(this.leadingContextMap.get(string), c, sAMRecord);
            this.halfContextAccumulator.countRecord(this.trailingContextMap.get(string), c, sAMRecord);
            this.zeroContextAccumulator.countRecord(this.zeroContextMap.get(string), c, sAMRecord);
        }
    }

    public void finish() {
        ListMap<Transition, SequencingArtifactMetrics.DetailPair> listMap = this.getDetailMetrics();
        Map<Transition, SequencingArtifactMetrics.SummaryPair> map = this.getSummaryMetrics();
        for (Transition transition : Transition.altValues()) {
            SequencingArtifactMetrics.SummaryPair summaryPair = map.get((Object)transition);
            List list = (List)listMap.get((Object)transition);
            this.preAdapterSummaryMetricsList.add(summaryPair.preAdapterMetrics);
            this.baitBiasSummaryMetricsList.add(summaryPair.baitBiasMetrics);
            for (SequencingArtifactMetrics.DetailPair detailPair : list) {
                this.preAdapterDetailMetricsList.add(detailPair.preAdapterMetrics);
                this.baitBiasDetailMetricsList.add(detailPair.baitBiasMetrics);
            }
        }
    }

    public List<SequencingArtifactMetrics.PreAdapterSummaryMetrics> getPreAdapterSummaryMetrics() {
        return this.preAdapterSummaryMetricsList;
    }

    public List<SequencingArtifactMetrics.PreAdapterDetailMetrics> getPreAdapterDetailMetrics() {
        return this.preAdapterDetailMetricsList;
    }

    public List<SequencingArtifactMetrics.BaitBiasSummaryMetrics> getBaitBiasSummaryMetrics() {
        return this.baitBiasSummaryMetricsList;
    }

    public List<SequencingArtifactMetrics.BaitBiasDetailMetrics> getBaitBiasDetailMetrics() {
        return this.baitBiasDetailMetricsList;
    }

    private Map<Transition, SequencingArtifactMetrics.SummaryPair> getSummaryMetrics() {
        HashMap<Transition, SequencingArtifactMetrics.SummaryPair> hashMap = new HashMap<Transition, SequencingArtifactMetrics.SummaryPair>();
        ListMap<Transition, SequencingArtifactMetrics.DetailPair> listMap = this.fullContextAccumulator.calculateMetrics(this.sampleAlias, this.library);
        ListMap<Transition, SequencingArtifactMetrics.DetailPair> listMap2 = this.halfContextAccumulator.calculateMetrics(this.sampleAlias, this.library);
        ListMap<Transition, SequencingArtifactMetrics.DetailPair> listMap3 = this.zeroContextAccumulator.calculateMetrics(this.sampleAlias, this.library);
        for (Transition transition : Transition.altValues()) {
            SequencingArtifactMetrics.DetailPair detailPair2;
            List list = (List)listMap.get((Object)transition);
            List list2 = (List)listMap3.get((Object)transition);
            if (list2.size() != 1) {
                throw new PicardException("Should have exactly one context-free metric pair for transition: " + (Object)((Object)transition));
            }
            ArrayList<SequencingArtifactMetrics.DetailPair> arrayList = new ArrayList<SequencingArtifactMetrics.DetailPair>();
            ArrayList<SequencingArtifactMetrics.DetailPair> arrayList2 = new ArrayList<SequencingArtifactMetrics.DetailPair>();
            for (SequencingArtifactMetrics.DetailPair detailPair2 : (List)listMap2.get((Object)transition)) {
                if (!detailPair2.preAdapterMetrics.CONTEXT.equals(detailPair2.baitBiasMetrics.CONTEXT)) {
                    throw new PicardException("Input detail metrics are not matched up properly - contexts differ.");
                }
                boolean bl = this.leadingContextMap.containsValue(detailPair2.preAdapterMetrics.CONTEXT);
                boolean bl2 = this.trailingContextMap.containsValue(detailPair2.preAdapterMetrics.CONTEXT);
                if (bl) {
                    arrayList.add(detailPair2);
                }
                if (!bl2) continue;
                arrayList2.add(detailPair2);
            }
            SequencingArtifactMetrics.DetailPair detailPair3 = (SequencingArtifactMetrics.DetailPair)list2.get(0);
            detailPair2 = this.getWorstMetrics(list);
            SequencingArtifactMetrics.DetailPair detailPair4 = this.getWorstMetrics(arrayList);
            SequencingArtifactMetrics.DetailPair detailPair5 = this.getWorstMetrics(arrayList2);
            SequencingArtifactMetrics.PreAdapterSummaryMetrics preAdapterSummaryMetrics = new SequencingArtifactMetrics.PreAdapterSummaryMetrics();
            SequencingArtifactMetrics.BaitBiasSummaryMetrics baitBiasSummaryMetrics = new SequencingArtifactMetrics.BaitBiasSummaryMetrics();
            preAdapterSummaryMetrics.SAMPLE_ALIAS = this.sampleAlias;
            preAdapterSummaryMetrics.LIBRARY = this.library;
            preAdapterSummaryMetrics.REF_BASE = transition.ref();
            preAdapterSummaryMetrics.ALT_BASE = transition.call();
            preAdapterSummaryMetrics.TOTAL_QSCORE = detailPair3.preAdapterMetrics.QSCORE;
            preAdapterSummaryMetrics.WORST_CXT = detailPair2.preAdapterMetrics.CONTEXT;
            preAdapterSummaryMetrics.WORST_CXT_QSCORE = detailPair2.preAdapterMetrics.QSCORE;
            preAdapterSummaryMetrics.WORST_PRE_CXT = detailPair4.preAdapterMetrics.CONTEXT;
            preAdapterSummaryMetrics.WORST_PRE_CXT_QSCORE = detailPair4.preAdapterMetrics.QSCORE;
            preAdapterSummaryMetrics.WORST_POST_CXT = detailPair5.preAdapterMetrics.CONTEXT;
            preAdapterSummaryMetrics.WORST_POST_CXT_QSCORE = detailPair5.preAdapterMetrics.QSCORE;
            preAdapterSummaryMetrics.inferArtifactName();
            baitBiasSummaryMetrics.SAMPLE_ALIAS = this.sampleAlias;
            baitBiasSummaryMetrics.LIBRARY = this.library;
            baitBiasSummaryMetrics.REF_BASE = transition.ref();
            baitBiasSummaryMetrics.ALT_BASE = transition.call();
            baitBiasSummaryMetrics.TOTAL_QSCORE = detailPair3.baitBiasMetrics.QSCORE;
            baitBiasSummaryMetrics.WORST_CXT = detailPair2.baitBiasMetrics.CONTEXT;
            baitBiasSummaryMetrics.WORST_CXT_QSCORE = detailPair2.baitBiasMetrics.QSCORE;
            baitBiasSummaryMetrics.WORST_PRE_CXT = detailPair4.baitBiasMetrics.CONTEXT;
            baitBiasSummaryMetrics.WORST_PRE_CXT_QSCORE = detailPair4.baitBiasMetrics.QSCORE;
            baitBiasSummaryMetrics.WORST_POST_CXT = detailPair5.baitBiasMetrics.CONTEXT;
            baitBiasSummaryMetrics.WORST_POST_CXT_QSCORE = detailPair5.baitBiasMetrics.QSCORE;
            baitBiasSummaryMetrics.inferArtifactName();
            hashMap.put(transition, new SequencingArtifactMetrics.SummaryPair(preAdapterSummaryMetrics, baitBiasSummaryMetrics));
        }
        return hashMap;
    }

    private ListMap<Transition, SequencingArtifactMetrics.DetailPair> getDetailMetrics() {
        return this.fullContextAccumulator.calculateMetrics(this.sampleAlias, this.library);
    }

    private SequencingArtifactMetrics.DetailPair getWorstMetrics(List<SequencingArtifactMetrics.DetailPair> list) {
        SequencingArtifactMetrics.PreAdapterDetailMetrics preAdapterDetailMetrics = null;
        SequencingArtifactMetrics.BaitBiasDetailMetrics baitBiasDetailMetrics = null;
        for (SequencingArtifactMetrics.DetailPair detailPair : list) {
            if (preAdapterDetailMetrics == null || detailPair.preAdapterMetrics.compareTo(preAdapterDetailMetrics) < 0) {
                preAdapterDetailMetrics = detailPair.preAdapterMetrics;
            }
            if (baitBiasDetailMetrics != null && detailPair.baitBiasMetrics.compareTo(baitBiasDetailMetrics) >= 0) continue;
            baitBiasDetailMetrics = detailPair.baitBiasMetrics;
        }
        return new SequencingArtifactMetrics.DetailPair(preAdapterDetailMetrics, baitBiasDetailMetrics);
    }
}

