/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.artifacts;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.filter.AggregateFilter;
import htsjdk.samtools.filter.AlignedFilter;
import htsjdk.samtools.filter.DuplicateReadFilter;
import htsjdk.samtools.filter.FailsVendorReadQualityFilter;
import htsjdk.samtools.filter.InsertSizeFilter;
import htsjdk.samtools.filter.MappingQualityFilter;
import htsjdk.samtools.filter.NotPrimaryAlignmentFilter;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.CodeUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.IntervalListReferenceSequenceMask;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.analysis.SinglePassSamProgram;
import picard.analysis.artifacts.ArtifactCounter;
import picard.analysis.artifacts.SequencingArtifactMetrics;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.DbSnpBitSetUtil;

@CommandLineProgramProperties(usage="Collect metrics to quantify single-base sequencing artifacts.", usageShort="Collect metrics to quantify single-base sequencing artifacts.", programGroup=Metrics.class)
public class CollectSequencingArtifactMetrics
extends SinglePassSamProgram {
    static final String USAGE = "Collect metrics to quantify single-base sequencing artifacts.";
    @Option(doc="An optional list of intervals to restrict analysis to.", optional=true)
    public File INTERVALS;
    @Option(doc="VCF format dbSNP file, used to exclude regions around known polymorphisms from analysis.", optional=true)
    public File DB_SNP;
    @Option(shortName="Q", doc="The minimum base quality score for a base to be included in analysis.")
    public int MINIMUM_QUALITY_SCORE = 20;
    @Option(shortName="MQ", doc="The minimum mapping quality score for a base to be included in analysis.")
    public int MINIMUM_MAPPING_QUALITY = 30;
    @Option(shortName="MIN_INS", doc="The minimum insert size for a read to be included in analysis.")
    public int MINIMUM_INSERT_SIZE = 60;
    @Option(shortName="MAX_INS", doc="The maximum insert size for a read to be included in analysis. Set to 0 to have no maximum.")
    public int MAXIMUM_INSERT_SIZE = 600;
    @Option(shortName="UNPAIRED", doc="Include unpaired reads. If set to true then all paired reads will be included as well - MINIMUM_INSERT_SIZE and MAXIMUM_INSERT_SIZE will be ignored.")
    public boolean INCLUDE_UNPAIRED = false;
    @Option(shortName="TANDEM", doc="Set to true if mate pairs are being sequenced from the same strand, i.e. they're expected to face the same direction.")
    public boolean TANDEM_READS = false;
    @Option(doc="When available, use original quality scores for filtering.")
    public boolean USE_OQ = true;
    @Option(doc="The number of context bases to include on each side of the assayed base.")
    public int CONTEXT_SIZE = 1;
    @Option(doc="If specified, only print results for these contexts in the detail metrics output. However, the summary metrics output will still take all contexts into consideration.")
    public Set<String> CONTEXTS_TO_PRINT = new HashSet<String>();
    private static final String UNKNOWN_LIBRARY = "UnknownLibrary";
    private static final String UNKNOWN_SAMPLE = "UnknownSample";
    private File preAdapterSummaryOut;
    private File preAdapterDetailsOut;
    private File baitBiasSummaryOut;
    private File baitBiasDetailsOut;
    private IntervalListReferenceSequenceMask intervalMask;
    private DbSnpBitSetUtil dbSnpMask;
    private SamRecordFilter recordFilter;
    private final Set<String> samples = new HashSet<String>();
    private final Set<String> libraries = new HashSet<String>();
    private final Map<String, ArtifactCounter> artifactCounters = new HashMap<String, ArtifactCounter>();

    public static void main(String[] stringArray) {
        new CollectSequencingArtifactMetrics().instanceMainWithExit(stringArray);
    }

    @Override
    protected String[] customCommandLineValidation() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 2 * this.CONTEXT_SIZE + 1;
        if (this.CONTEXT_SIZE < 0) {
            arrayList.add("CONTEXT_SIZE cannot be negative");
        }
        for (String string : this.CONTEXTS_TO_PRINT) {
            if (string.length() == n) continue;
            arrayList.add("Context " + string + " is not the length implied by CONTEXT_SIZE: " + n);
        }
        if (this.MINIMUM_INSERT_SIZE < 0) {
            arrayList.add("MINIMUM_INSERT_SIZE cannot be negative");
        }
        if (this.MAXIMUM_INSERT_SIZE < 0) {
            arrayList.add("MAXIMUM_INSERT_SIZE cannot be negative");
        }
        if (this.MAXIMUM_INSERT_SIZE > 0 && this.MAXIMUM_INSERT_SIZE < this.MINIMUM_INSERT_SIZE) {
            arrayList.add("MAXIMUM_INSERT_SIZE cannot be less than MINIMUM_INSERT_SIZE unless set to 0");
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    protected void setup(SAMFileHeader sAMFileHeader, File file) {
        this.preAdapterSummaryOut = new File(this.OUTPUT + ".pre_adapter_summary_metrics");
        this.preAdapterDetailsOut = new File(this.OUTPUT + ".pre_adapter_detail_metrics");
        this.baitBiasSummaryOut = new File(this.OUTPUT + ".bait_bias_summary_metrics");
        this.baitBiasDetailsOut = new File(this.OUTPUT + ".bait_bias_detail_metrics");
        IOUtil.assertFileIsWritable((File)this.preAdapterSummaryOut);
        IOUtil.assertFileIsWritable((File)this.preAdapterDetailsOut);
        IOUtil.assertFileIsWritable((File)this.baitBiasSummaryOut);
        IOUtil.assertFileIsWritable((File)this.baitBiasDetailsOut);
        for (SAMReadGroupRecord sAMReadGroupRecord : sAMFileHeader.getReadGroups()) {
            this.samples.add((String)CodeUtil.getOrElse((Object)sAMReadGroupRecord.getSample(), (Object)UNKNOWN_SAMPLE));
            this.libraries.add((String)CodeUtil.getOrElse((Object)sAMReadGroupRecord.getLibrary(), (Object)UNKNOWN_LIBRARY));
        }
        if (this.INTERVALS != null) {
            IOUtil.assertFileIsReadable((File)this.INTERVALS);
            this.intervalMask = new IntervalListReferenceSequenceMask(IntervalList.fromFile((File)this.INTERVALS).uniqued());
        }
        if (this.DB_SNP != null) {
            IOUtil.assertFileIsReadable((File)this.DB_SNP);
            this.dbSnpMask = new DbSnpBitSetUtil(this.DB_SNP, sAMFileHeader.getSequenceDictionary());
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(new FailsVendorReadQualityFilter());
        arrayList.add(new NotPrimaryAlignmentFilter());
        arrayList.add(new DuplicateReadFilter());
        arrayList.add(new AlignedFilter(true));
        arrayList.add(new MappingQualityFilter(this.MINIMUM_MAPPING_QUALITY));
        if (!this.INCLUDE_UNPAIRED) {
            int n = this.MAXIMUM_INSERT_SIZE == 0 ? Integer.MAX_VALUE : this.MAXIMUM_INSERT_SIZE;
            arrayList.add(new InsertSizeFilter(this.MINIMUM_INSERT_SIZE, n));
        }
        this.recordFilter = new AggregateFilter((List)arrayList);
        String string = StringUtil.join((String)",", new ArrayList<String>(this.samples));
        for (String string2 : this.libraries) {
            this.artifactCounters.put(string2, new ArtifactCounter(string, string2, this.CONTEXT_SIZE, this.TANDEM_READS));
        }
    }

    @Override
    protected void acceptRead(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        String string;
        if (this.recordFilter.filterOut(sAMRecord)) {
            return;
        }
        String string2 = string = sAMRecord.getReadGroup() == null ? UNKNOWN_LIBRARY : (String)CodeUtil.getOrElse((Object)sAMRecord.getReadGroup().getLibrary(), (Object)UNKNOWN_LIBRARY);
        if (!this.libraries.contains(string)) {
            throw new PicardException("Record contains library that is missing from header: " + string);
        }
        for (AlignmentBlock alignmentBlock : sAMRecord.getAlignmentBlocks()) {
            for (int i = 0; i < alignmentBlock.getLength(); ++i) {
                char c;
                String string3;
                int n = alignmentBlock.getReadStart() + i;
                int n2 = alignmentBlock.getReferenceStart() + i;
                if (this.intervalMask != null && !this.intervalMask.get(referenceSequence.getContigIndex(), n2) || this.dbSnpMask != null && this.dbSnpMask.isDbSnpSite(referenceSequence.getName(), n2)) continue;
                int n3 = n2 - this.CONTEXT_SIZE - 1;
                int n4 = 2 * this.CONTEXT_SIZE + 1;
                if (n3 < 0 || n3 + n4 > referenceSequence.length() || (string3 = StringUtil.bytesToString((byte[])referenceSequence.getBases(), (int)n3, (int)n4).toUpperCase()).contains("N") || this.failsBaseQualityCutoff(n, sAMRecord) || (c = Character.toUpperCase((char)sAMRecord.getReadBases()[n - 1])) == 'N') continue;
                this.artifactCounters.get(string).countRecord(string3, c, sAMRecord);
            }
        }
    }

    @Override
    protected void finish() {
        MetricsFile metricsFile = this.getMetricsFile();
        MetricsFile metricsFile2 = this.getMetricsFile();
        MetricsFile metricsFile3 = this.getMetricsFile();
        MetricsFile metricsFile4 = this.getMetricsFile();
        for (ArtifactCounter artifactCounter : this.artifactCounters.values()) {
            artifactCounter.finish();
            metricsFile.addAllMetrics(artifactCounter.getPreAdapterSummaryMetrics());
            metricsFile3.addAllMetrics(artifactCounter.getBaitBiasSummaryMetrics());
            for (SequencingArtifactMetrics.PreAdapterDetailMetrics preAdapterDetailMetrics : artifactCounter.getPreAdapterDetailMetrics()) {
                if (this.CONTEXTS_TO_PRINT.size() != 0 && !this.CONTEXTS_TO_PRINT.contains(preAdapterDetailMetrics.CONTEXT)) continue;
                metricsFile2.addMetric((MetricBase)preAdapterDetailMetrics);
            }
            for (SequencingArtifactMetrics.BaitBiasDetailMetrics baitBiasDetailMetrics : artifactCounter.getBaitBiasDetailMetrics()) {
                if (this.CONTEXTS_TO_PRINT.size() != 0 && !this.CONTEXTS_TO_PRINT.contains(baitBiasDetailMetrics.CONTEXT)) continue;
                metricsFile4.addMetric((MetricBase)baitBiasDetailMetrics);
            }
        }
        metricsFile2.write(this.preAdapterDetailsOut);
        metricsFile.write(this.preAdapterSummaryOut);
        metricsFile4.write(this.baitBiasDetailsOut);
        metricsFile3.write(this.baitBiasSummaryOut);
    }

    @Override
    protected boolean usesNoRefReads() {
        return false;
    }

    private boolean failsBaseQualityCutoff(int n, SAMRecord sAMRecord) {
        byte by = this.USE_OQ && sAMRecord.getOriginalBaseQualities() != null ? sAMRecord.getOriginalBaseQualities()[n - 1] : sAMRecord.getBaseQualities()[n - 1];
        return by < this.MINIMUM_QUALITY_SCORE;
    }
}

