/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.artifacts;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.ListMap;
import htsjdk.samtools.util.SequenceUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import picard.PicardException;
import picard.analysis.artifacts.SequencingArtifactMetrics;
import picard.analysis.artifacts.Transition;

class ContextAccumulator {
    private final boolean expectedTandemReads;
    private final Map<Transition, Map<String, AlignmentAccumulator>> artifactMap;

    public ContextAccumulator(Set<String> set, boolean bl) {
        this.expectedTandemReads = bl;
        this.artifactMap = new HashMap<Transition, Map<String, AlignmentAccumulator>>();
        for (Transition object : Transition.values()) {
            this.artifactMap.put(object, new HashMap());
        }
        for (String string : set) {
            int n = this.getCentralBase(string);
            for (byte by : SequenceUtil.VALID_BASES_UPPER) {
                Transition transition = Transition.transitionOf((char)n, (char)by);
                this.artifactMap.get((Object)transition).put(string, new AlignmentAccumulator());
            }
        }
    }

    public void countRecord(String string, char c, SAMRecord sAMRecord) {
        char c2 = this.getCentralBase(string);
        Transition transition = Transition.transitionOf(c2, c);
        this.artifactMap.get((Object)transition).get(string).countRecord(sAMRecord);
    }

    public ListMap<Transition, SequencingArtifactMetrics.DetailPair> calculateMetrics(String string, String string2) {
        ListMap listMap = new ListMap();
        for (Transition transition : Transition.altValues()) {
            Transition transition2 = transition.matchingRef();
            for (String string3 : new TreeSet<String>(this.artifactMap.get((Object)transition).keySet())) {
                SequencingArtifactMetrics.PreAdapterDetailMetrics preAdapterDetailMetrics = new SequencingArtifactMetrics.PreAdapterDetailMetrics();
                SequencingArtifactMetrics.BaitBiasDetailMetrics baitBiasDetailMetrics = new SequencingArtifactMetrics.BaitBiasDetailMetrics();
                preAdapterDetailMetrics.SAMPLE_ALIAS = string;
                preAdapterDetailMetrics.LIBRARY = string2;
                preAdapterDetailMetrics.CONTEXT = string3;
                preAdapterDetailMetrics.REF_BASE = transition.ref();
                preAdapterDetailMetrics.ALT_BASE = transition.call();
                baitBiasDetailMetrics.SAMPLE_ALIAS = string;
                baitBiasDetailMetrics.LIBRARY = string2;
                baitBiasDetailMetrics.CONTEXT = string3;
                baitBiasDetailMetrics.REF_BASE = transition.ref();
                baitBiasDetailMetrics.ALT_BASE = transition.call();
                AlignmentAccumulator alignmentAccumulator = this.artifactMap.get((Object)transition2).get(string3);
                AlignmentAccumulator alignmentAccumulator2 = this.artifactMap.get((Object)transition).get(string3);
                AlignmentAccumulator alignmentAccumulator3 = this.artifactMap.get((Object)transition2.complement()).get(SequenceUtil.reverseComplement((String)string3));
                AlignmentAccumulator alignmentAccumulator4 = this.artifactMap.get((Object)transition.complement()).get(SequenceUtil.reverseComplement((String)string3));
                if (this.expectedTandemReads) {
                    preAdapterDetailMetrics.PRO_REF_BASES = alignmentAccumulator.R1_POS + alignmentAccumulator.R2_POS + alignmentAccumulator3.R1_NEG + alignmentAccumulator3.R2_NEG;
                    preAdapterDetailMetrics.PRO_ALT_BASES = alignmentAccumulator2.R1_POS + alignmentAccumulator2.R2_POS + alignmentAccumulator4.R1_NEG + alignmentAccumulator4.R2_NEG;
                    preAdapterDetailMetrics.CON_REF_BASES = alignmentAccumulator.R1_NEG + alignmentAccumulator.R2_NEG + alignmentAccumulator3.R1_POS + alignmentAccumulator3.R2_POS;
                    preAdapterDetailMetrics.CON_ALT_BASES = alignmentAccumulator2.R1_NEG + alignmentAccumulator2.R2_NEG + alignmentAccumulator4.R1_POS + alignmentAccumulator4.R2_POS;
                } else {
                    preAdapterDetailMetrics.PRO_REF_BASES = alignmentAccumulator.R1_POS + alignmentAccumulator.R2_NEG + alignmentAccumulator3.R1_NEG + alignmentAccumulator3.R2_POS;
                    preAdapterDetailMetrics.PRO_ALT_BASES = alignmentAccumulator2.R1_POS + alignmentAccumulator2.R2_NEG + alignmentAccumulator4.R1_NEG + alignmentAccumulator4.R2_POS;
                    preAdapterDetailMetrics.CON_REF_BASES = alignmentAccumulator.R1_NEG + alignmentAccumulator.R2_POS + alignmentAccumulator3.R1_POS + alignmentAccumulator3.R2_NEG;
                    preAdapterDetailMetrics.CON_ALT_BASES = alignmentAccumulator2.R1_NEG + alignmentAccumulator2.R2_POS + alignmentAccumulator4.R1_POS + alignmentAccumulator4.R2_NEG;
                }
                baitBiasDetailMetrics.FWD_CXT_REF_BASES = alignmentAccumulator.R1_POS + alignmentAccumulator.R1_NEG + alignmentAccumulator.R2_POS + alignmentAccumulator.R2_NEG;
                baitBiasDetailMetrics.FWD_CXT_ALT_BASES = alignmentAccumulator2.R1_POS + alignmentAccumulator2.R1_NEG + alignmentAccumulator2.R2_POS + alignmentAccumulator2.R2_NEG;
                baitBiasDetailMetrics.REV_CXT_REF_BASES = alignmentAccumulator3.R1_POS + alignmentAccumulator3.R1_NEG + alignmentAccumulator3.R2_POS + alignmentAccumulator3.R2_NEG;
                baitBiasDetailMetrics.REV_CXT_ALT_BASES = alignmentAccumulator4.R1_POS + alignmentAccumulator4.R1_NEG + alignmentAccumulator4.R2_POS + alignmentAccumulator4.R2_NEG;
                preAdapterDetailMetrics.calculateDerivedStatistics();
                baitBiasDetailMetrics.calculateDerivedStatistics();
                listMap.add((Object)transition, (Object)new SequencingArtifactMetrics.DetailPair(preAdapterDetailMetrics, baitBiasDetailMetrics));
            }
        }
        return listMap;
    }

    private char getCentralBase(String string) {
        if (string.length() % 2 == 0) {
            throw new PicardException("Contexts cannot have an even number of bases: " + string);
        }
        return string.charAt(string.length() / 2);
    }

    private static class AlignmentAccumulator {
        private long R1_POS = 0L;
        private long R1_NEG = 0L;
        private long R2_POS = 0L;
        private long R2_NEG = 0L;

        private AlignmentAccumulator() {
        }

        private void countRecord(SAMRecord sAMRecord) {
            boolean bl;
            boolean bl2 = sAMRecord.getReadNegativeStrandFlag();
            boolean bl3 = bl = sAMRecord.getReadPairedFlag() && sAMRecord.getSecondOfPairFlag();
            if (bl) {
                if (bl2) {
                    ++this.R2_NEG;
                } else {
                    ++this.R2_POS;
                }
            } else if (bl2) {
                ++this.R1_NEG;
            } else {
                ++this.R1_POS;
            }
        }
    }
}

