/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.artifacts;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.SequenceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import picard.analysis.CollectOxoGMetrics;
import picard.analysis.artifacts.SequencingArtifactMetrics;
import picard.analysis.artifacts.Transition;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;

@CommandLineProgramProperties(usage="Extract OxoG metrics format from generalized artifact metrics.", usageShort="Extract OxoG metrics format from generalized artifact metrics.", programGroup=Metrics.class)
public class ConvertSequencingArtifactToOxoG
extends CommandLineProgram {
    static final String USAGE = "Extract OxoG metrics format from generalized artifact metrics.";
    @Option(shortName="I", doc="Basename for input artifact metrics")
    public File INPUT_BASE;
    @Option(shortName="O", doc="Basename for output OxoG metrics. Defaults to same basename as input metrics", optional=true)
    public File OUTPUT_BASE;

    public static void main(String[] stringArray) {
        new ConvertSequencingArtifactToOxoG().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        Object object;
        Object object422;
        if (this.OUTPUT_BASE == null) {
            this.OUTPUT_BASE = this.INPUT_BASE;
        }
        File file = new File(this.INPUT_BASE + ".pre_adapter_detail_metrics");
        File file2 = new File(this.INPUT_BASE + ".bait_bias_detail_metrics");
        File file3 = new File(this.OUTPUT_BASE + ".oxog_metrics");
        IOUtil.assertFileIsReadable((File)file);
        IOUtil.assertFileIsReadable((File)file2);
        IOUtil.assertFileIsWritable((File)file3);
        List list = MetricsFile.readBeans((File)file);
        List list2 = MetricsFile.readBeans((File)file2);
        String string = ((SequencingArtifactMetrics.PreAdapterDetailMetrics)((Object)list.get((int)0))).SAMPLE_ALIAS;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (Object object422 : list) {
            hashSet.add(((SequencingArtifactMetrics.PreAdapterDetailMetrics)((Object)object422)).LIBRARY);
            if (((SequencingArtifactMetrics.PreAdapterDetailMetrics)((Object)object422)).REF_BASE != 'C') continue;
            hashSet2.add(((SequencingArtifactMetrics.PreAdapterDetailMetrics)((Object)object422)).CONTEXT);
        }
        HashMap hashMap = new HashMap();
        object422 = new HashMap();
        for (String object32 : hashSet) {
            HashMap hashMap2 = new HashMap();
            object = new HashMap();
            hashMap.put(object32, hashMap2);
            object422.put(object32, object);
        }
        for (SequencingArtifactMetrics.PreAdapterDetailMetrics preAdapterDetailMetrics : list) {
            Transition transition = Transition.transitionOf(preAdapterDetailMetrics.REF_BASE, preAdapterDetailMetrics.ALT_BASE);
            if (!this.isOxoG(transition)) continue;
            ((Map)hashMap.get(preAdapterDetailMetrics.LIBRARY)).put(preAdapterDetailMetrics.CONTEXT, preAdapterDetailMetrics);
        }
        for (SequencingArtifactMetrics.BaitBiasDetailMetrics baitBiasDetailMetrics : list2) {
            Transition transition = Transition.transitionOf(baitBiasDetailMetrics.REF_BASE, baitBiasDetailMetrics.ALT_BASE);
            if (!this.isOxoG(transition)) continue;
            ((Map)object422.get(baitBiasDetailMetrics.LIBRARY)).put(baitBiasDetailMetrics.CONTEXT, baitBiasDetailMetrics);
        }
        ArrayList arrayList = new ArrayList();
        for (String string2 : hashSet) {
            for (String string3 : hashSet2) {
                CollectOxoGMetrics.CpcgMetrics cpcgMetrics = new CollectOxoGMetrics.CpcgMetrics();
                cpcgMetrics.SAMPLE_ALIAS = string;
                cpcgMetrics.LIBRARY = string2;
                cpcgMetrics.CONTEXT = string3;
                cpcgMetrics.TOTAL_SITES = 0;
                SequencingArtifactMetrics.PreAdapterDetailMetrics preAdapterDetailMetrics = (SequencingArtifactMetrics.PreAdapterDetailMetrics)((Object)((Map)hashMap.get(string2)).get(SequenceUtil.reverseComplement((String)string3)));
                SequencingArtifactMetrics.BaitBiasDetailMetrics baitBiasDetailMetrics = (SequencingArtifactMetrics.BaitBiasDetailMetrics)((Object)((Map)object422.get(string2)).get(string3));
                SequencingArtifactMetrics.BaitBiasDetailMetrics baitBiasDetailMetrics2 = (SequencingArtifactMetrics.BaitBiasDetailMetrics)((Object)((Map)object422.get(string2)).get(SequenceUtil.reverseComplement((String)string3)));
                cpcgMetrics.TOTAL_BASES = preAdapterDetailMetrics.PRO_REF_BASES + preAdapterDetailMetrics.PRO_ALT_BASES + preAdapterDetailMetrics.CON_REF_BASES + preAdapterDetailMetrics.CON_ALT_BASES;
                cpcgMetrics.REF_TOTAL_BASES = preAdapterDetailMetrics.PRO_REF_BASES + preAdapterDetailMetrics.CON_REF_BASES;
                cpcgMetrics.REF_NONOXO_BASES = preAdapterDetailMetrics.CON_REF_BASES;
                cpcgMetrics.REF_OXO_BASES = preAdapterDetailMetrics.PRO_REF_BASES;
                cpcgMetrics.ALT_NONOXO_BASES = preAdapterDetailMetrics.CON_ALT_BASES;
                cpcgMetrics.ALT_OXO_BASES = preAdapterDetailMetrics.PRO_ALT_BASES;
                cpcgMetrics.OXIDATION_ERROR_RATE = preAdapterDetailMetrics.ERROR_RATE;
                cpcgMetrics.OXIDATION_Q = preAdapterDetailMetrics.QSCORE;
                cpcgMetrics.C_REF_REF_BASES = baitBiasDetailMetrics.FWD_CXT_REF_BASES;
                cpcgMetrics.G_REF_REF_BASES = baitBiasDetailMetrics.REV_CXT_REF_BASES;
                cpcgMetrics.C_REF_ALT_BASES = baitBiasDetailMetrics.FWD_CXT_ALT_BASES;
                cpcgMetrics.G_REF_ALT_BASES = baitBiasDetailMetrics.REV_CXT_ALT_BASES;
                cpcgMetrics.C_REF_OXO_ERROR_RATE = baitBiasDetailMetrics.ERROR_RATE;
                cpcgMetrics.C_REF_OXO_Q = baitBiasDetailMetrics.QSCORE;
                cpcgMetrics.G_REF_OXO_ERROR_RATE = baitBiasDetailMetrics2.ERROR_RATE;
                cpcgMetrics.G_REF_OXO_Q = baitBiasDetailMetrics2.QSCORE;
                arrayList.add(cpcgMetrics);
            }
        }
        MetricsFile metricsFile = this.getMetricsFile();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (CollectOxoGMetrics.CpcgMetrics)((Object)iterator.next());
            metricsFile.addMetric((MetricBase)object);
        }
        metricsFile.write(file3);
        return 0;
    }

    private boolean isOxoG(Transition transition) {
        return transition.equals((Object)Transition.CtoA) || transition.equals((Object)Transition.GtoT);
    }
}

