/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SequenceUtil;
import java.io.File;
import java.util.List;
import java.util.Set;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.directed.CalculateHsMetrics;
import picard.analysis.directed.TargetMetricsCollector;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;
import picard.metrics.MultiLevelCollector;
import picard.metrics.MultilevelMetrics;

public abstract class CollectTargetedMetrics<METRIC extends MultilevelMetrics, COLLECTOR extends TargetMetricsCollector<METRIC>>
extends CommandLineProgram {
    private static final Log log = Log.getInstance(CalculateHsMetrics.class);
    @Option(shortName="TI", doc="An interval list file that contains the locations of the targets.", minElements=1)
    public List<File> TARGET_INTERVALS;
    @Option(shortName="I", doc="An aligned SAM or BAM file.")
    public File INPUT;
    @Option(shortName="O", doc="The output file to write the metrics to.")
    public File OUTPUT;
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.")
    public Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet((Object[])new MetricAccumulationLevel[]{MetricAccumulationLevel.ALL_READS});
    @Option(optional=true, doc="An optional file to output per target coverage information to.")
    public File PER_TARGET_COVERAGE;
    @Option(optional=true, doc="The maximum distance between a read and the nearest probe/bait/amplicon for the read to be considered 'near probe' and included in percent selected.")
    public int NEAR_DISTANCE = 250;

    protected abstract IntervalList getProbeIntervals();

    protected abstract String getProbeSetName();

    protected abstract COLLECTOR makeCollector(Set<MetricAccumulationLevel> var1, List<SAMReadGroupRecord> var2, ReferenceSequenceFile var3, File var4, IntervalList var5, IntervalList var6, String var7, int var8);

    @Override
    protected int doWork() {
        File file2;
        for (File file2 : this.TARGET_INTERVALS) {
            IOUtil.assertFileIsReadable((File)file2);
        }
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (this.PER_TARGET_COVERAGE != null) {
            IOUtil.assertFileIsWritable((File)this.PER_TARGET_COVERAGE);
        }
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        file2 = IntervalList.fromFiles(this.TARGET_INTERVALS);
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)samReader.getFileHeader().getSequenceDictionary(), (SAMSequenceDictionary)file2.getHeader().getSequenceDictionary());
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)samReader.getFileHeader().getSequenceDictionary(), (SAMSequenceDictionary)this.getProbeIntervals().getHeader().getSequenceDictionary());
        ReferenceSequenceFile referenceSequenceFile = null;
        if (this.REFERENCE_SEQUENCE != null) {
            IOUtil.assertFileIsReadable((File)this.REFERENCE_SEQUENCE);
            referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)this.REFERENCE_SEQUENCE);
            SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)samReader.getFileHeader().getSequenceDictionary(), (SAMSequenceDictionary)referenceSequenceFile.getSequenceDictionary(), (File)this.INPUT, (File)this.REFERENCE_SEQUENCE);
        }
        COLLECTOR COLLECTOR = this.makeCollector(this.METRIC_ACCUMULATION_LEVEL, samReader.getFileHeader().getReadGroups(), referenceSequenceFile, this.PER_TARGET_COVERAGE, (IntervalList)file2, this.getProbeIntervals(), this.getProbeSetName(), this.NEAR_DISTANCE);
        ProgressLogger progressLogger = new ProgressLogger(log);
        for (SAMRecord sAMRecord : samReader) {
            ((MultiLevelCollector)COLLECTOR).acceptRecord(sAMRecord, null);
            progressLogger.record(sAMRecord);
        }
        MetricsFile metricsFile = this.getMetricsFile();
        ((MultiLevelCollector)COLLECTOR).finish();
        ((MultiLevelCollector)COLLECTOR).addAllLevelsToFile(metricsFile);
        metricsFile.write(this.OUTPUT);
        CloserUtil.close((Object)samReader);
        return 0;
    }

    static String renderProbeNameFromFile(File file) {
        String string = file.getName();
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.PER_TARGET_COVERAGE != null && (this.METRIC_ACCUMULATION_LEVEL.size() != 1 || this.METRIC_ACCUMULATION_LEVEL.iterator().next() != MetricAccumulationLevel.ALL_READS)) {
            return new String[]{"PER_TARGET_COVERAGE can be specified only when METRIC_ACCUMULATION_LEVEL is set to ALL_READS."};
        }
        if (this.PER_TARGET_COVERAGE != null && this.REFERENCE_SEQUENCE == null) {
            return new String[]{"Must supply REFERENCE_SEQUENCE when supplying PER_TARGET_COVERAGE"};
        }
        return super.customCommandLineValidation();
    }
}

