/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.IntervalList;
import java.io.File;
import java.util.List;
import java.util.Set;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.directed.CollectTargetedMetrics;
import picard.analysis.directed.TargetedPcrMetrics;
import picard.analysis.directed.TargetedPcrMetricsCollector;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;

@CommandLineProgramProperties(usage="Calculates a set of metrics to Illumina Truseq Custom Amplicon sequencing from an aligned SAMor BAM file. If a reference sequence is provided, AT/GC dropout metrics will be calculated, and the PER_TARGET_COVERAGE option can be used to output GC and mean coverage information for every target.", usageShort="Produces Targeted PCR-related metrics given the provided SAM/BAM", programGroup=Metrics.class)
public class CollectTargetedPcrMetrics
extends CollectTargetedMetrics<TargetedPcrMetrics, TargetedPcrMetricsCollector> {
    @Option(shortName="AI", doc="An interval list file that contains the locations of the baits used.")
    public File AMPLICON_INTERVALS;
    @Option(shortName="N", doc="Custom amplicon set name. If not provided it is inferred from the filename of the AMPLICON_INTERVALS intervals.", optional=true)
    public String CUSTOM_AMPLICON_SET_NAME;

    @Override
    protected IntervalList getProbeIntervals() {
        return IntervalList.fromFile((File)this.AMPLICON_INTERVALS);
    }

    @Override
    protected String getProbeSetName() {
        return this.CUSTOM_AMPLICON_SET_NAME != null ? this.CUSTOM_AMPLICON_SET_NAME : CollectTargetedMetrics.renderProbeNameFromFile(this.AMPLICON_INTERVALS);
    }

    public static void main(String[] stringArray) {
        System.exit(new CollectTargetedPcrMetrics().instanceMain(stringArray));
    }

    @Override
    protected TargetedPcrMetricsCollector makeCollector(Set<MetricAccumulationLevel> set, List<SAMReadGroupRecord> list, ReferenceSequenceFile referenceSequenceFile, File file, IntervalList intervalList, IntervalList intervalList2, String string, int n) {
        return new TargetedPcrMetricsCollector(set, list, referenceSequenceFile, file, intervalList, intervalList2, string, n);
    }
}

