/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.IntervalList;
import java.io.File;
import java.util.List;
import java.util.Set;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.directed.HsMetrics;
import picard.analysis.directed.TargetMetrics;
import picard.analysis.directed.TargetMetricsCollector;
import picard.sam.DuplicationMetrics;

public class HsMetricCollector
extends TargetMetricsCollector<HsMetrics> {
    public HsMetricCollector(Set<MetricAccumulationLevel> set, List<SAMReadGroupRecord> list, ReferenceSequenceFile referenceSequenceFile, File file, IntervalList intervalList, IntervalList intervalList2, String string, int n) {
        super(set, list, referenceSequenceFile, file, intervalList, intervalList2, string, n);
    }

    @Override
    public HsMetrics convertMetric(TargetMetrics targetMetrics) {
        HsMetrics hsMetrics = new HsMetrics();
        TargetMetricsCollector.reflectiveCopy(targetMetrics, hsMetrics, new String[]{"PROBE_SET", "PROBE_TERRITORY", "ON_PROBE_BASES", "NEAR_PROBE_BASES", "OFF_PROBE_BASES", "PCT_OFF_PROBE", "ON_PROBE_VS_SELECTED", "MEAN_PROBE_COVERAGE"}, new String[]{"BAIT_SET", "BAIT_TERRITORY", "ON_BAIT_BASES", "NEAR_BAIT_BASES", "OFF_BAIT_BASES", "PCT_OFF_BAIT", "ON_BAIT_VS_SELECTED", "MEAN_BAIT_COVERAGE"});
        hsMetrics.BAIT_DESIGN_EFFICIENCY = (double)hsMetrics.TARGET_TERRITORY / (double)hsMetrics.BAIT_TERRITORY;
        hsMetrics.PCT_USABLE_BASES_ON_BAIT = (double)hsMetrics.ON_BAIT_BASES / (double)targetMetrics.PF_BASES;
        hsMetrics.PCT_USABLE_BASES_ON_TARGET = (double)hsMetrics.ON_TARGET_BASES / (double)targetMetrics.PF_BASES;
        hsMetrics.HS_LIBRARY_SIZE = DuplicationMetrics.estimateLibrarySize(targetMetrics.PF_SELECTED_PAIRS, targetMetrics.PF_SELECTED_UNIQUE_PAIRS);
        hsMetrics.HS_PENALTY_10X = this.calculateHsPenalty(hsMetrics.HS_LIBRARY_SIZE, targetMetrics, 10);
        hsMetrics.HS_PENALTY_20X = this.calculateHsPenalty(hsMetrics.HS_LIBRARY_SIZE, targetMetrics, 20);
        hsMetrics.HS_PENALTY_30X = this.calculateHsPenalty(hsMetrics.HS_LIBRARY_SIZE, targetMetrics, 30);
        hsMetrics.HS_PENALTY_40X = this.calculateHsPenalty(hsMetrics.HS_LIBRARY_SIZE, targetMetrics, 40);
        hsMetrics.HS_PENALTY_50X = this.calculateHsPenalty(hsMetrics.HS_LIBRARY_SIZE, targetMetrics, 50);
        hsMetrics.HS_PENALTY_100X = this.calculateHsPenalty(hsMetrics.HS_LIBRARY_SIZE, targetMetrics, 100);
        return hsMetrics;
    }

    private double calculateHsPenalty(Long l, TargetMetrics targetMetrics, int n) {
        double d;
        if (l == null) {
            return 0.0;
        }
        double d2 = (double)targetMetrics.ON_TARGET_FROM_PAIR_BASES / (double)targetMetrics.TARGET_TERRITORY;
        double d3 = targetMetrics.FOLD_80_BASE_PENALTY;
        long l2 = targetMetrics.PF_SELECTED_PAIRS;
        long l3 = targetMetrics.PF_SELECTED_UNIQUE_PAIRS;
        double d4 = (double)targetMetrics.ON_TARGET_BASES / (double)targetMetrics.PF_UQ_BASES_ALIGNED;
        double d5 = d = (double)n / d2 * d3;
        double d6 = 1.0;
        boolean bl = d >= 1.0;
        double d7 = -1.0;
        for (int i = 0; i < 10000; ++i) {
            double d8 = DuplicationMetrics.estimateRoi(l, d5, l2, l3);
            if (Math.abs(d8 - d) / d <= 0.001) {
                d7 = d5;
                break;
            }
            if (d8 > d && bl || d8 < d && !bl) {
                d6 /= 2.0;
                bl = !bl;
            }
            d5 += bl ? d6 : -d6;
        }
        if (d7 == -1.0) {
            return -1.0;
        }
        double d9 = (double)l3 * d / ((double)l2 * d7);
        return 1.0 / d9 * d3 * (1.0 / d4);
    }
}

