/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.FormatUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.directed.TargetMetrics;
import picard.metrics.MultilevelMetrics;
import picard.metrics.PerUnitMetricCollector;
import picard.metrics.SAMRecordMultiLevelCollector;
import picard.util.MathUtil;

public abstract class TargetMetricsCollector<METRIC_TYPE extends MultilevelMetrics>
extends SAMRecordMultiLevelCollector<METRIC_TYPE, Integer> {
    public static final int NEAR_PROBE_DISTANCE_DEFAULT = 250;
    private int nearProbeDistance = 250;
    private final File perTargetCoverage;
    private final String probeSetName;
    private static final Log log = Log.getInstance(TargetMetricsCollector.class);
    private final IntervalList allProbes;
    private final IntervalList allTargets;
    private final OverlapDetector<Interval> targetDetector;
    private final OverlapDetector<Interval> probeDetector;
    private Map<Interval, Double> intervalToGc = null;
    private final long probeTerritory;
    private final long targetTerritory;
    private final long genomeSize;
    private Map<Interval, Coverage> coverageByTargetForRead;
    private Coverage[] cov;

    public int getNearProbeDistance() {
        return this.nearProbeDistance;
    }

    public void setNearProbeDistance(int n) {
        this.nearProbeDistance = n;
    }

    public abstract METRIC_TYPE convertMetric(TargetMetrics var1);

    protected static <MT extends MetricBase> void reflectiveCopy(TargetMetrics targetMetrics, MT MT, String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            if (stringArray2 != null) {
                throw new PicardException("Target keys is null but output keys == " + StringUtil.join((String)",", (Object[])stringArray2));
            }
            if (stringArray != null) {
                throw new PicardException("Output keys is null but target keys == " + StringUtil.join((String)",", (Object[])stringArray));
            }
        } else if (stringArray.length != stringArray2.length) {
            throw new PicardException("Target keys and output keys do not have the same length: targetKeys == (" + StringUtil.join((String)",", (Object[])stringArray) + ") " + "outputKeys == (" + StringUtil.join((String)",", (Object[])stringArray2) + ")");
        }
        Class<?> clazz = MT.getClass();
        Set set = CollectionUtil.makeSet((Object[])TargetMetrics.class.getFields());
        for (String string : stringArray) {
            if (!set.contains(string)) continue;
            set.remove(string);
        }
        HashSet hashSet = new HashSet();
        for (Field field : MT.getClass().getFields()) {
            hashSet.add(field.getName());
        }
        for (Field field : set) {
            if (!hashSet.contains(field.getName())) continue;
            try {
                Field field2 = clazz.getField(field.getName());
                field2.set(MT, field.get((Object)targetMetrics));
            }
            catch (Exception exception) {
                throw new PicardException("Exception while copying targetMetrics to " + MT.getClass().getName(), exception);
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Field field = TargetMetrics.class.getField(stringArray[i]);
                Field field3 = clazz.getField(stringArray2[i]);
                field3.set(MT, field.get((Object)targetMetrics));
                continue;
            }
            catch (Exception exception) {
                throw new PicardException("Exception while copying TargetMetrics." + stringArray[i] + " to " + clazz.getName() + "." + stringArray2[i], exception);
            }
        }
    }

    public TargetMetricsCollector(Set<MetricAccumulationLevel> set, List<SAMReadGroupRecord> list, ReferenceSequenceFile referenceSequenceFile, File file, IntervalList intervalList, IntervalList intervalList2, String string, int n) {
        this.perTargetCoverage = file;
        this.probeSetName = string;
        this.nearProbeDistance = n;
        this.allProbes = intervalList2;
        this.allTargets = intervalList;
        List list2 = this.allProbes.uniqued().getIntervals();
        this.probeDetector = new OverlapDetector(-this.nearProbeDistance, 0);
        this.probeDetector.addAll(list2, list2);
        this.probeTerritory = Interval.countBases((Collection)list2);
        List list3 = this.allTargets.uniqued().getIntervals();
        this.targetDetector = new OverlapDetector(0, 0);
        this.targetDetector.addAll(list3, list3);
        this.targetTerritory = Interval.countBases((Collection)list3);
        int n2 = 0;
        this.cov = new Coverage[list3.size()];
        this.coverageByTargetForRead = new LinkedHashMap<Interval, Coverage>(list3.size() * 2, 0.5f);
        for (Interval interval : list3) {
            Iterator iterator = new Coverage(interval, 0);
            this.coverageByTargetForRead.put(interval, (Coverage)((Object)iterator));
            this.cov[n2++] = iterator;
        }
        long l = 0L;
        for (SAMSequenceRecord sAMSequenceRecord : this.allProbes.getHeader().getSequenceDictionary().getSequences()) {
            l += (long)sAMSequenceRecord.getSequenceLength();
        }
        this.genomeSize = l;
        if (referenceSequenceFile != null) {
            this.intervalToGc = new HashMap<Interval, Double>();
            for (SAMSequenceRecord sAMSequenceRecord : list3) {
                ReferenceSequence referenceSequence = referenceSequenceFile.getSubsequenceAt(sAMSequenceRecord.getSequence(), (long)sAMSequenceRecord.getStart(), (long)sAMSequenceRecord.getEnd());
                this.intervalToGc.put((Interval)sAMSequenceRecord, SequenceUtil.calculateGc((byte[])referenceSequence.getBases()));
            }
        }
        this.setup(set, list);
    }

    @Override
    protected PerUnitMetricCollector<METRIC_TYPE, Integer, SAMRecord> makeChildCollector(String string, String string2, String string3) {
        PerUnitTargetMetricCollector perUnitTargetMetricCollector = new PerUnitTargetMetricCollector(this.probeSetName, this.coverageByTargetForRead.keySet(), string, string2, string3, this.probeTerritory, this.targetTerritory, this.genomeSize, this.intervalToGc);
        if (this.probeSetName != null) {
            perUnitTargetMetricCollector.setBaitSetName(this.probeSetName);
        }
        return perUnitTargetMetricCollector;
    }

    @Override
    protected PerUnitMetricCollector<METRIC_TYPE, Integer, SAMRecord> makeAllReadCollector() {
        PerUnitTargetMetricCollector perUnitTargetMetricCollector = (PerUnitTargetMetricCollector)this.makeChildCollector(null, null, null);
        if (this.perTargetCoverage != null) {
            perUnitTargetMetricCollector.setPerTargetOutput(this.perTargetCoverage);
        }
        return perUnitTargetMetricCollector;
    }

    public static class Coverage {
        private final Interval interval;
        private final int[] depths;

        public Coverage(Interval interval, int n) {
            this.interval = interval;
            this.depths = new int[this.interval.length() + 2 * n];
        }

        public void addBase(int n) {
            if (n >= 0 && n < this.depths.length && this.depths[n] < Integer.MAX_VALUE) {
                int n2 = n;
                this.depths[n2] = this.depths[n2] + 1;
            }
        }

        public boolean hasCoverage() {
            for (int n : this.depths) {
                if (n <= 1) continue;
                return true;
            }
            return false;
        }

        public int[] getDepths() {
            return this.depths;
        }

        public int getTotal() {
            int n = 0;
            for (int i = 0; i < this.depths.length; ++i) {
                n += this.depths[i];
            }
            return n;
        }

        public String toString() {
            return "TargetedMetricCollector(interval=" + this.interval + ", depths = [" + StringUtil.intValuesToString((int[])this.depths) + "])";
        }
    }

    public class PerUnitTargetMetricCollector
    implements PerUnitMetricCollector<METRIC_TYPE, Integer, SAMRecord> {
        private final Map<Interval, Double> intervalToGc;
        private File perTargetOutput;
        private final Map<Interval, Coverage> coverageByTarget;
        private final TargetMetrics metrics = new TargetMetrics();

        public PerUnitTargetMetricCollector(String string, Set<Interval> set, String string2, String string3, String string4, long l, long l2, long l3, Map<Interval, Double> map) {
            this.metrics.SAMPLE = string2;
            this.metrics.LIBRARY = string3;
            this.metrics.READ_GROUP = string4;
            this.metrics.PROBE_SET = string;
            this.metrics.PROBE_TERRITORY = l;
            this.metrics.TARGET_TERRITORY = l2;
            this.metrics.GENOME_SIZE = l3;
            this.coverageByTarget = new LinkedHashMap<Interval, Coverage>(set.size() * 2, 0.5f);
            for (Interval interval : set) {
                this.coverageByTarget.put(interval, new Coverage(interval, 0));
            }
            this.intervalToGc = map;
        }

        public void setPerTargetOutput(File file) {
            this.perTargetOutput = file;
        }

        public void setBaitSetName(String string) {
            this.metrics.PROBE_SET = string;
        }

        @Override
        public void acceptRecord(SAMRecord sAMRecord) {
            int n;
            boolean bl;
            Collection collection;
            Collection collection2;
            if (sAMRecord.isSecondaryOrSupplementary()) {
                return;
            }
            ++this.metrics.TOTAL_READS;
            if (sAMRecord.getReadFailsVendorQualityCheckFlag()) {
                return;
            }
            if (!sAMRecord.getReadUnmappedFlag()) {
                Interval interval = new Interval(sAMRecord.getReferenceName(), sAMRecord.getAlignmentStart(), sAMRecord.getAlignmentEnd());
                collection2 = TargetMetricsCollector.this.targetDetector.getOverlaps(interval);
                collection = TargetMetricsCollector.this.probeDetector.getOverlaps(interval);
            } else {
                collection2 = null;
                collection = null;
            }
            ++this.metrics.PF_READS;
            this.metrics.PF_BASES += (long)sAMRecord.getReadLength();
            if (sAMRecord.getReadPairedFlag() && sAMRecord.getFirstOfPairFlag() && !sAMRecord.getReadUnmappedFlag() && !sAMRecord.getMateUnmappedFlag() && collection != null && !collection.isEmpty()) {
                ++this.metrics.PF_SELECTED_PAIRS;
                if (!sAMRecord.getDuplicateReadFlag()) {
                    ++this.metrics.PF_SELECTED_UNIQUE_PAIRS;
                }
            }
            if (sAMRecord.getDuplicateReadFlag()) {
                return;
            }
            ++this.metrics.PF_UNIQUE_READS;
            if (sAMRecord.getReadUnmappedFlag() || sAMRecord.getMappingQuality() == 0) {
                return;
            }
            ++this.metrics.PF_UQ_READS_ALIGNED;
            for (Object object : sAMRecord.getAlignmentBlocks()) {
                this.metrics.PF_UQ_BASES_ALIGNED += (long)object.getLength();
            }
            boolean bl2 = bl = sAMRecord.getReadPairedFlag() && !sAMRecord.getMateUnmappedFlag();
            if (collection2 != null && !collection2.isEmpty()) {
                for (Interval interval : collection2) {
                    Object object = this.coverageByTarget.get(interval);
                    for (Object object2 : sAMRecord.getAlignmentBlocks()) {
                        int n2 = CoordMath.getEnd((int)object2.getReferenceStart(), (int)object2.getLength());
                        for (n = object2.getReferenceStart(); n <= n2; ++n) {
                            if (n < interval.getStart() || n > interval.getEnd()) continue;
                            ++this.metrics.ON_TARGET_BASES;
                            if (bl) {
                                ++this.metrics.ON_TARGET_FROM_PAIR_BASES;
                            }
                            ((Coverage)object).addBase(n - interval.getStart());
                        }
                    }
                }
            }
            int n3 = 0;
            for (Object object : sAMRecord.getAlignmentBlocks()) {
                n3 += object.getLength();
            }
            int n4 = 0;
            if (collection != null && !collection.isEmpty()) {
                for (Interval interval : collection) {
                    for (AlignmentBlock alignmentBlock : sAMRecord.getAlignmentBlocks()) {
                        n = CoordMath.getEnd((int)alignmentBlock.getReferenceStart(), (int)alignmentBlock.getLength());
                        for (int i = alignmentBlock.getReferenceStart(); i <= n; ++i) {
                            if (i < interval.getStart() || i > interval.getEnd()) continue;
                            ++n4;
                        }
                    }
                }
                this.metrics.ON_PROBE_BASES += (long)n4;
                this.metrics.NEAR_PROBE_BASES += (long)(n3 - n4);
            } else {
                this.metrics.OFF_PROBE_BASES += (long)n3;
            }
        }

        @Override
        public void finish() {
            this.metrics.PCT_PF_READS = (double)this.metrics.PF_READS / (double)this.metrics.TOTAL_READS;
            this.metrics.PCT_PF_UQ_READS = (double)this.metrics.PF_UNIQUE_READS / (double)this.metrics.TOTAL_READS;
            this.metrics.PCT_PF_UQ_READS_ALIGNED = (double)this.metrics.PF_UQ_READS_ALIGNED / (double)this.metrics.PF_UNIQUE_READS;
            double d = this.metrics.ON_PROBE_BASES + this.metrics.NEAR_PROBE_BASES + this.metrics.OFF_PROBE_BASES;
            this.metrics.PCT_SELECTED_BASES = (double)(this.metrics.ON_PROBE_BASES + this.metrics.NEAR_PROBE_BASES) / d;
            this.metrics.PCT_OFF_PROBE = (double)this.metrics.OFF_PROBE_BASES / d;
            this.metrics.ON_PROBE_VS_SELECTED = (double)this.metrics.ON_PROBE_BASES / (double)(this.metrics.ON_PROBE_BASES + this.metrics.NEAR_PROBE_BASES);
            this.metrics.MEAN_PROBE_COVERAGE = (double)this.metrics.ON_PROBE_BASES / (double)this.metrics.PROBE_TERRITORY;
            this.metrics.FOLD_ENRICHMENT = (double)this.metrics.ON_PROBE_BASES / d / ((double)this.metrics.PROBE_TERRITORY / (double)this.metrics.GENOME_SIZE);
            this.calculateTargetCoverageMetrics();
            this.calculateGcMetrics();
        }

        private void calculateTargetCoverageMetrics() {
            int n5;
            int[] nArray = new int[(int)this.metrics.TARGET_TERRITORY];
            int n2 = 0;
            int n3 = 0;
            double d = 0.0;
            int n4 = 0;
            for (Coverage coverage : this.coverageByTarget.values()) {
                if (!coverage.hasCoverage()) {
                    ++n2;
                    continue;
                }
                int[] nArray2 = coverage.getDepths();
                n4 += nArray2.length;
                for (int n5 : nArray2) {
                    nArray[n3++] = n5;
                    d += (double)n5;
                }
            }
            this.metrics.MEAN_TARGET_COVERAGE = d / (double)n4;
            Arrays.sort(nArray);
            int n6 = Math.max(nArray.length - 1 - n4 + (int)((double)n4 * 0.2), 0);
            if (nArray.length <= 0) {
                throw new PicardException("Interval list only contains one zero-length interval.");
            }
            int n7 = nArray[n6];
            this.metrics.FOLD_80_BASE_PENALTY = this.metrics.MEAN_TARGET_COVERAGE / (double)n7;
            this.metrics.ZERO_CVG_TARGETS_PCT = (double)n2 / (double)TargetMetricsCollector.this.allTargets.getIntervals().size();
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            n5 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            for (Coverage coverage : this.coverageByTarget.values()) {
                for (int n15 : coverage.getDepths()) {
                    ++n8;
                    if (n15 < 2) continue;
                    ++n9;
                    if (n15 < 10) continue;
                    ++n10;
                    if (n15 < 20) continue;
                    ++n11;
                    if (n15 < 30) continue;
                    ++n5;
                    if (n15 < 40) continue;
                    ++n12;
                    if (n15 < 50) continue;
                    ++n13;
                    if (n15 < 100) continue;
                    ++n14;
                }
            }
            this.metrics.PCT_TARGET_BASES_2X = (double)n9 / (double)n8;
            this.metrics.PCT_TARGET_BASES_10X = (double)n10 / (double)n8;
            this.metrics.PCT_TARGET_BASES_20X = (double)n11 / (double)n8;
            this.metrics.PCT_TARGET_BASES_30X = (double)n5 / (double)n8;
            this.metrics.PCT_TARGET_BASES_40X = (double)n12 / (double)n8;
            this.metrics.PCT_TARGET_BASES_50X = (double)n13 / (double)n8;
            this.metrics.PCT_TARGET_BASES_100X = (double)n14 / (double)n8;
        }

        private void calculateGcMetrics() {
            if (this.intervalToGc != null) {
                int n;
                double d;
                double d2;
                PrintWriter printWriter;
                log.info(new Object[]{"Calculating GC metrics"});
                FormatUtil formatUtil = new FormatUtil();
                try {
                    if (this.perTargetOutput != null) {
                        printWriter = new PrintWriter(this.perTargetOutput);
                        printWriter.println("chrom\tstart\tend\tlength\tname\t%gc\tmean_coverage\tnormalized_coverage\tmin_normalized_coverage");
                    } else {
                        printWriter = null;
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeIOException((Throwable)iOException);
                }
                long[] lArray = new long[101];
                long[] lArray2 = new long[101];
                for (Map.Entry<Interval, Coverage> entry : this.coverageByTarget.entrySet()) {
                    int n2;
                    Interval interval = entry.getKey();
                    Coverage coverage = entry.getValue();
                    if (interval.length() <= 0) {
                        log.warn(new Object[]{"interval of length zero found: " + interval + " skipped."});
                        continue;
                    }
                    double d3 = this.intervalToGc.get(interval);
                    int n3 = n2 = (int)Math.round(d3 * 100.0);
                    lArray[n3] = lArray[n3] + (long)interval.length();
                    int n4 = n2;
                    lArray2[n4] = lArray2[n4] + (long)coverage.getTotal();
                    if (printWriter == null) continue;
                    d2 = (double)coverage.getTotal() / (double)interval.length();
                    d = MathUtil.min(coverage.getDepths());
                    printWriter.println(interval.getSequence() + "\t" + interval.getStart() + "\t" + interval.getEnd() + "\t" + interval.length() + "\t" + interval.getName() + "\t" + formatUtil.format(d3) + "\t" + formatUtil.format(d2) + "\t" + formatUtil.format(d2 / this.metrics.MEAN_TARGET_COVERAGE) + "\t" + formatUtil.format(d / this.metrics.MEAN_TARGET_COVERAGE));
                }
                if (printWriter != null) {
                    printWriter.close();
                }
                long l = 0L;
                long l2 = 0L;
                for (n = 0; n < lArray.length; ++n) {
                    l += lArray[n];
                    l2 += lArray2[n];
                }
                for (n = 0; n < lArray.length; ++n) {
                    d2 = (double)lArray2[n] / (double)l2;
                    double d4 = (double)lArray[n] / (double)l;
                    d = (d2 - d4) * 100.0;
                    if (!(d < 0.0)) continue;
                    d = Math.abs(d);
                    if (n <= 50) {
                        this.metrics.AT_DROPOUT += d;
                    }
                    if (n < 50) continue;
                    this.metrics.GC_DROPOUT += d;
                }
            }
        }

        @Override
        public void addMetricsToFile(MetricsFile<METRIC_TYPE, Integer> metricsFile) {
            metricsFile.addMetric(TargetMetricsCollector.this.convertMetric(this.metrics));
        }
    }
}

