/*
 * Decompiled with CFR 0.152.
 */
package picard.annotation;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import picard.annotation.AnnotationException;
import picard.annotation.Gene;
import picard.util.TabbedTextFileWithHeaderParser;

public class RefFlatReader {
    private static final Log LOG = Log.getInstance(RefFlatReader.class);
    private static final String[] RefFlatColumnLabels = new String[RefFlatColumns.values().length];
    private final File refFlatFile;
    private final SAMSequenceDictionary sequenceDictionary;

    RefFlatReader(File file, SAMSequenceDictionary sAMSequenceDictionary) {
        this.refFlatFile = file;
        this.sequenceDictionary = sAMSequenceDictionary;
    }

    static OverlapDetector<Gene> load(File file, SAMSequenceDictionary sAMSequenceDictionary) {
        return new RefFlatReader(file, sAMSequenceDictionary).load();
    }

    OverlapDetector<Gene> load() {
        Object object;
        OverlapDetector overlapDetector = new OverlapDetector(0, 0);
        int n = RefFlatColumns.values().length;
        TabbedTextFileWithHeaderParser tabbedTextFileWithHeaderParser = new TabbedTextFileWithHeaderParser(this.refFlatFile, RefFlatColumnLabels);
        HashMap<Object, ArrayList<TabbedTextFileWithHeaderParser.Row>> hashMap = new HashMap<Object, ArrayList<TabbedTextFileWithHeaderParser.Row>>();
        for (TabbedTextFileWithHeaderParser.Row row : tabbedTextFileWithHeaderParser) {
            int n2 = tabbedTextFileWithHeaderParser.getCurrentLineNumber();
            if (row.getFields().length != n) {
                throw new AnnotationException("Wrong number of fields in refFlat file " + this.refFlatFile + " at line " + n2);
            }
            Object object2 = row.getField(RefFlatColumns.GENE_NAME.name());
            object = row.getField(RefFlatColumns.TRANSCRIPT_NAME.name());
            String string = (String)object2 + ":" + (String)object;
            String string2 = row.getField(RefFlatColumns.CHROMOSOME.name());
            if (!this.isSequenceRecognized(string2)) {
                LOG.debug(new Object[]{"Skipping " + string + " due to unrecognized sequence " + string2});
                continue;
            }
            ArrayList<TabbedTextFileWithHeaderParser.Row> arrayList = (ArrayList<TabbedTextFileWithHeaderParser.Row>)hashMap.get(object2);
            if (arrayList == null) {
                arrayList = new ArrayList<TabbedTextFileWithHeaderParser.Row>();
                hashMap.put(object2, arrayList);
            }
            arrayList.add(row);
        }
        int n3 = 0;
        int n4 = 0;
        for (Object object2 : hashMap.values()) {
            try {
                object = this.makeGeneFromRefFlatLines((List<TabbedTextFileWithHeaderParser.Row>)object2);
                overlapDetector.addLhs(object, (Interval)object);
                if (object.length() > n3) {
                    n3 = object.length();
                }
                if (object.length() <= 1000000) continue;
                ++n4;
            }
            catch (AnnotationException annotationException) {
                LOG.debug(new Object[]{annotationException.getMessage() + " -- skipping"});
            }
        }
        LOG.debug(new Object[]{"Longest gene: " + n3 + "; number of genes > 1MB: " + n4});
        return overlapDetector;
    }

    private boolean isSequenceRecognized(String string) {
        return this.sequenceDictionary.getSequence(string) != null;
    }

    private Gene makeGeneFromRefFlatLines(List<TabbedTextFileWithHeaderParser.Row> list) {
        String string = list.get(0).getField(RefFlatColumns.GENE_NAME.name());
        String string2 = list.get(0).getField(RefFlatColumns.STRAND.name());
        boolean bl = string2.equals("-");
        String string3 = list.get(0).getField(RefFlatColumns.CHROMOSOME.name());
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        for (TabbedTextFileWithHeaderParser.Row object : list) {
            n = Math.min(n, object.getIntegerField(RefFlatColumns.TX_START.name()) + 1);
            n2 = Math.max(n2, object.getIntegerField(RefFlatColumns.TX_END.name()));
        }
        Gene gene = new Gene(string3, n, n2, bl, string);
        for (TabbedTextFileWithHeaderParser.Row row : list) {
            if (!string2.equals(row.getField(RefFlatColumns.STRAND.name()))) {
                throw new AnnotationException("Strand disagreement in refFlat file for gene " + string);
            }
            if (!string3.equals(row.getField(RefFlatColumns.CHROMOSOME.name()))) {
                throw new AnnotationException("Chromosome disagreement(" + string3 + " != " + row.getField(RefFlatColumns.CHROMOSOME.name()) + ") in refFlat file for gene " + string);
            }
            Gene.Transcript transcript = this.makeTranscriptFromRefFlatLine(gene, row);
        }
        return gene;
    }

    private Gene.Transcript makeTranscriptFromRefFlatLine(Gene gene, TabbedTextFileWithHeaderParser.Row row) {
        String string = row.getField(RefFlatColumns.GENE_NAME.name());
        String string2 = row.getField(RefFlatColumns.TRANSCRIPT_NAME.name());
        String string3 = string + ":" + string2;
        int n = Integer.parseInt(row.getField(RefFlatColumns.EXON_COUNT.name()));
        String[] stringArray = row.getField(RefFlatColumns.EXON_STARTS.name()).split(",");
        String[] stringArray2 = row.getField(RefFlatColumns.EXON_ENDS.name()).split(",");
        if (n != stringArray.length) {
            throw new AnnotationException("Number of exon starts does not agree with number of exons for " + string3);
        }
        if (n != stringArray2.length) {
            throw new AnnotationException("Number of exon ends does not agree with number of exons for " + string3);
        }
        int n2 = row.getIntegerField(RefFlatColumns.TX_START.name()) + 1;
        int n3 = row.getIntegerField(RefFlatColumns.TX_END.name());
        int n4 = row.getIntegerField(RefFlatColumns.CDS_START.name()) + 1;
        int n5 = row.getIntegerField(RefFlatColumns.CDS_END.name());
        Gene.Transcript transcript = gene.addTranscript(string2, n2, n3, n4, n5, n);
        for (int i = 0; i < n; ++i) {
            Gene.Transcript.Exon exon = transcript.addExon(Integer.parseInt(stringArray[i]) + 1, Integer.parseInt(stringArray2[i]));
            if (exon.start > exon.end) {
                throw new AnnotationException("Exon has 0 or negative extent for " + string3);
            }
            if (i <= 0 || transcript.exons[i - 1].end < transcript.exons[i].start) continue;
            throw new AnnotationException("Exons overlap for " + string3);
        }
        return transcript;
    }

    static {
        for (int i = 0; i < RefFlatColumnLabels.length; ++i) {
            RefFlatReader.RefFlatColumnLabels[i] = RefFlatColumns.values()[i].name();
        }
    }

    public static enum RefFlatColumns {
        GENE_NAME,
        TRANSCRIPT_NAME,
        CHROMOSOME,
        STRAND,
        TX_START,
        TX_END,
        CDS_START,
        CDS_END,
        EXON_COUNT,
        EXON_STARTS,
        EXON_ENDS;

    }
}

