/*
 * Decompiled with CFR 0.152.
 */
package picard.cmdline;

import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassFinder {
    private final Set<Class<?>> classes = new HashSet();
    private final ClassLoader loader;
    private Class<?> parentType;
    private String jarPath = null;
    private static final Log log = Log.getInstance(ClassFinder.class);

    public ClassFinder() {
        this.loader = Thread.currentThread().getContextClassLoader();
    }

    public ClassFinder(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public ClassFinder(File file) throws IOException {
        this.jarPath = file.getCanonicalPath();
        URL[] uRLArray = new URL[]{new File(this.jarPath).toURI().toURL()};
        this.loader = new URLClassLoader(uRLArray, Thread.currentThread().getContextClassLoader());
    }

    public String toClassName(String string) {
        return string.substring(0, string.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }

    public void find(String string, Class<?> clazz) {
        Enumeration<URL> enumeration;
        this.parentType = clazz;
        string = string.replace('.', '/');
        try {
            enumeration = this.loader.getResources(string);
        }
        catch (IOException iOException) {
            log.warn(new Object[]{"Could not read package: " + string, iOException});
            return;
        }
        while (enumeration.hasMoreElements()) {
            try {
                Comparable<URI> comparable;
                String string2 = enumeration.nextElement().getFile();
                try {
                    comparable = new URI(string2);
                    string2 = ((URI)comparable).getPath();
                }
                catch (URISyntaxException uRISyntaxException) {
                    log.warn(new Object[]{"Cannot convert to URI the " + string2 + " URL"});
                }
                if (string2.indexOf(33) > 0) {
                    string2 = string2.substring(0, string2.indexOf(33));
                }
                if (this.jarPath != null && !this.jarPath.equals(string2)) continue;
                comparable = new File(string2);
                if (((File)comparable).isDirectory()) {
                    this.scanDir((File)comparable, string);
                    continue;
                }
                this.scanJar((File)comparable, string);
            }
            catch (IOException iOException) {
                log.warn(new Object[]{"could not read entries", iOException});
            }
        }
    }

    protected void scanJar(File file, String string) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string2 = zipEntry.getName();
            if (!string2.startsWith(string)) continue;
            this.handleItem(string2);
        }
    }

    protected void scanDir(File file, String string) {
        for (File file2 : file.listFiles()) {
            String string2;
            String string3 = string2 = string == null ? file2.getName() : string + '/' + file2.getName();
            if (file2.isDirectory()) {
                this.scanDir(file2, string2);
                continue;
            }
            this.handleItem(string2);
        }
    }

    protected void handleItem(String string) {
        if (string.endsWith(".class")) {
            String string2 = this.toClassName(string);
            try {
                Class<?> clazz = this.loader.loadClass(string2);
                if (this.parentType.isAssignableFrom(clazz)) {
                    this.classes.add(clazz);
                }
            }
            catch (Throwable throwable) {
                log.debug(new Object[]{"could not load class: " + string2, throwable});
            }
        }
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }
}

