/*
 * Decompiled with CFR 0.152.
 */
package picard.cmdline;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.metrics.Header;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.metrics.StringHeader;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.zip.DeflaterFactory;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import java.io.File;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import picard.cmdline.CommandLineParser;
import picard.cmdline.Option;

public abstract class CommandLineProgram {
    @Option(common=true, optional=true)
    public List<File> TMP_DIR = new ArrayList<File>();
    @Option(doc="Control verbosity of logging.", common=true)
    public Log.LogLevel VERBOSITY = Log.LogLevel.INFO;
    @Option(doc="Whether to suppress job-summary info on System.err.", common=true)
    public Boolean QUIET = false;
    @Option(doc="Validation stringency for all SAM files read by this program.  Setting stringency to SILENT can improve performance when processing a BAM file in which variable-length data (read, qualities, tags) do not otherwise need to be decoded.", common=true)
    public ValidationStringency VALIDATION_STRINGENCY = ValidationStringency.DEFAULT_STRINGENCY;
    @Option(doc="Compression level for all compressed files created (e.g. BAM and GELI).", common=true)
    public int COMPRESSION_LEVEL = BlockCompressedStreamConstants.DEFAULT_COMPRESSION_LEVEL;
    @Option(doc="When writing SAM files that need to be sorted, this will specify the number of records stored in RAM before spilling to disk. Increasing this number reduces the number of file handles needed to sort a SAM file, and increases the amount of RAM needed.", optional=true, common=true)
    public Integer MAX_RECORDS_IN_RAM = SAMFileWriterImpl.getDefaultMaxRecordsInRam();
    @Option(doc="Whether to create a BAM index when writing a coordinate-sorted BAM file.", common=true)
    public Boolean CREATE_INDEX = Defaults.CREATE_INDEX;
    @Option(doc="Whether to create an MD5 digest for any BAM or FASTQ files created.  ", common=true)
    public boolean CREATE_MD5_FILE = Defaults.CREATE_MD5;
    @Option(shortName="R", doc="Reference sequence file.", common=true, optional=true, overridable=true)
    public File REFERENCE_SEQUENCE = Defaults.REFERENCE_FASTA;
    @Option(doc="Google Genomics API client_secrets.json file path.", common=true)
    public String GA4GH_CLIENT_SECRETS = "client_secrets.json";
    private final String standardUsagePreamble = CommandLineParser.getStandardUsagePreamble(this.getClass());
    private CommandLineParser commandLineParser;
    private final List<Header> defaultHeaders = new ArrayList<Header>();
    private String commandLine;

    protected abstract int doWork();

    public void instanceMainWithExit(String[] stringArray) {
        System.exit(this.instanceMain(stringArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int instanceMain(String[] stringArray) {
        if (!this.parseArgs(stringArray)) {
            return 1;
        }
        if (this.TMP_DIR == null) {
            this.TMP_DIR = new ArrayList<File>();
        }
        if (this.TMP_DIR.isEmpty()) {
            this.TMP_DIR.add(IOUtil.getDefaultTmpDir());
        }
        Date date = new Date();
        this.defaultHeaders.add((Header)new StringHeader(this.commandLine));
        this.defaultHeaders.add((Header)new StringHeader("Started on: " + date));
        Log.setGlobalLogLevel((Log.LogLevel)this.VERBOSITY);
        if (System.getProperty("ga4gh.client_secrets") == null) {
            System.setProperty("ga4gh.client_secrets", this.GA4GH_CLIENT_SECRETS);
        }
        SamReaderFactory.setDefaultValidationStringency((ValidationStringency)this.VALIDATION_STRINGENCY);
        BlockCompressedOutputStream.setDefaultCompressionLevel((int)this.COMPRESSION_LEVEL);
        if (this.VALIDATION_STRINGENCY != ValidationStringency.STRICT) {
            VariantContextWriterBuilder.setDefaultOption((Options)Options.ALLOW_MISSING_FIELDS_IN_HEADER);
        }
        if (this.MAX_RECORDS_IN_RAM != null) {
            SAMFileWriterImpl.setDefaultMaxRecordsInRam((int)this.MAX_RECORDS_IN_RAM);
        }
        if (this.CREATE_INDEX.booleanValue()) {
            SAMFileWriterFactory.setDefaultCreateIndexWhileWriting((boolean)true);
        }
        SAMFileWriterFactory.setDefaultCreateMd5File((boolean)this.CREATE_MD5_FILE);
        for (File comparable : this.TMP_DIR) {
            if (!comparable.exists()) {
                comparable.mkdirs();
            }
            comparable.setReadable(true, false);
            comparable.setWritable(true, false);
            System.setProperty("java.io.tmpdir", comparable.getAbsolutePath());
        }
        if (!this.QUIET.booleanValue()) {
            System.err.println("[" + new Date() + "] " + this.commandLine);
            try {
                System.err.println("[" + new Date() + "] Executing as " + System.getProperty("user.name") + "@" + InetAddress.getLocalHost().getHostName() + " on " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + "; " + System.getProperty("java.vm.name") + " " + System.getProperty("java.runtime.version") + "; Picard version: " + this.commandLineParser.getVersion() + " " + (DeflaterFactory.usingIntelDeflater() ? "IntelDeflater" : "JdkDeflater"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n = -1;
        try {
            n = this.doWork();
        }
        finally {
            try {
                if (!this.QUIET.booleanValue()) {
                    Date throwable = new Date();
                    double d = (double)(throwable.getTime() - date.getTime()) / 60000.0;
                    String string = new DecimalFormat("#,##0.00").format(d);
                    System.err.println("[" + throwable + "] " + this.getClass().getName() + " done. Elapsed time: " + string + " minutes.");
                    System.err.println("Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory());
                    if (n != 0 && CommandLineParser.hasWebDocumentation(this.getClass())) {
                        System.err.println(CommandLineParser.getFaqLink());
                    }
                }
            }
            catch (Throwable throwable) {}
        }
        return n;
    }

    protected String[] customCommandLineValidation() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : this.getNestedOptions().values()) {
            CommandLineProgram commandLineProgram;
            String[] stringArray;
            if (!(object instanceof CommandLineProgram) || (stringArray = (commandLineProgram = (CommandLineProgram)object).customCommandLineValidation()) == null) continue;
            for (String string : stringArray) {
                arrayList.add(string);
            }
        }
        if (!arrayList.isEmpty()) {
            arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }

    protected boolean parseArgs(String[] stringArray) {
        this.commandLineParser = new CommandLineParser(this);
        boolean bl = this.commandLineParser.parseOptions(System.err, stringArray);
        this.commandLine = this.commandLineParser.getCommandLine();
        if (!bl) {
            return false;
        }
        String[] stringArray2 = this.customCommandLineValidation();
        if (stringArray2 != null) {
            for (String string : stringArray2) {
                System.err.println(string);
            }
            this.commandLineParser.usage(System.err, false);
            return false;
        }
        return true;
    }

    protected <A extends MetricBase, B extends Comparable<?>> MetricsFile<A, B> getMetricsFile() {
        MetricsFile metricsFile = new MetricsFile();
        for (Header header : this.defaultHeaders) {
            metricsFile.addHeader(header);
        }
        return metricsFile;
    }

    public String getStandardUsagePreamble() {
        return this.standardUsagePreamble;
    }

    public CommandLineParser getCommandLineParser() {
        return this.commandLineParser;
    }

    public String getVersion() {
        return this.getCommandLineParser().getVersion();
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setDefaultHeaders(List<Header> list) {
        this.defaultHeaders.clear();
        this.defaultHeaders.addAll(list);
    }

    public List<Header> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public Map<String, Object> getNestedOptions() {
        return CommandLineParser.getNestedOptions(this);
    }

    public Map<String, Object> getNestedOptionsForHelp() {
        return this.getNestedOptions();
    }

    static {
        if (System.getProperty("samjdk.custom_reader") == null) {
            System.setProperty("samjdk.custom_reader", "https://www.googleapis.com/genomics,com.google.cloud.genomics.gatk.htsjdk.GA4GHReaderFactory");
        }
    }
}

