/*
 * Decompiled with CFR 0.152.
 */
package picard.cmdline;

import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.StringUtil;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import picard.cmdline.ClassFinder;
import picard.cmdline.CommandLineDefaults;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramGroup;
import picard.cmdline.CommandLineProgramProperties;

public class PicardCommandLine {
    private static final Log log = Log.getInstance(PicardCommandLine.class);
    private static final String KNRM = PicardCommandLine.initializeColor("\u001b[0m");
    private static final String KBLD = PicardCommandLine.initializeColor("\u001b[1m");
    private static final String KRED = PicardCommandLine.initializeColor("\u001b[31m");
    private static final String KGRN = PicardCommandLine.initializeColor("\u001b[32m");
    private static final String KYEL = PicardCommandLine.initializeColor("\u001b[33m");
    private static final String KBLU = PicardCommandLine.initializeColor("\u001b[34m");
    private static final String KMAG = PicardCommandLine.initializeColor("\u001b[35m");
    private static final String KCYN = PicardCommandLine.initializeColor("\u001b[36m");
    private static final String KWHT = PicardCommandLine.initializeColor("\u001b[37m");
    private static final String KBLDRED = PicardCommandLine.initializeColor("\u001b[1m\u001b[31m");
    private static final String COMMAND_LINE_NAME = PicardCommandLine.class.getSimpleName();
    private static final int HELP_SIMILARITY_FLOOR = 7;
    private static final int MINIMUM_SUBSTRING_LENGTH = 5;

    private static String initializeColor(String string) {
        if (CommandLineDefaults.COLOR_STATUS) {
            return string;
        }
        return "";
    }

    protected static List<String> getPackageList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("picard");
        return arrayList;
    }

    protected int instanceMain(String[] stringArray, List<String> list, String string) {
        CommandLineProgram commandLineProgram = PicardCommandLine.extractCommandLineProgram(stringArray, list, string);
        if (null == commandLineProgram) {
            return 1;
        }
        String[] stringArray2 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
        return commandLineProgram.instanceMain(stringArray2);
    }

    protected int instanceMain(String[] stringArray) {
        return this.instanceMain(stringArray, PicardCommandLine.getPackageList(), COMMAND_LINE_NAME);
    }

    public static void main(String[] stringArray) {
        System.exit(new PicardCommandLine().instanceMain(stringArray, PicardCommandLine.getPackageList(), COMMAND_LINE_NAME));
    }

    private static CommandLineProgram extractCommandLineProgram(String[] stringArray, List<String> list, String string) {
        ClassFinder classFinder = new ClassFinder();
        for (String object2 : list) {
            classFinder.find(object2, CommandLineProgram.class);
        }
        Object object3 = "";
        HashMap hashMap = new HashMap();
        for (Class<?> clazz : classFinder.getClasses()) {
            if (clazz.isInterface() || clazz.isSynthetic() || clazz.isPrimitive() || clazz.isLocalClass() || Modifier.isAbstract(clazz.getModifiers())) continue;
            CommandLineProgramProperties illegalAccessException = PicardCommandLine.getProgramProperty(clazz);
            if (null == illegalAccessException) {
                if (((String)object3).isEmpty()) {
                    object3 = (String)object3 + clazz.getSimpleName();
                    continue;
                }
                object3 = (String)object3 + ", " + clazz.getSimpleName();
                continue;
            }
            if (illegalAccessException.omitFromCommandLine()) continue;
            if (hashMap.containsKey(clazz.getSimpleName())) {
                throw new RuntimeException("Simple class name collision: " + clazz.getSimpleName());
            }
            hashMap.put(clazz.getSimpleName(), clazz);
        }
        if (!((String)object3).isEmpty()) {
            throw new RuntimeException("The following classes are missing the required CommandLineProgramProperties annotation: " + (String)object3);
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(hashMap.values());
        if (stringArray.length < 1) {
            PicardCommandLine.printUsage(hashSet, string);
        } else if (stringArray[0].equals("-h")) {
            PicardCommandLine.printUsage(hashSet, string);
        } else if (stringArray[0].equals("--list-commands")) {
            PicardCommandLine.printCommandList(hashSet);
        } else {
            if (hashMap.containsKey(stringArray[0])) {
                Class clazz = (Class)hashMap.get(stringArray[0]);
                try {
                    return (CommandLineProgram)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new RuntimeException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
            }
            PicardCommandLine.printUsage(hashSet, string);
            PicardCommandLine.printUnknown(hashSet, stringArray[0]);
        }
        return null;
    }

    public static CommandLineProgramProperties getProgramProperty(Class clazz) {
        return clazz.getAnnotation(CommandLineProgramProperties.class);
    }

    private static void printCommandList(Set<Class<?>> set) {
        PicardCommandLine.printUsage(set, null, true, true);
    }

    private static void printUsage(Set<Class<?>> set, String string) {
        PicardCommandLine.printUsage(set, string, false, false);
    }

    private static void printUsage(Set<Class<?>> set, String string, boolean bl, boolean bl2) {
        ArrayList illegalAccessException;
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl) {
            stringBuilder.append(KBLDRED + "USAGE: " + string + " " + KGRN + "<program name>" + KBLDRED + " [-h]\n\n" + KNRM);
            stringBuilder.append(KBLDRED + "Available Programs:\n" + KNRM);
        }
        HashMap<Class<? extends CommandLineProgramGroup>, Object> hashMap = new HashMap<Class<? extends CommandLineProgramGroup>, Object>();
        TreeMap treeMap = new TreeMap(CommandLineProgramGroup.comparator);
        HashMap hashMap2 = new HashMap();
        for (Class<?> clazz : set) {
            object2 = PicardCommandLine.getProgramProperty(clazz);
            if (null == object2) {
                throw new RuntimeException(String.format("The class '%s' is missing the required CommandLineProgramProperties annotation.", clazz.getSimpleName()));
            }
            hashMap2.put(clazz, (CommandLineProgramProperties)object2);
            object = (CommandLineProgramGroup)hashMap.get(object2.programGroup());
            if (null == object) {
                try {
                    object = object2.programGroup().newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new RuntimeException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException2) {
                    throw new RuntimeException(illegalAccessException2);
                }
                hashMap.put(object2.programGroup(), object);
            }
            if (null == (illegalAccessException = (List)treeMap.get(object))) {
                illegalAccessException = new ArrayList();
                treeMap.put((CommandLineProgramGroup)object, illegalAccessException);
            }
            illegalAccessException.add(clazz);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            object2 = (CommandLineProgramGroup)entry.getKey();
            if (!bl) {
                stringBuilder.append(KWHT + "--------------------------------------------------------------------------------------\n" + KNRM);
                stringBuilder.append(String.format("%s%-48s %-45s%s\n", KRED, object2.getName() + ":", object2.getDescription(), KNRM));
            }
            object = new ArrayList();
            object.addAll((Collection)entry.getValue());
            Collections.sort(object, new SimpleNameComparator());
            illegalAccessException = object.iterator();
            while (illegalAccessException.hasNext()) {
                Class clazz = (Class)illegalAccessException.next();
                CommandLineProgramProperties commandLineProgramProperties = (CommandLineProgramProperties)hashMap2.get(clazz);
                if (null == commandLineProgramProperties) {
                    throw new RuntimeException(String.format("Unexpected error: did not find the CommandLineProgramProperties annotation for '%s'", clazz.getSimpleName()));
                }
                if (!bl) {
                    if (clazz.getSimpleName().length() >= 45) {
                        stringBuilder.append(String.format("%s    %s    %s%s%s\n", KGRN, clazz.getSimpleName(), KCYN, commandLineProgramProperties.usageShort(), KNRM));
                        continue;
                    }
                    stringBuilder.append(String.format("%s    %-45s%s%s%s\n", KGRN, clazz.getSimpleName(), KCYN, commandLineProgramProperties.usageShort(), KNRM));
                    continue;
                }
                stringBuilder.append(clazz.getSimpleName() + "\n");
            }
            if (bl) continue;
            stringBuilder.append(String.format("\n", new Object[0]));
        }
        if (!bl) {
            stringBuilder.append(KWHT + "--------------------------------------------------------------------------------------\n\n" + KNRM);
        }
        if (bl2) {
            System.out.print(stringBuilder.toString());
        } else {
            System.err.print(stringBuilder.toString());
        }
    }

    public static void printUnknown(Set<Class<?>> set, String string) {
        HashMap hashMap = new HashMap();
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        for (Class<?> clazz : set) {
            String string2 = clazz.getSimpleName();
            if (string2.equals(string)) {
                throw new RuntimeException("Command matches: " + string);
            }
            int n3 = string2.startsWith(string) || 5 <= string.length() && string2.contains(string) ? 0 : StringUtil.levenshteinDistance((String)string, (String)string2, (int)0, (int)2, (int)1, (int)4);
            hashMap.put(clazz, n3);
            if (n3 < n) {
                n = n3;
                n2 = 1;
                continue;
            }
            if (n3 != n) continue;
            ++n2;
        }
        if (0 == n && n2 == set.size()) {
            n = 8;
        }
        System.err.println(String.format("'%s' is not a valid command. See PicardCommandLine --help for more information.", string));
        if (n < 7) {
            System.err.println(String.format("Did you mean %s?", n2 < 2 ? "this" : "one of these"));
            for (Class<?> clazz : set) {
                if (n != (Integer)hashMap.get(clazz)) continue;
                System.err.println(String.format("        %s", clazz.getSimpleName()));
            }
        }
    }

    private static class SimpleNameComparator
    implements Comparator<Class> {
        private SimpleNameComparator() {
        }

        @Override
        public int compare(Class clazz, Class clazz2) {
            return clazz.getSimpleName().compareTo(clazz2.getSimpleName());
        }
    }
}

