/*
 * Decompiled with CFR 0.152.
 */
package picard.fastq;

import java.io.File;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;
import picard.fastq.BamToBfqWriter;

@CommandLineProgramProperties(usage="Create BFQ files from a BAM file for use by the Maq aligner.", usageShort="Create BFQ files from a BAM file for use by the Maq aligner.", programGroup=SamOrBam.class)
public class BamToBfq
extends CommandLineProgram {
    @Option(doc="The BAM file to parse.", shortName="I")
    public File INPUT;
    @Option(doc="The analysis directory for the binary output file. ")
    public File ANALYSIS_DIR;
    @Option(doc="Flowcell barcode (e.g. 30PYMAAXX).  ", shortName="F", mutex={"OUTPUT_FILE_PREFIX"})
    public String FLOWCELL_BARCODE;
    @Option(doc="Lane number. ", shortName="L", optional=true, mutex={"OUTPUT_FILE_PREFIX"})
    public Integer LANE;
    @Option(doc="Prefix for all output files", mutex={"FLOWCELL_BARCODE", "LANE"})
    public String OUTPUT_FILE_PREFIX;
    @Option(doc="Number of reads to align (null = all).", shortName="NUM", optional=true)
    public Integer READS_TO_ALIGN;
    @Option(doc="Number of reads to break into individual groups for alignment", shortName="CHUNK")
    public Integer READ_CHUNK_SIZE = 2000000;
    @Option(doc="Whether this is a paired-end run. ", shortName="PE")
    public Boolean PAIRED_RUN;
    @Option(doc="Deprecated option; use READ_NAME_PREFIX instead", mutex={"READ_NAME_PREFIX"}, shortName="RB", optional=true)
    public String RUN_BARCODE;
    @Option(doc="Prefix to be stripped off the beginning of all read names  (to make them short enough to run in Maq)", optional=true)
    public String READ_NAME_PREFIX;
    @Option(doc="Whether to include non-PF reads", shortName="NONPF", optional=true)
    public Boolean INCLUDE_NON_PF_READS = false;
    @Option(doc="Whether to clip adapters from the reads")
    public boolean CLIP_ADAPTERS = true;
    @Option(doc="The number of bases from each read to write to the bfq file.  If this is non-null, then only the first BASES_TO_WRITE bases from each read will be written.", optional=true)
    public Integer BASES_TO_WRITE = null;

    @Override
    protected int doWork() {
        String string = this.ANALYSIS_DIR.getAbsolutePath();
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        string = string + this.OUTPUT_FILE_PREFIX + ".";
        BamToBfqWriter bamToBfqWriter = new BamToBfqWriter(this.INPUT, string, this.READS_TO_ALIGN, this.READ_CHUNK_SIZE, this.PAIRED_RUN, this.READ_NAME_PREFIX, this.INCLUDE_NON_PF_READS, this.CLIP_ADAPTERS, this.BASES_TO_WRITE);
        bamToBfqWriter.writeBfqFiles();
        return 0;
    }

    public static void main(String[] stringArray) {
        System.exit(new BamToBfq().instanceMain(stringArray));
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.OUTPUT_FILE_PREFIX == null) {
            this.OUTPUT_FILE_PREFIX = this.FLOWCELL_BARCODE + "." + this.LANE;
        }
        if (this.READ_NAME_PREFIX == null) {
            this.READ_NAME_PREFIX = this.RUN_BARCODE + ":";
        }
        return null;
    }
}

