/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProcessExecutor;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Illumina;
import picard.illumina.IlluminaBasecallsConverter;
import picard.illumina.parser.IlluminaDataProviderFactory;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.OutputMapping;
import picard.illumina.parser.ParameterizedFileUtil;
import picard.illumina.parser.ReadStructure;

@CommandLineProgramProperties(usage="Check that the files to provide the data specified by DATA_TYPES are available, exist, and are reasonably sized for every tile/cycle.  Reasonably sized means non-zero sized for files that exist per tile and equal size for binary files that exist per cycle/per tile. CheckIlluminaDirectory DOES NOT check that the individual records in a file are well-formed.", usageShort="Asserts the validity of the data in the specified Illumina basecalling data", programGroup=Illumina.class)
public class CheckIlluminaDirectory
extends CommandLineProgram {
    private static final Log log = Log.getInstance(CheckIlluminaDirectory.class);
    @Option(doc="The basecalls output directory. ", shortName="B")
    public File BASECALLS_DIR;
    @Option(doc="The data types that should be checked for each tile/cycle.  If no values are provided then the data types checked are those required by IlluminaBaseCallsToSam (which is a superset of those used in ExtractIlluminaBarcodes).  These data types vary slightly depending on whether or not the run is barcoded so READ_STRUCTURE should be the same as that which will be passed to IlluminaBasecallsToSam.  If this option is left unspecified then both ExtractIlluminaBarcodes and IlluminaBaseCallsToSam should complete successfully UNLESS the individual records of the files themselves are spurious.", shortName="DT", optional=true)
    public final Set<IlluminaDataType> DATA_TYPES = new TreeSet<IlluminaDataType>();
    @Option(doc="A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"36T8B8S28T\" then, before being converted to SAM records those bases will be split into 4 reads where read one consists of 36 cycles of template, read two consists of 8 cycles of barcode, read three will be an 8 base read of skipped cycles and read four is another 28 cycle template read.  The read consisting of skipped cycles would NOT be included in output SAM/BAM file read groups. Note:  If you want to check whether or not a future IlluminaBasecallsToSam or ExtractIlluminaBarcodes run will fail then be sure to use the exact same READ_STRUCTURE that you would pass to these programs for this run.", shortName="RS")
    public String READ_STRUCTURE;
    @Option(doc="The number of the lane(s) to check. ", shortName="L", minElements=1)
    public List<Integer> LANES;
    @Option(doc="The number(s) of the tile(s) to check. ", shortName="T", optional=true)
    public List<Integer> TILE_NUMBERS;
    @Option(doc="A flag to determine whether or not to create fake versions of the missing files.", shortName="F", optional=true)
    public Boolean FAKE_FILES = false;
    @Option(doc="A flag to create symlinks to the loc file for the X Ten for each tile.", shortName="X", optional=true)
    public Boolean LINK_LOCS = false;

    public static void main(String[] stringArray) {
        new CheckIlluminaDirectory().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        ReadStructure readStructure = new ReadStructure(this.READ_STRUCTURE);
        if (this.DATA_TYPES.isEmpty()) {
            this.DATA_TYPES.addAll(Arrays.asList(IlluminaBasecallsConverter.DATA_TYPES_NO_BARCODE));
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        int[] nArray = new OutputMapping(readStructure).getOutputCycles();
        log.info(new Object[]{"Checking lanes(" + StringUtil.join((String)",", this.LANES) + " in basecalls directory (" + this.BASECALLS_DIR.getAbsolutePath() + ")\n"});
        log.info(new Object[]{"Expected cycles: " + StringUtil.intValuesToString((int[])nArray)});
        for (Integer n2 : this.LANES) {
            IlluminaFileUtil illuminaFileUtil = new IlluminaFileUtil(this.BASECALLS_DIR, n2);
            List<Integer> list = illuminaFileUtil.getExpectedTiles();
            if (!this.TILE_NUMBERS.isEmpty()) {
                list.retainAll(this.TILE_NUMBERS);
            }
            if (this.LINK_LOCS.booleanValue()) {
                this.createLocFileSymlinks(illuminaFileUtil, n2);
                illuminaFileUtil = new IlluminaFileUtil(this.BASECALLS_DIR, n2);
            }
            log.info(new Object[]{"Checking lane " + n2});
            log.info(new Object[]{"Expected tiles: " + StringUtil.join((String)", ", list)});
            int n3 = CheckIlluminaDirectory.verifyLane(illuminaFileUtil, list, nArray, this.DATA_TYPES, this.FAKE_FILES);
            if (n3 > 0) {
                log.info(new Object[]{"Lane " + n2 + " FAILED " + " Total Errors: " + n3});
                arrayList.add(n2);
                n += n3;
                continue;
            }
            log.info(new Object[]{"Lane " + n2 + " SUCCEEDED "});
        }
        int n4 = 0;
        if (n == 0) {
            log.info(new Object[]{"SUCCEEDED!  All required files are present and non-empty."});
        } else {
            n4 = n;
            log.info(new Object[]{"FAILED! There were " + n + " in the following lanes: " + StringUtil.join((String)", ", arrayList)});
        }
        return n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createLocFileSymlinks(IlluminaFileUtil illuminaFileUtil, int n) {
        File file = new File(this.BASECALLS_DIR.getParentFile().getAbsolutePath() + File.separator + "s.locs");
        File file2 = new File(file.getParent() + File.separator + IlluminaFileUtil.longLaneStr(n) + File.separator);
        if (!file.exists()) throw new PicardException(String.format("Locations file %s does not exist.", file.getAbsolutePath()));
        boolean bl = true;
        if (!file2.exists()) {
            bl = file2.mkdirs();
        }
        if (!bl) throw new PicardException(String.format("Could not create lane directory: %s.", file2.getAbsolutePath()));
        for (Integer n2 : illuminaFileUtil.getExpectedTiles()) {
            String string = file2 + File.separator + String.format("s_%d_%d.locs", n, n2);
            ProcessExecutor.ExitStatusAndOutput exitStatusAndOutput = ProcessExecutor.executeAndReturnInterleavedOutput((String[])new String[]{"ln", "-fs", file.getAbsolutePath(), string});
            if (exitStatusAndOutput.exitStatus == 0) continue;
            throw new PicardException("Could not create symlink: " + exitStatusAndOutput.stdout);
        }
    }

    private static final int verifyLane(IlluminaFileUtil illuminaFileUtil, List<Integer> list, int[] nArray, Set<IlluminaDataType> set, boolean bl) {
        Object object;
        if (list.isEmpty()) {
            throw new PicardException("0 input tiles were specified!  Check to make sure this lane is in the InterOp file!");
        }
        if (nArray.length == 0) {
            throw new PicardException("0 output cycles were specified!");
        }
        int n = 0;
        Map<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> map = IlluminaDataProviderFactory.determineFormats(set, illuminaFileUtil);
        Set<IlluminaDataType> set2 = IlluminaDataProviderFactory.findUnmatchedTypes(set, map);
        if (!set2.isEmpty()) {
            if (bl) {
                for (IlluminaDataType enum_ : set2) {
                    object = IlluminaDataProviderFactory.findPreferredFormat(enum_, illuminaFileUtil);
                    illuminaFileUtil.getUtil((IlluminaFileUtil.SupportedIlluminaFormat)((Object)object)).fakeFiles(list, nArray, (IlluminaFileUtil.SupportedIlluminaFormat)((Object)object));
                }
            }
            log.info(new Object[]{"Could not find a format with available files for the following data types: " + StringUtil.join((String)", ", new ArrayList<IlluminaDataType>(set2))});
            n += set2.size();
        }
        for (IlluminaFileUtil.SupportedIlluminaFormat supportedIlluminaFormat : map.keySet()) {
            object = illuminaFileUtil.getUtil(supportedIlluminaFormat);
            List<String> list2 = ((ParameterizedFileUtil)object).verify(list, nArray);
            if (!list2.isEmpty() && bl) {
                ((ParameterizedFileUtil)object).fakeFiles(list, nArray, supportedIlluminaFormat);
            }
            n += list2.size();
            for (String string : list2) {
                log.info(new Object[]{string});
            }
        }
        return n;
    }

    @Override
    protected String[] customCommandLineValidation() {
        IOUtil.assertDirectoryIsReadable((File)this.BASECALLS_DIR);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Integer n : this.LANES) {
            if (n >= 1) continue;
            arrayList.add("LANES must be greater than or equal to 1.  LANES passed in " + StringUtil.join((String)", ", this.LANES));
            break;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

