/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.filter.SolexaNoiseFilter;
import java.util.List;
import picard.fastq.IlluminaReadNameEncoder;
import picard.fastq.ReadNameEncoder;
import picard.illumina.IlluminaBasecallsConverter;
import picard.illumina.IlluminaBasecallsToSam;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.ReadData;
import picard.illumina.parser.ReadStructure;
import picard.util.AdapterMarker;
import picard.util.AdapterPair;
import picard.util.IlluminaUtil;

public class ClusterDataToSamConverter
implements IlluminaBasecallsConverter.ClusterDataConverter<IlluminaBasecallsToSam.SAMRecordsForCluster> {
    private final String runBarcode;
    private final String readGroupId;
    private final SamRecordFilter filters = new SolexaNoiseFilter();
    private final boolean isPairedEnd;
    private final boolean hasSampleBarcode;
    private final boolean hasMolecularBarcode;
    private final int[] templateIndices;
    private final int[] sampleBarcodeIndices;
    private final int[] molecularBarcodeIndices;
    private final AdapterMarker adapterMarker;
    private final int outputRecordsPerCluster;
    private final ReadNameEncoder readNameEncoder;

    public ClusterDataToSamConverter(String string, String string2, ReadStructure readStructure, List<IlluminaUtil.IlluminaAdapterPair> list) {
        this.runBarcode = string;
        this.readGroupId = string2;
        this.readNameEncoder = new IlluminaReadNameEncoder(string);
        this.isPairedEnd = readStructure.templates.length() == 2;
        this.hasSampleBarcode = !readStructure.sampleBarcodes.isEmpty();
        this.hasMolecularBarcode = !readStructure.molecularBarcode.isEmpty();
        this.adapterMarker = list.isEmpty() ? null : new AdapterMarker(list.toArray(new AdapterPair[list.size()]));
        this.templateIndices = readStructure.templates.getIndices();
        this.sampleBarcodeIndices = readStructure.sampleBarcodes.getIndices();
        this.molecularBarcodeIndices = readStructure.molecularBarcode.getIndices();
        this.outputRecordsPerCluster = readStructure.templates.length();
    }

    private SAMRecord createSamRecord(ReadData readData, String string, boolean bl, boolean bl2, String string2, String string3, String string4) {
        SAMRecord sAMRecord = new SAMRecord(null);
        sAMRecord.setReadName(string);
        sAMRecord.setReadBases(readData.getBases());
        sAMRecord.setBaseQualities(readData.getQualities());
        sAMRecord.setReadPairedFlag(this.isPairedEnd);
        sAMRecord.setReadUnmappedFlag(true);
        sAMRecord.setReadFailsVendorQualityCheckFlag(!bl);
        if (this.isPairedEnd) {
            sAMRecord.setMateUnmappedFlag(true);
            sAMRecord.setFirstOfPairFlag(bl2);
            sAMRecord.setSecondOfPairFlag(!bl2);
        }
        if (this.filters.filterOut(sAMRecord)) {
            sAMRecord.setAttribute("XN", (Object)1);
        }
        if (this.readGroupId != null) {
            sAMRecord.setAttribute(SAMTag.RG.name(), (Object)this.readGroupId);
        }
        if (string2 != null) {
            sAMRecord.setAttribute(SAMTag.BC.name(), (Object)string2);
        }
        if (string3 != null) {
            sAMRecord.setAttribute("RX", (Object)string3);
            sAMRecord.setAttribute("QX", (Object)string4);
        }
        return sAMRecord;
    }

    @Override
    public IlluminaBasecallsToSam.SAMRecordsForCluster convertClusterToOutputRecord(ClusterData clusterData) {
        String string;
        Object object;
        StringBuilder stringBuilder;
        Object object2;
        IlluminaBasecallsToSam.SAMRecordsForCluster sAMRecordsForCluster = new IlluminaBasecallsToSam.SAMRecordsForCluster(this.outputRecordsPerCluster);
        String string2 = this.readNameEncoder.generateReadName(clusterData, null);
        String string3 = null;
        if (this.hasSampleBarcode && clusterData.getMatchedBarcode() == null) {
            object2 = new byte[this.sampleBarcodeIndices.length][];
            for (int i = 0; i < this.sampleBarcodeIndices.length; ++i) {
                object2[i] = clusterData.getRead(this.sampleBarcodeIndices[i]).getBases();
            }
            string3 = IlluminaUtil.barcodeSeqsToString(object2).replace('.', 'N');
        }
        if (this.hasMolecularBarcode) {
            stringBuilder = new StringBuilder();
            object = new byte[this.molecularBarcodeIndices.length][];
            byte[][] byArrayArray = new byte[this.molecularBarcodeIndices.length][];
            for (int i = 0; i < this.molecularBarcodeIndices.length; ++i) {
                object[i] = clusterData.getRead(this.molecularBarcodeIndices[i]).getBases();
                byArrayArray[i] = clusterData.getRead(this.molecularBarcodeIndices[i]).getQualities();
                stringBuilder.append(SAMUtils.phredToFastq((byte[])byArrayArray[i]));
            }
            object2 = IlluminaUtil.byteArrayToString(object, "").replace('.', 'N');
            string = stringBuilder.toString();
        } else {
            object2 = null;
            string = null;
        }
        stringBuilder = this.createSamRecord(clusterData.getRead(this.templateIndices[0]), string2, clusterData.isPf(), true, string3, (String)object2, string);
        sAMRecordsForCluster.records[0] = stringBuilder;
        object = null;
        if (this.isPairedEnd) {
            object = this.createSamRecord(clusterData.getRead(this.templateIndices[1]), string2, clusterData.isPf(), false, string3, (String)object2, string);
            sAMRecordsForCluster.records[1] = (SAMRecord)object;
        }
        if (this.adapterMarker != null) {
            if (this.isPairedEnd) {
                this.adapterMarker.adapterTrimIlluminaPairedReads((SAMRecord)stringBuilder, (SAMRecord)object);
            } else {
                this.adapterMarker.adapterTrimIlluminaSingleRead((SAMRecord)stringBuilder);
            }
        }
        return sAMRecordsForCluster;
    }
}

