/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.text.DecimalFormat;
import java.util.SortedMap;
import java.util.TreeMap;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Illumina;
import picard.illumina.IlluminaBasecallingMetrics;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.IlluminaDataProvider;
import picard.illumina.parser.IlluminaDataProviderFactory;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.util.TabbedTextFileWithHeaderParser;

@CommandLineProgramProperties(usage="Given an Illumina basecalling and a lane, produces per-lane-barcode basecalling metrics", usageShort="Given an Illumina basecalling and a lane, produces per-lane-barcode basecalling metrics", programGroup=Illumina.class)
public class CollectIlluminaBasecallingMetrics
extends CommandLineProgram {
    static final String USAGE = "Given an Illumina basecalling and a lane, produces per-lane-barcode basecalling metrics";
    @Option(doc="The Illumina basecalls output directory from which data are read", shortName="B")
    public File BASECALLS_DIR;
    @Option(doc="The lane whose data will be read", shortName="L")
    public Integer LANE;
    @Option(doc="The file containing barcodes to expect from the run - barcodeData.#", shortName="I", optional=true)
    public File INPUT;
    @Option(doc="A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"36T8B8S28T\" then, before being converted to SAM records those bases will be split into 4 reads where read one consists of 36 cycles of template, read two consists of 8 cycles of barcode, read three will be an 8 base read of skipped cycles and read four is another 28 cycle template read.  The read consisting of skipped cycles would NOT be included in output SAM/BAM file read groups.", shortName="RS")
    public String READ_STRUCTURE;
    @Option(doc="The file to which the collected metrics are written", shortName="O", optional=true)
    public File OUTPUT;
    private int barcodeLength = 0;
    private String unmatched_barcode;
    private final SortedMap<String, IlluminaMetricCounts> barcodeToMetricCounts = new TreeMap<String, IlluminaMetricCounts>();
    private static final String BARCODE_NAME_COLUMN = "barcode_name";
    private static final String BARCODE_SEQUENCE_COLUMN_NAME_STUB = "barcode_sequence_";

    @Override
    protected int doWork() {
        Iterable<TabbedTextFileWithHeaderParser.Row> iterable;
        IlluminaDataProviderFactory illuminaDataProviderFactory;
        IOUtil.assertDirectoryIsReadable((File)this.BASECALLS_DIR);
        if (this.OUTPUT == null) {
            this.OUTPUT = new File(this.BASECALLS_DIR, String.format("LANE%s_basecalling_metrics", this.LANE));
        }
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        ReadStructure readStructure = new ReadStructure(this.READ_STRUCTURE);
        BclQualityEvaluationStrategy bclQualityEvaluationStrategy = new BclQualityEvaluationStrategy(2);
        if (this.INPUT == null) {
            illuminaDataProviderFactory = new IlluminaDataProviderFactory(this.BASECALLS_DIR, this.LANE, readStructure, bclQualityEvaluationStrategy, IlluminaDataType.PF, IlluminaDataType.Position);
        } else {
            IOUtil.assertFileIsReadable((File)this.INPUT);
            iterable = new TabbedTextFileWithHeaderParser(this.INPUT);
            for (TabbedTextFileWithHeaderParser.Row row : iterable) {
                String string = row.getField(BARCODE_NAME_COLUMN);
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 1; i <= readStructure.sampleBarcodes.length(); ++i) {
                    stringBuilder.append(row.getField(BARCODE_SEQUENCE_COLUMN_NAME_STUB + i));
                    if (this.barcodeLength != 0) continue;
                    this.barcodeLength = stringBuilder.length();
                }
                if (stringBuilder.length() <= 0) continue;
                this.barcodeToMetricCounts.put(stringBuilder.toString(), new IlluminaMetricCounts(stringBuilder.toString(), string, this.LANE));
            }
            illuminaDataProviderFactory = this.barcodeToMetricCounts.isEmpty() ? new IlluminaDataProviderFactory(this.BASECALLS_DIR, this.LANE, readStructure, bclQualityEvaluationStrategy, IlluminaDataType.PF, IlluminaDataType.Position) : new IlluminaDataProviderFactory(this.BASECALLS_DIR, this.LANE, readStructure, bclQualityEvaluationStrategy, IlluminaDataType.PF, IlluminaDataType.Position, IlluminaDataType.Barcodes);
        }
        this.unmatched_barcode = StringUtil.repeatCharNTimes((char)'N', (int)this.barcodeLength);
        iterable = illuminaDataProviderFactory.makeDataProvider();
        while (((IlluminaDataProvider)iterable).hasNext()) {
            Object object = ((IlluminaDataProvider)iterable).next();
            this.addCluster((ClusterData)object);
        }
        this.onComplete();
        return 0;
    }

    private void addCluster(ClusterData clusterData) {
        IlluminaMetricCounts illuminaMetricCounts;
        String string = clusterData.getMatchedBarcode();
        if (string == null) {
            string = this.unmatched_barcode;
        }
        if ((illuminaMetricCounts = (IlluminaMetricCounts)this.barcodeToMetricCounts.get(string)) == null) {
            illuminaMetricCounts = new IlluminaMetricCounts(string, null, this.LANE);
            this.barcodeToMetricCounts.put(string, illuminaMetricCounts);
        }
        int n = clusterData.getTile();
        illuminaMetricCounts.incrementClusterCount(n, clusterData.isPf());
    }

    private void onComplete() {
        try {
            MetricsFile metricsFile = this.getMetricsFile();
            IlluminaMetricCounts illuminaMetricCounts = new IlluminaMetricCounts(null, null, this.LANE);
            for (String string : this.barcodeToMetricCounts.keySet()) {
                IlluminaMetricCounts illuminaMetricCounts2 = (IlluminaMetricCounts)this.barcodeToMetricCounts.get(string);
                illuminaMetricCounts2.addMetricsToFile(metricsFile);
                illuminaMetricCounts.addIlluminaMetricCounts(illuminaMetricCounts2);
            }
            if (!this.barcodeToMetricCounts.keySet().contains("")) {
                illuminaMetricCounts.addMetricsToFile(metricsFile);
            }
            metricsFile.write(this.OUTPUT);
        }
        catch (Exception exception) {
            throw new PicardException("Error writing output file " + this.OUTPUT.getPath(), exception);
        }
    }

    public static void main(String[] stringArray) {
        new CollectIlluminaBasecallingMetrics().instanceMainWithExit(stringArray);
    }

    private class IlluminaMetricCounts {
        private final Histogram<Integer> tileToClusterHistogram = new Histogram();
        private final Histogram<Integer> tileToPfClusterHistogram = new Histogram();
        final IlluminaBasecallingMetrics metrics = new IlluminaBasecallingMetrics();

        public IlluminaMetricCounts(String string, String string2, Integer n) {
            this.metrics.MOLECULAR_BARCODE_SEQUENCE_1 = string;
            this.metrics.MOLECULAR_BARCODE_NAME = string2;
            this.metrics.LANE = Integer.toString(n);
        }

        public void incrementClusterCount(int n, boolean bl) {
            this.incrementClusterCount(n, 1.0, bl);
        }

        public void incrementClusterCount(int n, double d, boolean bl) {
            this.incrementClusterCount((Integer)n, d, bl ? 1.0 : 0.0);
        }

        public void incrementClusterCount(Integer n, double d, double d2) {
            this.tileToClusterHistogram.increment((Comparable)n, d);
            this.tileToPfClusterHistogram.increment((Comparable)n, d2);
        }

        private void onComplete() {
            double d = this.tileToClusterHistogram.getMeanBinSize();
            this.metrics.MEAN_CLUSTERS_PER_TILE = Math.round(d);
            this.metrics.SD_CLUSTERS_PER_TILE = Math.round(this.tileToClusterHistogram.getStandardDeviationBinSize(d));
            double d2 = this.tileToPfClusterHistogram.getMeanBinSize();
            this.metrics.MEAN_PF_CLUSTERS_PER_TILE = Math.round(d2);
            this.metrics.SD_PF_CLUSTERS_PER_TILE = Math.round(this.tileToPfClusterHistogram.getStandardDeviationBinSize(d2));
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            Histogram histogram = this.tileToPfClusterHistogram.divideByHistogram(this.tileToClusterHistogram);
            double d3 = histogram.getMeanBinSize();
            this.metrics.MEAN_PCT_PF_CLUSTERS_PER_TILE = Double.isNaN(d3) ? 0.0 : Double.valueOf(decimalFormat.format(d3 * 100.0));
            this.metrics.SD_PCT_PF_CLUSTERS_PER_TILE = Double.valueOf(decimalFormat.format(histogram.getStandardDeviationBinSize(d3) * 100.0));
            this.metrics.TOTAL_CLUSTERS = (long)this.tileToClusterHistogram.getSumOfValues();
            this.metrics.PF_CLUSTERS = (long)this.tileToPfClusterHistogram.getSumOfValues();
            ReadStructure readStructure = new ReadStructure(CollectIlluminaBasecallingMetrics.this.READ_STRUCTURE);
            int n = 0;
            for (int i = 0; i < readStructure.templates.length(); ++i) {
                n += readStructure.templates.get((int)i).length;
            }
            this.metrics.TOTAL_READS = this.metrics.TOTAL_CLUSTERS * (long)readStructure.templates.length();
            this.metrics.PF_READS = this.metrics.PF_CLUSTERS * (long)readStructure.templates.length();
            this.metrics.TOTAL_BASES = this.metrics.TOTAL_CLUSTERS * (long)n;
            this.metrics.PF_BASES = this.metrics.PF_CLUSTERS * (long)n;
        }

        public void addMetricsToFile(MetricsFile<IlluminaBasecallingMetrics, Comparable<?>> metricsFile) {
            this.onComplete();
            metricsFile.addMetric((MetricBase)this.metrics);
        }

        public void addIlluminaMetricCounts(IlluminaMetricCounts illuminaMetricCounts) {
            this.tileToClusterHistogram.addHistogram(illuminaMetricCounts.tileToClusterHistogram);
            this.tileToPfClusterHistogram.addHistogram(illuminaMetricCounts.tileToPfClusterHistogram);
        }
    }
}

