/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Illumina;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.IlluminaDataProvider;
import picard.illumina.parser.IlluminaDataProviderFactory;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.ReadDescriptor;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.ReadType;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.util.IlluminaUtil;
import picard.util.TabbedTextFileWithHeaderParser;

@CommandLineProgramProperties(usage="Determine the sample barcode for each read in an Illumina lane.\nFor each tile, a file is written to the basecalls directory of the form s_<lane>_<tile>_barcode.txt. An output file contains a line for each read in the tile, aligned with the regular basecall output. \nThe output file contains the following tab-separated columns: \n    * read subsequence at barcode position\n    * Y or N indicating if there was a barcode match\n    * matched barcode sequence\nNote 1: that the order of specification of barcodes can cause arbitrary differences in output for poorly matching barcodes.\nNote 2: molecular barcodes (M in the read structure) are not the barcode being extracted here and will be ignored here.\n\n", usageShort="Tool to determine the barcode for each read in an Illumina lane", programGroup=Illumina.class)
public class ExtractIlluminaBarcodes
extends CommandLineProgram {
    @Option(doc="The Illumina basecalls directory. ", shortName="B")
    public File BASECALLS_DIR;
    @Option(doc="Where to write _barcode.txt files.  By default, these are written to BASECALLS_DIR.", optional=true)
    public File OUTPUT_DIR;
    @Option(doc="Lane number. ", shortName="L")
    public Integer LANE;
    @Option(doc="A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"36T8B8S28T\" then, before being converted to SAM records those bases will be split into 4 reads where read one consists of 36 cycles of template, read two consists of 8 cycles of barcode, read three will be an 8 base read of skipped cycles and read four is another 28 cycle template read.  The read consisting of skipped cycles would NOT be included in output SAM/BAM file read groups.", shortName="RS")
    public String READ_STRUCTURE;
    @Option(doc="Barcode sequence.  These must be unique, and all the same length.  This cannot be used with reads that have more than one barcode; use BARCODE_FILE in that case. ", mutex={"BARCODE_FILE"})
    public List<String> BARCODE = new ArrayList<String>();
    @Option(doc="Tab-delimited file of barcode sequences, barcode name and, optionally, library name.  Barcodes must be unique and all the same length.  Column headers must be 'barcode_sequence_1', 'barcode_sequence_2' (optional), 'barcode_name', and 'library_name'.", mutex={"BARCODE"})
    public File BARCODE_FILE;
    @Option(doc="Per-barcode and per-lane metrics written to this file.", shortName="M")
    public File METRICS_FILE;
    @Option(doc="Maximum mismatches for a barcode to be considered a match.")
    public int MAX_MISMATCHES = 1;
    @Option(doc="Minimum difference between number of mismatches in the best and second best barcodes for a barcode to be considered a match.")
    public int MIN_MISMATCH_DELTA = 1;
    @Option(doc="Maximum allowable number of no-calls in a barcode read before it is considered unmatchable.")
    public int MAX_NO_CALLS = 2;
    @Option(shortName="Q", doc="Minimum base quality. Any barcode bases falling below this quality will be considered a mismatch even in the bases match.")
    public int MINIMUM_BASE_QUALITY = 0;
    @Option(doc="The minimum quality (after transforming 0s to 1s) expected from reads.  If qualities are lower than this value, an error is thrown.The default of 2 is what the Illumina's spec describes as the minimum, but in practice the value has been observed lower.")
    public int MINIMUM_QUALITY = 2;
    @Option(shortName="GZIP", doc="Compress output s_l_t_barcode.txt files using gzip and append a .gz extension to the file names.")
    public boolean COMPRESS_OUTPUTS = false;
    @Option(doc="Run this many PerTileBarcodeExtractors in parallel.  If NUM_PROCESSORS = 0, number of cores is automatically set to the number of cores available on the machine. If NUM_PROCESSORS < 0 then the number of cores used will be the number available on the machine less NUM_PROCESSORS.")
    public int NUM_PROCESSORS = 1;
    private static final Log LOG = Log.getInstance(ExtractIlluminaBarcodes.class);
    private ReadStructure readStructure;
    private IlluminaDataProviderFactory factory;
    private final Map<String, BarcodeMetric> barcodeToMetrics = new LinkedHashMap<String, BarcodeMetric>();
    private final NumberFormat tileNumberFormatter = NumberFormat.getNumberInstance();
    private BclQualityEvaluationStrategy bclQualityEvaluationStrategy;
    private static final String BARCODE_SEQUENCE_COLUMN = "barcode_sequence";
    private static final String BARCODE_SEQUENCE_1_COLUMN = "barcode_sequence_1";
    private static final String BARCODE_NAME_COLUMN = "barcode_name";
    private static final String LIBRARY_NAME_COLUMN = "library_name";

    public ExtractIlluminaBarcodes() {
        this.tileNumberFormatter.setMinimumIntegerDigits(4);
        this.tileNumberFormatter.setGroupingUsed(false);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsWritable((File)this.METRICS_FILE);
        if (this.OUTPUT_DIR == null) {
            this.OUTPUT_DIR = this.BASECALLS_DIR;
        }
        IOUtil.assertDirectoryIsWritable((File)this.OUTPUT_DIR);
        String[] stringArray = new String[this.readStructure.sampleBarcodes.length()];
        int n = 0;
        for (ReadDescriptor readDescriptor : this.readStructure.descriptors) {
            if (readDescriptor.type != ReadType.Barcode) continue;
            stringArray[n++] = StringUtil.repeatCharNTimes((char)'N', (int)readDescriptor.length);
        }
        BarcodeMetric barcodeMetric = new BarcodeMetric(null, null, IlluminaUtil.barcodeSeqsToString(stringArray), stringArray);
        int n2 = this.NUM_PROCESSORS == 0 ? Runtime.getRuntime().availableProcessors() : (this.NUM_PROCESSORS < 0 ? Runtime.getRuntime().availableProcessors() + this.NUM_PROCESSORS : this.NUM_PROCESSORS);
        LOG.info(new Object[]{"Processing with " + n2 + " PerTileBarcodeExtractor(s)."});
        ExecutorService executorService = Executors.newFixedThreadPool(n2);
        ArrayList<PerTileBarcodeExtractor> arrayList = new ArrayList<PerTileBarcodeExtractor>(this.factory.getAvailableTiles().size());
        for (int n3 : this.factory.getAvailableTiles()) {
            PerTileBarcodeExtractor perTileBarcodeExtractor = new PerTileBarcodeExtractor(n3, this.getBarcodeFile(n3), this.barcodeToMetrics, barcodeMetric, this.factory, this.MINIMUM_BASE_QUALITY, this.MAX_NO_CALLS, this.MAX_MISMATCHES, this.MIN_MISMATCH_DELTA);
            arrayList.add(perTileBarcodeExtractor);
        }
        try {
            for (PerTileBarcodeExtractor perTileBarcodeExtractor : arrayList) {
                executorService.submit(perTileBarcodeExtractor);
            }
            executorService.shutdown();
            if (!executorService.awaitTermination(6L, TimeUnit.HOURS)) {
                executorService.shutdownNow();
                if (!executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    LOG.error(new Object[]{"Pool did not terminate"});
                }
                return 1;
            }
        }
        catch (Throwable throwable) {
            LOG.error(throwable, new Object[]{"Parent thread encountered problem submitting extractors to thread pool or awaiting shutdown of threadpool.  Attempting to kill threadpool."});
            executorService.shutdownNow();
            return 2;
        }
        LOG.info(new Object[]{"Processed " + arrayList.size() + " tiles."});
        for (PerTileBarcodeExtractor perTileBarcodeExtractor : arrayList) {
            for (String object : this.barcodeToMetrics.keySet()) {
                this.barcodeToMetrics.get(object).merge(perTileBarcodeExtractor.getMetrics().get(object));
            }
            barcodeMetric.merge(perTileBarcodeExtractor.getNoMatchMetric());
            if (perTileBarcodeExtractor.getException() == null) continue;
            LOG.error(new Object[]{"Abandoning metrics calculation because one or more PerTileBarcodeExtractors failed."});
            return 4;
        }
        int n4 = barcodeMetric.READS;
        int n5 = barcodeMetric.PF_READS;
        int n6 = 0;
        for (BarcodeMetric barcodeMetric2 : this.barcodeToMetrics.values()) {
            n4 += barcodeMetric2.READS;
            n5 += barcodeMetric2.PF_READS;
            n6 += barcodeMetric2.PF_READS;
        }
        if (n4 > 0) {
            barcodeMetric.PCT_MATCHES = (double)barcodeMetric.READS / (double)n4;
            double d = 0.0;
            for (BarcodeMetric barcodeMetric3 : this.barcodeToMetrics.values()) {
                barcodeMetric3.PCT_MATCHES = (double)barcodeMetric3.READS / (double)n4;
                if (!(barcodeMetric3.PCT_MATCHES > d)) continue;
                d = barcodeMetric3.PCT_MATCHES;
            }
            if (d > 0.0) {
                barcodeMetric.RATIO_THIS_BARCODE_TO_BEST_BARCODE_PCT = barcodeMetric.PCT_MATCHES / d;
                for (BarcodeMetric barcodeMetric3 : this.barcodeToMetrics.values()) {
                    barcodeMetric3.RATIO_THIS_BARCODE_TO_BEST_BARCODE_PCT = barcodeMetric3.PCT_MATCHES / d;
                }
            }
        }
        if (n5 > 0) {
            barcodeMetric.PF_PCT_MATCHES = (double)barcodeMetric.PF_READS / (double)n5;
            double d = 0.0;
            for (BarcodeMetric barcodeMetric3 : this.barcodeToMetrics.values()) {
                barcodeMetric3.PF_PCT_MATCHES = (double)barcodeMetric3.PF_READS / (double)n5;
                if (!(barcodeMetric3.PF_PCT_MATCHES > d)) continue;
                d = barcodeMetric3.PF_PCT_MATCHES;
            }
            if (d > 0.0) {
                barcodeMetric.PF_RATIO_THIS_BARCODE_TO_BEST_BARCODE_PCT = barcodeMetric.PF_PCT_MATCHES / d;
                for (BarcodeMetric barcodeMetric3 : this.barcodeToMetrics.values()) {
                    barcodeMetric3.PF_RATIO_THIS_BARCODE_TO_BEST_BARCODE_PCT = barcodeMetric3.PF_PCT_MATCHES / d;
                }
            }
        }
        for (Map.Entry<Byte, Integer> entry : this.bclQualityEvaluationStrategy.getPoorQualityFrequencies().entrySet()) {
            LOG.warn(new Object[]{String.format("Observed low quality of %s %s times.", entry.getKey(), entry.getValue())});
        }
        this.bclQualityEvaluationStrategy.assertMinimumQualities();
        if (n6 > 0) {
            double metricsFile = (double)n6 / (double)this.barcodeToMetrics.values().size();
            for (BarcodeMetric barcodeMetric3 : this.barcodeToMetrics.values()) {
                barcodeMetric3.PF_NORMALIZED_MATCHES = (double)barcodeMetric3.PF_READS / metricsFile;
            }
        }
        MetricsFile metricsFile = this.getMetricsFile();
        for (BarcodeMetric barcodeMetric4 : this.barcodeToMetrics.values()) {
            metricsFile.addMetric((MetricBase)barcodeMetric4);
        }
        metricsFile.addMetric((MetricBase)barcodeMetric);
        metricsFile.write(this.METRICS_FILE);
        return 0;
    }

    private File getBarcodeFile(int n) {
        return new File(this.OUTPUT_DIR, "s_" + this.LANE + "_" + this.tileNumberFormatter.format(n) + "_barcode.txt" + (this.COMPRESS_OUTPUTS ? ".gz" : ""));
    }

    @Override
    protected String[] customCommandLineValidation() {
        IlluminaDataType[] illuminaDataTypeArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        this.bclQualityEvaluationStrategy = new BclQualityEvaluationStrategy(this.MINIMUM_QUALITY);
        this.readStructure = new ReadStructure(this.READ_STRUCTURE.replaceAll("T|M", "S"));
        if (this.MINIMUM_BASE_QUALITY > 0) {
            IlluminaDataType[] illuminaDataTypeArray2 = new IlluminaDataType[3];
            illuminaDataTypeArray2[0] = IlluminaDataType.BaseCalls;
            illuminaDataTypeArray2[1] = IlluminaDataType.PF;
            illuminaDataTypeArray = illuminaDataTypeArray2;
            illuminaDataTypeArray2[2] = IlluminaDataType.QualityScores;
        } else {
            IlluminaDataType[] illuminaDataTypeArray3 = new IlluminaDataType[2];
            illuminaDataTypeArray3[0] = IlluminaDataType.BaseCalls;
            illuminaDataTypeArray = illuminaDataTypeArray3;
            illuminaDataTypeArray3[1] = IlluminaDataType.PF;
        }
        IlluminaDataType[] illuminaDataTypeArray4 = illuminaDataTypeArray;
        this.factory = new IlluminaDataProviderFactory(this.BASECALLS_DIR, this.LANE, this.readStructure, this.bclQualityEvaluationStrategy, illuminaDataTypeArray4);
        if (this.BARCODE_FILE != null) {
            this.parseBarcodeFile(arrayList);
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : this.BARCODE) {
                if (hashSet.contains(string)) {
                    arrayList.add("Barcode " + string + " specified more than once.");
                }
                hashSet.add(string);
                BarcodeMetric barcodeMetric = new BarcodeMetric(null, null, string, new String[]{string});
                this.barcodeToMetrics.put(string, barcodeMetric);
            }
        }
        if (this.barcodeToMetrics.keySet().size() == 0) {
            arrayList.add("No barcodes have been specified.");
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void main(String[] stringArray) {
        new ExtractIlluminaBarcodes().instanceMainWithExit(stringArray);
    }

    private void parseBarcodeFile(ArrayList<String> arrayList) {
        String string;
        TabbedTextFileWithHeaderParser tabbedTextFileWithHeaderParser = new TabbedTextFileWithHeaderParser(this.BARCODE_FILE);
        String string2 = tabbedTextFileWithHeaderParser.hasColumn(BARCODE_SEQUENCE_COLUMN) ? BARCODE_SEQUENCE_COLUMN : (string = tabbedTextFileWithHeaderParser.hasColumn(BARCODE_SEQUENCE_1_COLUMN) ? BARCODE_SEQUENCE_1_COLUMN : null);
        if (string == null) {
            arrayList.add(this.BARCODE_FILE + " does not have " + BARCODE_SEQUENCE_COLUMN + " or " + BARCODE_SEQUENCE_1_COLUMN + " column header");
            return;
        }
        boolean bl = tabbedTextFileWithHeaderParser.hasColumn(BARCODE_NAME_COLUMN);
        boolean bl2 = tabbedTextFileWithHeaderParser.hasColumn(LIBRARY_NAME_COLUMN);
        int n = this.readStructure.sampleBarcodes.length();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (TabbedTextFileWithHeaderParser.Row row : tabbedTextFileWithHeaderParser) {
            String string3;
            Object[] objectArray = new String[n];
            int n2 = 1;
            for (ReadDescriptor readDescriptor : this.readStructure.descriptors) {
                if (readDescriptor.type != ReadType.Barcode) continue;
                string3 = n2 == 1 ? string : "barcode_sequence_" + String.valueOf(n2);
                objectArray[n2 - 1] = row.getField(string3);
                ++n2;
            }
            String string4 = IlluminaUtil.barcodeSeqsToString((String[])objectArray);
            if (hashSet.contains(string4)) {
                arrayList.add("Barcode " + (String)string4 + " specified more than once in " + this.BARCODE_FILE);
            }
            hashSet.add(string4);
            String object2 = bl ? row.getField(BARCODE_NAME_COLUMN) : "";
            string3 = bl2 ? row.getField(LIBRARY_NAME_COLUMN) : "";
            BarcodeMetric barcodeMetric = new BarcodeMetric(object2, string3, string4, (String[])objectArray);
            this.barcodeToMetrics.put(StringUtil.join((String)"", (Object[])objectArray), barcodeMetric);
        }
        tabbedTextFileWithHeaderParser.close();
    }

    private static class PerTileBarcodeExtractor
    implements Runnable {
        private final int tile;
        private final File barcodeFile;
        private final Map<String, BarcodeMetric> metrics;
        private final BarcodeMetric noMatch;
        private Exception exception = null;
        private final boolean usingQualityScores;
        private final IlluminaDataProvider provider;
        private final ReadStructure outputReadStructure;
        private final int maxNoCalls;
        private final int maxMismatches;
        private final int minMismatchDelta;
        private final int minimumBaseQuality;

        public PerTileBarcodeExtractor(int n, File file, Map<String, BarcodeMetric> map, BarcodeMetric barcodeMetric, IlluminaDataProviderFactory illuminaDataProviderFactory, int n2, int n3, int n4, int n5) {
            this.tile = n;
            this.barcodeFile = file;
            this.usingQualityScores = n2 > 0;
            this.maxNoCalls = n3;
            this.maxMismatches = n4;
            this.minMismatchDelta = n5;
            this.minimumBaseQuality = n2;
            this.metrics = new LinkedHashMap<String, BarcodeMetric>(map.size());
            for (String string : map.keySet()) {
                this.metrics.put(string, BarcodeMetric.copy(map.get(string)));
            }
            this.noMatch = BarcodeMetric.copy(barcodeMetric);
            this.provider = illuminaDataProviderFactory.makeDataProvider(Arrays.asList(n));
            this.outputReadStructure = illuminaDataProviderFactory.getOutputReadStructure();
        }

        public synchronized Map<String, BarcodeMetric> getMetrics() {
            return this.metrics;
        }

        public synchronized BarcodeMetric getNoMatchMetric() {
            return this.noMatch;
        }

        public synchronized Exception getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            try {
                Object object;
                LOG.info(new Object[]{"Extracting barcodes for tile " + this.tile});
                int[] nArray = this.outputReadStructure.sampleBarcodes.getIndices();
                BufferedWriter bufferedWriter = IOUtil.openFileForBufferedWriting((File)this.barcodeFile);
                byte[][] byArrayArray = new byte[nArray.length][];
                Object object2 = object = this.usingQualityScores ? (Object)new byte[nArray.length][] : (byte[][])null;
                while (this.provider.hasNext()) {
                    int n;
                    ClusterData clusterData = this.provider.next();
                    for (n = 0; n < nArray.length; ++n) {
                        byArrayArray[n] = clusterData.getRead(nArray[n]).getBases();
                        if (!this.usingQualityScores) continue;
                        object[n] = clusterData.getRead(nArray[n]).getQualities();
                    }
                    n = clusterData.isPf().booleanValue() ? 1 : 0;
                    BarcodeMatch barcodeMatch = this.findBestBarcodeAndUpdateMetrics(byArrayArray, (byte[][])object, n != 0, this.metrics, this.noMatch);
                    String string = barcodeMatch.matched ? "Y" : "N";
                    for (byte[] byArray : byArrayArray) {
                        bufferedWriter.write(StringUtil.bytesToString((byte[])byArray));
                    }
                    bufferedWriter.write("\t" + string + "\t" + barcodeMatch.barcode + "\t" + String.valueOf(barcodeMatch.mismatches) + "\t" + String.valueOf(barcodeMatch.mismatchesToSecondBest));
                    bufferedWriter.newLine();
                }
                bufferedWriter.close();
            }
            catch (Exception exception) {
                LOG.error((Throwable)exception, new Object[]{"Error processing tile ", this.tile});
                this.exception = exception;
            }
            finally {
                this.provider.close();
            }
        }

        private BarcodeMatch findBestBarcodeAndUpdateMetrics(byte[][] byArray, byte[][] byArray2, boolean bl, Map<String, BarcodeMetric> map, BarcodeMetric barcodeMetric) {
            BarcodeMetric object2 = null;
            int n = 0;
            int n2 = 0;
            for (byte[] object3 : byArray) {
                n += object3.length;
                for (byte by : object3) {
                    if (!SequenceUtil.isNoCall((byte)by)) continue;
                    ++n2;
                }
            }
            int n3 = n + 1;
            int n4 = n + 1;
            for (BarcodeMetric barcodeMetric2 : map.values()) {
                int n5 = this.countMismatches(barcodeMetric2.barcodeBytes, byArray, byArray2);
                if (n5 < n3) {
                    if (object2 != null) {
                        n4 = n3;
                    }
                    n3 = n5;
                    object2 = barcodeMetric2;
                    continue;
                }
                if (n5 >= n4) continue;
                n4 = n5;
            }
            boolean bl2 = object2 != null && n2 <= this.maxNoCalls && n3 <= this.maxMismatches && n4 - n3 >= this.minMismatchDelta;
            BarcodeMatch barcodeMatch = new BarcodeMatch();
            if (n2 + n3 < n) {
                barcodeMatch.mismatches = n3;
                barcodeMatch.mismatchesToSecondBest = n4;
                barcodeMatch.barcode = object2.BARCODE.toLowerCase().replaceAll("-", "");
            } else {
                barcodeMatch.mismatches = n;
                barcodeMatch.barcode = "";
            }
            if (bl2) {
                ++object2.READS;
                if (bl) {
                    ++object2.PF_READS;
                }
                if (n3 == 0) {
                    ++object2.PERFECT_MATCHES;
                    if (bl) {
                        ++object2.PF_PERFECT_MATCHES;
                    }
                } else if (n3 == 1) {
                    ++object2.ONE_MISMATCH_MATCHES;
                    if (bl) {
                        ++object2.PF_ONE_MISMATCH_MATCHES;
                    }
                }
                barcodeMatch.matched = true;
                barcodeMatch.barcode = object2.BARCODE.replaceAll("-", "");
            } else {
                ++barcodeMetric.READS;
                if (bl) {
                    ++barcodeMetric.PF_READS;
                }
            }
            return barcodeMatch;
        }

        private int countMismatches(byte[][] byArray, byte[][] byArray2, byte[][] byArray3) {
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                int n2 = Math.min(byArray[i].length, byArray2[i].length);
                for (int j = 0; j < n2; ++j) {
                    if (SequenceUtil.isNoCall((byte)byArray2[i][j])) continue;
                    if (!SequenceUtil.basesEqual((byte)byArray[i][j], (byte)byArray2[i][j])) {
                        ++n;
                        continue;
                    }
                    if (byArray3 == null || byArray3[i][j] >= this.minimumBaseQuality) continue;
                    ++n;
                }
            }
            return n;
        }

        class BarcodeMatch {
            boolean matched;
            String barcode;
            int mismatches;
            int mismatchesToSecondBest;

            BarcodeMatch() {
            }
        }
    }

    public static class BarcodeMetric
    extends MetricBase {
        public String BARCODE;
        public String BARCODE_NAME = "";
        public String LIBRARY_NAME = "";
        public int READS = 0;
        public int PF_READS = 0;
        public int PERFECT_MATCHES = 0;
        public int PF_PERFECT_MATCHES = 0;
        public int ONE_MISMATCH_MATCHES = 0;
        public int PF_ONE_MISMATCH_MATCHES = 0;
        public double PCT_MATCHES = 0.0;
        public double RATIO_THIS_BARCODE_TO_BEST_BARCODE_PCT = 0.0;
        public double PF_PCT_MATCHES = 0.0;
        public double PF_RATIO_THIS_BARCODE_TO_BEST_BARCODE_PCT = 0.0;
        public double PF_NORMALIZED_MATCHES;
        protected byte[][] barcodeBytes;

        public BarcodeMetric(String string, String string2, String string3, String[] stringArray) {
            this.BARCODE = string3;
            this.BARCODE_NAME = string;
            this.LIBRARY_NAME = string2;
            this.barcodeBytes = new byte[stringArray.length][];
            for (int i = 0; i < stringArray.length; ++i) {
                this.barcodeBytes[i] = StringUtil.stringToBytes((String)stringArray[i]);
            }
        }

        public BarcodeMetric() {
            this.barcodeBytes = null;
        }

        public static BarcodeMetric copy(BarcodeMetric barcodeMetric) {
            BarcodeMetric barcodeMetric2 = new BarcodeMetric();
            barcodeMetric2.BARCODE = barcodeMetric.BARCODE;
            barcodeMetric2.BARCODE_NAME = barcodeMetric.BARCODE_NAME;
            barcodeMetric2.LIBRARY_NAME = barcodeMetric.LIBRARY_NAME;
            barcodeMetric2.barcodeBytes = barcodeMetric.barcodeBytes;
            return barcodeMetric2;
        }

        public void merge(BarcodeMetric barcodeMetric) {
            this.READS += barcodeMetric.READS;
            this.PF_READS += barcodeMetric.PF_READS;
            this.PERFECT_MATCHES += barcodeMetric.PERFECT_MATCHES;
            this.PF_PERFECT_MATCHES += barcodeMetric.PF_PERFECT_MATCHES;
            this.ONE_MISMATCH_MATCHES += barcodeMetric.ONE_MISMATCH_MATCHES;
            this.PF_ONE_MISMATCH_MATCHES += barcodeMetric.PF_ONE_MISMATCH_MATCHES;
        }
    }
}

