/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CollectionUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import picard.illumina.parser.BclData;
import picard.illumina.parser.CycleIlluminaFileMap;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.OutputMapping;
import picard.illumina.parser.PerTileCycleParser;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.illumina.parser.readers.BclReader;

class BclParser
extends PerTileCycleParser<BclData> {
    private static final int EAMSS_M2_GE_THRESHOLD = 30;
    private static final int EAMSS_S1_LT_THRESHOLD = 15;
    public static final byte MASKING_QUALITY = 2;
    private static final Set<IlluminaDataType> SUPPORTED_TYPES = Collections.unmodifiableSet(CollectionUtil.makeSet((Object[])new IlluminaDataType[]{IlluminaDataType.BaseCalls, IlluminaDataType.QualityScores}));
    protected final BclQualityEvaluationStrategy bclQualityEvaluationStrategy;
    private final boolean applyEamssFilter;

    public BclParser(File file, int n, CycleIlluminaFileMap cycleIlluminaFileMap, OutputMapping outputMapping, BclQualityEvaluationStrategy bclQualityEvaluationStrategy) {
        this(file, n, cycleIlluminaFileMap, outputMapping, true, bclQualityEvaluationStrategy);
        this.initialize();
    }

    public BclParser(File file, int n, CycleIlluminaFileMap cycleIlluminaFileMap, OutputMapping outputMapping, boolean bl, BclQualityEvaluationStrategy bclQualityEvaluationStrategy) {
        super(file, n, cycleIlluminaFileMap, outputMapping);
        this.bclQualityEvaluationStrategy = bclQualityEvaluationStrategy;
        this.applyEamssFilter = bl;
        this.initialize();
    }

    @Override
    protected PerTileCycleParser.CycleFilesParser<BclData> makeCycleFileParser(List<File> list) {
        return new BclDataCycleFileParser(list);
    }

    @Override
    public void initialize() {
        this.seekToTile(this.currentTile);
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public BclData next() {
        BclData bclData = (BclData)super.next();
        byte[][] byArray = bclData.getBases();
        byte[][] byArray2 = bclData.getQualities();
        if (this.applyEamssFilter) {
            for (int i = 0; i < byArray.length; ++i) {
                BclParser.runEamssForReadInPlace(byArray[i], byArray2[i]);
            }
        }
        return bclData;
    }

    protected static void runEamssForReadInPlace(byte[] byArray, byte[] byArray2) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = Integer.MIN_VALUE;
        int n5 = -1;
        for (n2 = byArray.length - 1; n2 >= 0; --n2) {
            n = 0xFF & byArray2[n2];
            if (n >= 30) {
                n3 -= 2;
            } else if (n < 15) {
                ++n3;
            }
            if (n3 < n4) continue;
            n5 = n2;
            n4 = n3;
        }
        if (n4 >= 1) {
            int n6;
            n2 = 0;
            n = 0;
            for (n6 = n5; n6 >= 0; --n6) {
                if (byArray[n6] == 71) {
                    ++n2;
                    continue;
                }
                Integer n7 = BclParser.skipBy(n6, n2, n, byArray);
                if (n7 == null) break;
                n += n7.intValue();
                n2 += n7.intValue();
                n6 -= n7 - 1;
            }
            if (n2 >= 10) {
                n5 = n5 + 1 - n2;
            }
            for (n6 = n5; n6 < byArray2.length; ++n6) {
                byArray2[n6] = 2;
            }
        }
    }

    private static Integer skipBy(int n, int n2, int n3, byte[] byArray) {
        int n4;
        Integer n5 = null;
        for (int i = 1; i <= n && n3 + i <= (n4 = Math.max((n2 + i) / 10, 1)); ++i) {
            if (byArray[n - i] != 71) continue;
            n5 = i;
            break;
        }
        return n5;
    }

    private class BclDataCycleFileParser
    implements PerTileCycleParser.CycleFilesParser<BclData> {
        final CloseableIterator<BclData> reader;

        public BclDataCycleFileParser(List<File> list) {
            this.reader = new BclReader(list, BclParser.this.outputMapping.getOutputReadLengths(), BclParser.this.bclQualityEvaluationStrategy, false);
        }

        @Override
        public void close() {
            this.reader.close();
        }

        @Override
        public BclData next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (BclData)this.reader.next();
        }

        @Override
        public boolean hasNext() {
            try {
                return this.reader.hasNext();
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
    }
}

