/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import picard.illumina.parser.CycleIlluminaFileMap;
import picard.illumina.parser.IlluminaFileMap;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.ParameterizedFileUtil;
import picard.illumina.parser.TileIndex;
import picard.illumina.parser.fakers.FileFaker;
import picard.illumina.parser.fakers.MultiTileBclFileFaker;

public class MultiTileBclFileUtil
extends ParameterizedFileUtil {
    final File basecallLaneDir;
    final File bci;
    final TileIndex tileIndex;
    final CycleIlluminaFileMap cycleFileMap = new CycleIlluminaFileMap();

    MultiTileBclFileUtil(File file, int n) {
        super("^(\\d{4}).bcl.bgzf$", ".bcl.bgzf", file, (FileFaker)new MultiTileBclFileFaker(), n);
        this.basecallLaneDir = file;
        this.bci = new File(file, "s_" + n + ".bci");
        File[] fileArray = IOUtil.getFilesMatchingRegexp((File)this.base, (Pattern)this.matchPattern);
        if (this.bci.exists()) {
            this.tileIndex = new TileIndex(this.bci);
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    String string = file2.getName();
                    String string2 = string.substring(0, string.indexOf(46));
                    IlluminaFileMap illuminaFileMap = new IlluminaFileMap();
                    for (Integer n2 : this.tileIndex.getTiles()) {
                        illuminaFileMap.put(n2, file2);
                    }
                    this.cycleFileMap.put(Integer.valueOf(string2), illuminaFileMap);
                }
            }
        } else {
            this.tileIndex = null;
        }
    }

    public CycleIlluminaFileMap getFiles(List<Integer> list, int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (int n : nArray) {
            if (!this.cycleFileMap.containsKey(n)) continue;
            arrayList.add(n);
        }
        Collections.sort(arrayList);
        int[] nArray2 = new int[arrayList.size()];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = (Integer)arrayList.get(i);
        }
        CycleIlluminaFileMap cycleIlluminaFileMap = new CycleIlluminaFileMap();
        if (nArray2.length > 0) {
            for (int n : nArray2) {
                IlluminaFileMap illuminaFileMap = ((IlluminaFileMap)this.cycleFileMap.get(n)).keep(list);
                cycleIlluminaFileMap.put(n, illuminaFileMap);
            }
        }
        return cycleIlluminaFileMap;
    }

    @Override
    public boolean filesAvailable() {
        return this.bci.exists() && this.cycleFileMap.size() > 0;
    }

    @Override
    public List<Integer> getTiles() {
        if (this.tileIndex == null) {
            return Collections.emptyList();
        }
        return this.tileIndex.getTiles();
    }

    @Override
    public List<String> verify(List<Integer> list, int[] nArray) {
        if (this.tileIndex == null) {
            return Collections.singletonList("Tile index(" + this.bci.getAbsolutePath() + ") does not exist!");
        }
        List<String> list2 = this.tileIndex.verify(list);
        for (int n : nArray) {
            if (this.cycleFileMap.containsKey(n)) continue;
            list2.add(n + ".bcl.bgzf not found in " + this.base);
        }
        return list2;
    }

    @Override
    public List<String> fakeFiles(List<Integer> list, int[] nArray, IlluminaFileUtil.SupportedIlluminaFormat supportedIlluminaFormat) {
        if (this.tileIndex == null) {
            return Collections.singletonList("Tile index(" + this.bci.getAbsolutePath() + ") does not exist!");
        }
        List<String> list2 = this.tileIndex.verify(list);
        for (int n : nArray) {
            if (this.cycleFileMap.containsKey(n)) continue;
            list2.add(n + ".bcl.bgzf not found in " + this.base);
        }
        return list2;
    }
}

