/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CloseableIterator;
import java.io.File;
import java.util.List;
import java.util.NoSuchElementException;
import picard.illumina.parser.BclData;
import picard.illumina.parser.BclParser;
import picard.illumina.parser.CycleIlluminaFileMap;
import picard.illumina.parser.OutputMapping;
import picard.illumina.parser.PerTileCycleParser;
import picard.illumina.parser.TileIndex;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.illumina.parser.readers.BclReader;

public class MultiTileBclParser
extends BclParser {
    private final TileIndex tileIndex;
    private MultiTileBclDataCycleFileParser cycleFileParser = null;

    public MultiTileBclParser(File file, int n, CycleIlluminaFileMap cycleIlluminaFileMap, OutputMapping outputMapping, boolean bl, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, TileIndex tileIndex) {
        super(file, n, cycleIlluminaFileMap, outputMapping, bl, bclQualityEvaluationStrategy);
        this.tileIndex = tileIndex;
        this.initialize();
    }

    @Override
    public void initialize() {
        if (this.tileIndex != null) {
            this.seekToTile(this.currentTile);
        }
    }

    private CountLimitedIterator makeReader(List<File> list) {
        if (this.tileIndex != null) {
            BclReader bclReader = BclReader.makeSeekable(list, this.bclQualityEvaluationStrategy, this.outputMapping.getOutputReadLengths());
            int n = bclReader.seek(list, this.tileIndex, this.currentTile);
            return new CountLimitedIterator(bclReader, n);
        }
        return null;
    }

    @Override
    protected PerTileCycleParser.CycleFilesParser<BclData> makeCycleFileParser(List<File> list) {
        if (this.cycleFileParser == null) {
            this.cycleFileParser = new MultiTileBclDataCycleFileParser(list, this.currentTile);
        } else {
            int n = this.cycleFileParser.getReader().seek(list, this.tileIndex, this.currentTile);
            this.cycleFileParser.setCurrentTile(this.currentTile);
            this.cycleFileParser.resetClusterLimit(n);
        }
        return this.cycleFileParser;
    }

    private class MultiTileBclDataCycleFileParser
    implements PerTileCycleParser.CycleFilesParser<BclData> {
        final CountLimitedIterator reader;
        int currentTile;

        public MultiTileBclDataCycleFileParser(List<File> list, int n) {
            this.currentTile = n;
            this.reader = MultiTileBclParser.this.makeReader(list);
        }

        @Override
        public void close() {
            this.reader.close();
        }

        @Override
        public BclData next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.reader.next();
        }

        @Override
        public boolean hasNext() {
            try {
                return this.reader.hasNext();
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }

        public int getCurrentTile() {
            return this.currentTile;
        }

        public BclReader getReader() {
            return this.reader.getUnderlyingIterator();
        }

        public void resetClusterLimit(int n) {
            this.reader.recordLimit = n;
            this.reader.numRecordsRead = 0;
        }

        public void setCurrentTile(int n) {
            this.currentTile = n;
        }
    }

    static class CountLimitedIterator
    implements CloseableIterator<BclData> {
        private final BclReader underlyingIterator;
        private int recordLimit;
        private int numRecordsRead = 0;

        public BclReader getUnderlyingIterator() {
            return this.underlyingIterator;
        }

        CountLimitedIterator(BclReader bclReader, int n) {
            this.underlyingIterator = bclReader;
            this.recordLimit = n;
        }

        public void close() {
        }

        public boolean hasNext() {
            return this.numRecordsRead < this.recordLimit && this.underlyingIterator.hasNext();
        }

        public BclData next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.numRecordsRead;
            return this.underlyingIterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

