/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import java.io.File;
import java.util.Collections;
import java.util.List;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.MultiTileParser;
import picard.illumina.parser.PositionalData;
import picard.illumina.parser.TileIndex;
import picard.illumina.parser.readers.AbstractIlluminaPositionFileReader;
import picard.illumina.parser.readers.LocsFileReader;

public class MultiTileLocsParser
extends MultiTileParser<PositionalData> {
    private final LocsFileReader reader;
    private final int lane;

    public MultiTileLocsParser(TileIndex tileIndex, List<Integer> list, File file, int n) {
        super(tileIndex, list, Collections.singleton(IlluminaDataType.Position));
        int n2 = list.size() == 1 ? list.get(0) : -1;
        this.reader = new LocsFileReader(file, n, n2);
        this.lane = n;
    }

    @Override
    PositionalData readNext() {
        final int n = this.getTileOfNextCluster();
        final AbstractIlluminaPositionFileReader.PositionInfo positionInfo = this.reader.next();
        return new PositionalData(){

            @Override
            public int getXCoordinate() {
                return positionInfo.xQseqCoord;
            }

            @Override
            public int getYCoordinate() {
                return positionInfo.yQseqCoord;
            }

            public int getLane() {
                return MultiTileLocsParser.this.lane;
            }

            public int getTile() {
                return n;
            }
        };
    }

    @Override
    void skipRecords(int n) {
        this.reader.skipRecords(n);
    }

    @Override
    public void close() {
        this.reader.close();
    }
}

