/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picard.PicardException;
import picard.illumina.parser.IlluminaFileMap;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.fakers.FileFaker;

public abstract class ParameterizedFileUtil {
    public static final String PER_TILE_PATTERN_STRING = "s_(\\d+)_(\\d{1,5})";
    protected final String extension;
    protected Pattern matchPattern;
    protected final int lane;
    protected List<Integer> tiles;
    protected final File base;
    protected final FileFaker faker;
    protected static final boolean DefaultSkipEmptyFiles = true;
    protected final boolean skipEmptyFiles;

    public ParameterizedFileUtil(boolean bl, String string, File file, FileFaker fileFaker, int n, boolean bl2) {
        this(string, file, fileFaker, n, bl2);
        this.matchPattern = bl ? Pattern.compile(this.escapePeriods(ParameterizedFileUtil.makeLaneTileRegex(this.processTxtExtension(string), n))) : Pattern.compile(this.escapePeriods(this.makeLaneRegex(string, n)));
    }

    public ParameterizedFileUtil(boolean bl, String string, File file, FileFaker fileFaker, int n) {
        this(bl, string, file, fileFaker, n, true);
    }

    public ParameterizedFileUtil(String string, String string2, File file, FileFaker fileFaker, int n) {
        this(string2, file, fileFaker, n);
        this.matchPattern = Pattern.compile(string);
    }

    private ParameterizedFileUtil(String string, File file, FileFaker fileFaker, int n) {
        this(string, file, fileFaker, n, true);
    }

    private ParameterizedFileUtil(String string, File file, FileFaker fileFaker, int n, boolean bl) {
        this.faker = fileFaker;
        this.extension = string;
        this.base = file;
        this.lane = n;
        this.skipEmptyFiles = bl;
    }

    public abstract boolean filesAvailable();

    public List<Integer> getTiles() {
        return this.tiles;
    }

    public abstract List<String> verify(List<Integer> var1, int[] var2);

    public abstract List<String> fakeFiles(List<Integer> var1, int[] var2, IlluminaFileUtil.SupportedIlluminaFormat var3);

    protected Integer fileToTile(String string) {
        Matcher matcher = this.matchPattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        return Integer.parseInt(matcher.group(1));
    }

    public static String makeLaneTileRegex(String string, int n) {
        if (n < 0) {
            throw new PicardException("Lane (" + n + ") cannot be negative");
        }
        return "^s_" + n + "_(\\d{1,5})" + string + "$";
    }

    private String makeLaneRegex(String string, int n) {
        return "^s_" + n + string + "$";
    }

    private String escapePeriods(String string) {
        return string.replaceAll("\\.", "\\.");
    }

    private String processTxtExtension(String string) {
        if (string.endsWith(".txt")) {
            return string + "(\\.gz|\\.bz2)?";
        }
        return string;
    }

    protected IlluminaFileMap getTiledFiles(File file, Pattern pattern) {
        IlluminaFileMap illuminaFileMap = new IlluminaFileMap();
        if (file.exists()) {
            File[] fileArray;
            IOUtil.assertDirectoryIsReadable((File)file);
            for (File file2 : fileArray = IOUtil.getFilesMatchingRegexp((File)file, (Pattern)pattern)) {
                if (this.skipEmptyFiles && file2.length() <= 0L) continue;
                illuminaFileMap.put(this.fileToTile(file2.getName()), file2);
            }
        }
        return illuminaFileMap;
    }
}

