/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picard.PicardException;
import picard.illumina.parser.CycleIlluminaFileMap;
import picard.illumina.parser.IlluminaFileMap;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.ParameterizedFileUtil;
import picard.illumina.parser.fakers.FileFaker;
import picard.illumina.parser.readers.BclReader;

public class PerTilePerCycleFileUtil
extends ParameterizedFileUtil {
    private final CycleIlluminaFileMap cycleFileMap;
    private final Set<Integer> detectedCycles = new TreeSet<Integer>();

    public PerTilePerCycleFileUtil(String string, File file, FileFaker fileFaker, int n) {
        super(true, string, file, fileFaker, n);
        this.cycleFileMap = this.getPerTilePerCycleFiles();
    }

    protected CycleIlluminaFileMap getPerTilePerCycleFiles() {
        CycleIlluminaFileMap cycleIlluminaFileMap = new CycleIlluminaFileMap();
        File file = this.base;
        File[] fileArray = IOUtil.getFilesMatchingRegexp((File)file, (Pattern)IlluminaFileUtil.CYCLE_SUBDIRECTORY_PATTERN);
        if (fileArray == null || fileArray.length == 0) {
            return cycleIlluminaFileMap;
        }
        for (File file2 : fileArray) {
            this.detectedCycles.add(PerTilePerCycleFileUtil.getCycleFromDir(file2));
        }
        HashSet hashSet = new HashSet();
        for (File file3 : fileArray) {
            IlluminaFileMap illuminaFileMap = this.getTiledFiles(file3, this.matchPattern);
            hashSet.addAll(illuminaFileMap.keySet());
            cycleIlluminaFileMap.put(PerTilePerCycleFileUtil.getCycleFromDir(file3), illuminaFileMap);
        }
        this.tiles = Collections.unmodifiableList(new ArrayList(hashSet));
        return cycleIlluminaFileMap;
    }

    public CycleIlluminaFileMap getFiles() {
        return this.cycleFileMap;
    }

    public CycleIlluminaFileMap getFiles(List<Integer> list) {
        return this.cycleFileMap.keep(list, this.detectedCycles);
    }

    public CycleIlluminaFileMap getFiles(int[] nArray) {
        Set<Integer> set = this.removeNonExistentCycles(nArray);
        return this.cycleFileMap.keep(this.tiles, set);
    }

    public CycleIlluminaFileMap getFiles(List<Integer> list, int[] nArray) {
        Set<Integer> set = this.removeNonExistentCycles(nArray);
        return this.cycleFileMap.keep(list, set);
    }

    private Set<Integer> removeNonExistentCycles(int[] nArray) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int[] nArray2 = nArray;
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            Integer n2 = nArray2[i];
            treeSet.add(n2);
        }
        treeSet.retainAll(this.detectedCycles);
        return treeSet;
    }

    public Set<Integer> getDetectedCycles() {
        return this.detectedCycles;
    }

    @Override
    public List<Integer> getTiles() {
        return this.tiles;
    }

    @Override
    public boolean filesAvailable() {
        boolean bl = false;
        for (IlluminaFileMap illuminaFileMap : this.cycleFileMap.values()) {
            if (illuminaFileMap.isEmpty()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public List<String> verify(List<Integer> list, int[] nArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        HashMap<Integer, Long> hashMap = new HashMap<Integer, Long>();
        if (!this.base.exists()) {
            linkedList.add("Base directory(" + this.base.getAbsolutePath() + ") does not exist!");
        } else {
            CycleIlluminaFileMap cycleIlluminaFileMap = this.getFiles(list, nArray);
            for (int n : nArray) {
                IlluminaFileMap illuminaFileMap = (IlluminaFileMap)cycleIlluminaFileMap.get(n);
                if (illuminaFileMap != null) {
                    for (int n2 : list) {
                        File file = (File)illuminaFileMap.get(n2);
                        if (file != null) {
                            if (hashMap.get(n2) == null) {
                                hashMap.put(n2, file.length());
                                continue;
                            }
                            if (this.extension.equals(".bcl.gz") || ((Long)hashMap.get(n2)).longValue() == file.length()) continue;
                            linkedList.add("File type " + this.extension + " has cycles files of different length.  Current cycle (" + n + ") " + "Length of first non-empty file (" + hashMap.get(n2) + ") length of current cycle (" + file.length() + ")" + " File(" + file.getAbsolutePath() + ")");
                            continue;
                        }
                        linkedList.add("File type " + this.extension + " is missing a file for cycle " + n + " and tile " + n2);
                    }
                    continue;
                }
                linkedList.add("Missing file for cycle " + n + " in directory " + this.base.getAbsolutePath() + " for file type " + this.extension);
            }
        }
        return linkedList;
    }

    @Override
    public List<String> fakeFiles(List<Integer> list, int[] nArray, IlluminaFileUtil.SupportedIlluminaFormat supportedIlluminaFormat) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (!this.base.exists()) {
            this.base.mkdirs();
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Object object = nArray;
        int n = ((int[])object).length;
        for (int i = 0; i < n; ++i) {
            Integer n2 = object[i];
            treeSet.add(n2);
        }
        treeSet.removeAll(this.detectedCycles);
        object = treeSet.iterator();
        while (object.hasNext()) {
            Integer n3 = (Integer)object.next();
            File file = new File(this.base, "C" + n3 + ".1");
            if (!file.mkdirs()) continue;
            this.detectedCycles.add(n3);
        }
        object = this.getPerTilePerCycleFiles();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int n4 : nArray) {
            File file;
            IlluminaFileMap illuminaFileMap = (IlluminaFileMap)((TreeMap)object).get(n4);
            if (illuminaFileMap == null) {
                for (Integer n5 : list) {
                    file = new File(this.base + File.separator + this.getFileForCycle(n4, n5));
                    try {
                        if (hashMap.containsKey(n5)) {
                            this.faker.fakeFile(file, (Integer)hashMap.get(n5));
                            continue;
                        }
                        this.faker.fakeFile(file, 1);
                    }
                    catch (IOException iOException) {
                        linkedList.add("Could not create fake file: " + iOException.getMessage());
                    }
                }
                continue;
            }
            for (int n6 : list) {
                file = (File)illuminaFileMap.get(n6);
                if (file != null && !hashMap.containsKey(n6)) {
                    hashMap.put(n6, (int)BclReader.getNumberOfClusters(file));
                }
                try {
                    if (file != null) continue;
                    File file2 = new File(this.base + File.separator + this.getFileForCycle(n4, n6));
                    if (hashMap.containsKey(n6)) {
                        this.faker.fakeFile(file2, (Integer)hashMap.get(n6));
                        continue;
                    }
                    this.faker.fakeFile(file2, 1);
                }
                catch (IOException iOException) {
                    linkedList.add("Could not create fake file: " + iOException.getMessage());
                }
            }
        }
        Object object2 = treeSet.iterator();
        while (object2.hasNext()) {
            Integer n7 = (Integer)object2.next();
            linkedList.add("Missing cycle directory " + n7 + " in directory " + this.base.getAbsolutePath() + " for file type " + this.extension);
        }
        return linkedList;
    }

    private String getFileForCycle(int n, int n2) {
        return "C" + n + ".1" + File.separator + "s_" + this.lane + "_" + n2 + this.extension;
    }

    private static int getCycleFromDir(File file) {
        String string = file.getName();
        Matcher matcher = IlluminaFileUtil.CYCLE_SUBDIRECTORY_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new PicardException("Invalid cycle directory name " + file.getName());
        }
        return Integer.parseInt(matcher.group(1));
    }
}

