/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CollectionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import picard.illumina.parser.TilePhasingValue;
import picard.illumina.parser.TileTemplateRead;

public class Tile {
    private final int lane;
    private final int tile;
    private final float density;
    private final float clusters;
    private final Map<TileTemplateRead, Float> phasingMap;
    private final Map<TileTemplateRead, Float> prePhasingMap;

    public Tile(int n, int n2, float f, float f2, TilePhasingValue ... tilePhasingValueArray) {
        this.lane = n;
        this.tile = n2;
        this.density = f;
        this.clusters = f2;
        Collection<TilePhasingValue> collection = Tile.ensureSoleTilePhasingValuesPerRead(Arrays.asList(tilePhasingValueArray));
        HashMap<TileTemplateRead, Float> hashMap = new HashMap<TileTemplateRead, Float>();
        HashMap<TileTemplateRead, Float> hashMap2 = new HashMap<TileTemplateRead, Float>();
        for (TilePhasingValue tilePhasingValue : collection) {
            hashMap.put(tilePhasingValue.getTileTemplateRead(), Float.valueOf(tilePhasingValue.getPhasingValue()));
            hashMap2.put(tilePhasingValue.getTileTemplateRead(), Float.valueOf(tilePhasingValue.getPrePhasingValue()));
        }
        this.phasingMap = Collections.unmodifiableMap(hashMap);
        this.prePhasingMap = Collections.unmodifiableMap(hashMap2);
    }

    public int getLaneNumber() {
        return this.lane;
    }

    public int getTileNumber() {
        return this.tile;
    }

    public float getClusterDensity() {
        return this.density;
    }

    public float getClusterCount() {
        return this.clusters;
    }

    public Map<TileTemplateRead, Float> getPhasingMap() {
        return this.phasingMap;
    }

    public Map<TileTemplateRead, Float> getPrePhasingMap() {
        return this.prePhasingMap;
    }

    private static Collection<TilePhasingValue> ensureSoleTilePhasingValuesPerRead(Collection<TilePhasingValue> collection) {
        Map map = CollectionUtil.partition(collection, (CollectionUtil.Partitioner)new CollectionUtil.Partitioner<TilePhasingValue, TileTemplateRead>(){

            public TileTemplateRead getPartition(TilePhasingValue tilePhasingValue) {
                return tilePhasingValue.getTileTemplateRead();
            }
        });
        LinkedList<TilePhasingValue> linkedList = new LinkedList<TilePhasingValue>();
        for (TileTemplateRead tileTemplateRead : map.keySet()) {
            linkedList.add((TilePhasingValue)CollectionUtil.getSoleElement((Collection)((Collection)map.get((Object)tileTemplateRead))));
        }
        return linkedList;
    }
}

