/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import picard.PicardException;

public class TileIndex
implements Iterable<TileIndexRecord> {
    private final File tileIndexFile;
    private final List<TileIndexRecord> tiles = new ArrayList<TileIndexRecord>();

    TileIndex(File file) {
        try {
            this.tileIndexFile = file;
            InputStream inputStream = IOUtil.maybeBufferInputStream((InputStream)new FileInputStream(file));
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int n = 0;
            int n2 = 0;
            while (this.readTileIndexRecord(byteBuffer.array(), byteBuffer.capacity(), inputStream)) {
                byteBuffer.rewind();
                byteBuffer.limit(byteBuffer.capacity());
                int n3 = byteBuffer.getInt();
                if (n3 < 0) {
                    throw new PicardException("Tile number too large in " + file.getAbsolutePath());
                }
                int n4 = byteBuffer.getInt();
                if (n4 < 0) {
                    throw new PicardException("Cluster size too large in " + file.getAbsolutePath());
                }
                this.tiles.add(new TileIndexRecord(n3, n4, n, n2++));
                n += n4;
            }
            CloserUtil.close((Object)inputStream);
        }
        catch (IOException iOException) {
            throw new PicardException("Problem reading " + file.getAbsolutePath(), iOException);
        }
    }

    public File getFile() {
        return this.tileIndexFile;
    }

    public int getNumTiles() {
        return this.tiles.size();
    }

    private boolean readTileIndexRecord(byte[] byArray, int n, InputStream inputStream) throws IOException {
        int n2;
        for (int i = 0; i < n; i += n2) {
            n2 = inputStream.read(byArray, i, n - i);
            if (n2 != -1) continue;
            if (i != 0) {
                throw new PicardException(this.tileIndexFile.getAbsolutePath() + " has incomplete last block");
            }
            return false;
        }
        return true;
    }

    public List<Integer> getTiles() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.tiles.size());
        for (TileIndexRecord tileIndexRecord : this.tiles) {
            arrayList.add(tileIndexRecord.tile);
        }
        return arrayList;
    }

    public List<String> verify(List<Integer> list) {
        HashSet<Integer> hashSet = new HashSet<Integer>(this.tiles.size());
        for (TileIndexRecord object2 : this.tiles) {
            hashSet.add(object2.tile);
        }
        LinkedList linkedList = new LinkedList();
        for (int n : list) {
            if (hashSet.contains(n)) continue;
            linkedList.add("Tile " + n + " not found in " + this.tileIndexFile.getAbsolutePath());
        }
        return linkedList;
    }

    @Override
    public Iterator<TileIndexRecord> iterator() {
        return this.tiles.iterator();
    }

    public TileIndexRecord findTile(int n) {
        for (TileIndexRecord tileIndexRecord : this) {
            if (tileIndexRecord.tile == n) {
                return tileIndexRecord;
            }
            if (tileIndexRecord.tile <= n) continue;
            break;
        }
        throw new NoSuchElementException(String.format("Tile %d not found in %s", n, this.tileIndexFile));
    }

    public static class TileIndexRecord {
        final int tile;
        final int numClustersInTile;
        final int indexOfFirstClusterInTile;
        final int zeroBasedTileNumber;

        public int getNumClustersInTile() {
            return this.numClustersInTile;
        }

        public int getZeroBasedTileNumber() {
            return this.zeroBasedTileNumber;
        }

        private TileIndexRecord(int n, int n2, int n3, int n4) {
            this.tile = n;
            this.numClustersInTile = n2;
            this.indexOfFirstClusterInTile = n3;
            this.zeroBasedTileNumber = n4;
        }
    }
}

