/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IterableAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.illumina.parser.IlluminaMetricsCode;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.ReadType;
import picard.illumina.parser.Tile;
import picard.illumina.parser.TilePhasingValue;
import picard.illumina.parser.TileTemplateRead;
import picard.illumina.parser.readers.TileMetricsOutReader;

public class TileMetricsUtil {
    public static String INTEROP_SUBDIRECTORY_NAME = "InterOp";
    public static String TILE_METRICS_OUT_FILE_NAME = "TileMetricsOut.bin";

    public static File renderTileMetricsFileFromBasecallingDirectory(File file) {
        return new File(new File(file, INTEROP_SUBDIRECTORY_NAME), TILE_METRICS_OUT_FILE_NAME);
    }

    public static Collection<Tile> parseTileMetrics(File file, ReadStructure readStructure) throws FileNotFoundException {
        Collection<TileMetricsOutReader.IlluminaTileMetrics> collection = TileMetricsUtil.determineLastValueForLaneTileMetricsCode(new TileMetricsOutReader(file));
        Map<String, Collection<TileMetricsOutReader.IlluminaTileMetrics>> map = TileMetricsUtil.partitionTileMetricsByLocation(collection);
        LinkedList<Tile> linkedList = new LinkedList<Tile>();
        for (Map.Entry<String, Collection<TileMetricsOutReader.IlluminaTileMetrics>> entry : map.entrySet()) {
            Collection<TileMetricsOutReader.IlluminaTileMetrics> collection2 = entry.getValue();
            Map<Integer, Collection<TileMetricsOutReader.IlluminaTileMetrics>> map2 = TileMetricsUtil.partitionTileMetricsByCode(collection2);
            Set<Integer> set = map2.keySet();
            if (!set.contains(IlluminaMetricsCode.DENSITY_ID.getMetricsCode()) || !set.contains(IlluminaMetricsCode.CLUSTER_ID.getMetricsCode())) {
                throw new PicardException(String.format("Expected to find cluster and density record codes (%s and %s) in records read for tile location %s (lane:tile), but found only %s.", IlluminaMetricsCode.CLUSTER_ID.getMetricsCode(), IlluminaMetricsCode.DENSITY_ID.getMetricsCode(), entry.getKey(), set));
            }
            TileMetricsOutReader.IlluminaTileMetrics illuminaTileMetrics = (TileMetricsOutReader.IlluminaTileMetrics)CollectionUtil.getSoleElement(map2.get(IlluminaMetricsCode.DENSITY_ID.getMetricsCode()));
            TileMetricsOutReader.IlluminaTileMetrics illuminaTileMetrics2 = (TileMetricsOutReader.IlluminaTileMetrics)CollectionUtil.getSoleElement(map2.get(IlluminaMetricsCode.CLUSTER_ID.getMetricsCode()));
            Collection<TilePhasingValue> collection3 = TileMetricsUtil.getTilePhasingValues(map2, readStructure);
            linkedList.add(new Tile(illuminaTileMetrics.getLaneNumber(), illuminaTileMetrics.getTileNumber(), illuminaTileMetrics.getMetricValue(), illuminaTileMetrics2.getMetricValue(), collection3.toArray(new TilePhasingValue[collection3.size()])));
        }
        return Collections.unmodifiableCollection(linkedList);
    }

    private static Collection<TilePhasingValue> getTilePhasingValues(Map<Integer, Collection<TileMetricsOutReader.IlluminaTileMetrics>> map, ReadStructure readStructure) {
        boolean bl = true;
        ArrayList<TilePhasingValue> arrayList = new ArrayList<TilePhasingValue>();
        for (int i = 0; i < readStructure.descriptors.size(); ++i) {
            if (readStructure.descriptors.get((int)i).type != ReadType.Template) continue;
            TileTemplateRead tileTemplateRead = bl ? TileTemplateRead.FIRST : TileTemplateRead.SECOND;
            int n = IlluminaMetricsCode.getPhasingCode(i, IlluminaMetricsCode.PHASING_BASE);
            int n2 = IlluminaMetricsCode.getPhasingCode(i, IlluminaMetricsCode.PREPHASING_BASE);
            if (!map.containsKey(n) || !map.containsKey(n2)) {
                throw new PicardException("Don't have both phasing and prephasing values for tile");
            }
            arrayList.add(new TilePhasingValue(tileTemplateRead, ((TileMetricsOutReader.IlluminaTileMetrics)CollectionUtil.getSoleElement(map.get(n))).getMetricValue(), ((TileMetricsOutReader.IlluminaTileMetrics)CollectionUtil.getSoleElement(map.get(n2))).getMetricValue()));
            bl = false;
        }
        return arrayList;
    }

    private static Collection<TileMetricsOutReader.IlluminaTileMetrics> determineLastValueForLaneTileMetricsCode(Iterator<TileMetricsOutReader.IlluminaTileMetrics> iterator) {
        HashMap<TileMetricsOutReader.IlluminaLaneTileCode, TileMetricsOutReader.IlluminaTileMetrics> hashMap = new HashMap<TileMetricsOutReader.IlluminaLaneTileCode, TileMetricsOutReader.IlluminaTileMetrics>();
        for (TileMetricsOutReader.IlluminaTileMetrics illuminaTileMetrics : new IterableAdapter(iterator)) {
            hashMap.put(illuminaTileMetrics.getLaneTileCode(), illuminaTileMetrics);
        }
        return hashMap.values();
    }

    private static String renderMetricLocationKey(TileMetricsOutReader.IlluminaTileMetrics illuminaTileMetrics) {
        return String.format("%s:%s", illuminaTileMetrics.getLaneNumber(), illuminaTileMetrics.getTileNumber());
    }

    private static Map<Integer, Collection<TileMetricsOutReader.IlluminaTileMetrics>> partitionTileMetricsByCode(Collection<TileMetricsOutReader.IlluminaTileMetrics> collection) {
        return CollectionUtil.partition(collection, (CollectionUtil.Partitioner)new CollectionUtil.Partitioner<TileMetricsOutReader.IlluminaTileMetrics, Integer>(){

            public Integer getPartition(TileMetricsOutReader.IlluminaTileMetrics illuminaTileMetrics) {
                return illuminaTileMetrics.getMetricCode();
            }
        });
    }

    private static Map<String, Collection<TileMetricsOutReader.IlluminaTileMetrics>> partitionTileMetricsByLocation(Collection<TileMetricsOutReader.IlluminaTileMetrics> collection) {
        return CollectionUtil.partition(collection, (CollectionUtil.Partitioner)new CollectionUtil.Partitioner<TileMetricsOutReader.IlluminaTileMetrics, String>(){

            public String getPartition(TileMetricsOutReader.IlluminaTileMetrics illuminaTileMetrics) {
                return TileMetricsUtil.renderMetricLocationKey(illuminaTileMetrics);
            }
        });
    }
}

