/*
 * Decompiled with CFR 0.152.
 */
package picard.reference;

import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Fasta;

@CommandLineProgramProperties(usage="Takes any file that conforms to the fasta format and normalizes it so that all lines of sequence except the last line per named sequence are of the same length.", usageShort="Normalizes lines of sequence in a fasta file to be of the same length", programGroup=Fasta.class)
public class NormalizeFasta
extends CommandLineProgram {
    @Option(shortName="I", doc="The input fasta file to normalize.")
    public File INPUT;
    @Option(shortName="O", doc="The output fasta file to write.")
    public File OUTPUT;
    @Option(doc="The line length to be used for the output fasta file.")
    public int LINE_LENGTH = 100;
    @Option(doc="Truncate sequence names at first whitespace.")
    public boolean TRUNCATE_SEQUENCE_NAMES_AT_WHITESPACE = false;
    private final Log log = Log.getInstance(NormalizeFasta.class);

    public static void main(String[] stringArray) {
        new NormalizeFasta().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (this.INPUT.getAbsoluteFile().equals(this.OUTPUT.getAbsoluteFile())) {
            throw new IllegalArgumentException("Input and output cannot be the same file.");
        }
        ReferenceSequenceFile referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)this.INPUT, (boolean)this.TRUNCATE_SEQUENCE_NAMES_AT_WHITESPACE);
        BufferedWriter bufferedWriter = IOUtil.openFileForBufferedWriting((File)this.OUTPUT);
        ReferenceSequence referenceSequence = null;
        while ((referenceSequence = referenceSequenceFile.nextSequence()) != null) {
            String string = referenceSequence.getName();
            byte[] byArray = referenceSequence.getBases();
            try {
                bufferedWriter.write(">");
                bufferedWriter.write(string);
                bufferedWriter.newLine();
                if (byArray.length == 0) {
                    this.log.warn(new Object[]{"Sequence " + string + " contains 0 bases."});
                    continue;
                }
                for (int i = 0; i < byArray.length; ++i) {
                    if (i > 0 && i % this.LINE_LENGTH == 0) {
                        bufferedWriter.write("\n");
                    }
                    bufferedWriter.write(byArray[i]);
                }
                bufferedWriter.write("\n");
            }
            catch (IOException iOException) {
                throw new PicardException("Error writing to file " + this.OUTPUT.getAbsolutePath(), iOException);
            }
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException((Throwable)iOException);
        }
        return 0;
    }
}

