/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.ReservedTagConstants;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordCoordinateComparator;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMRecordUtil;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.filter.FilteringIterator;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.CigarUtil;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.ProgressLoggerInterface;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import picard.PicardException;
import picard.sam.HitsForInsert;
import picard.sam.MultiHitAlignedReadIterator;
import picard.sam.PrimaryAlignmentSelectionStrategy;

public abstract class AbstractAlignmentMerger {
    public static final int MAX_RECORDS_IN_RAM = 500000;
    private static final char[] RESERVED_ATTRIBUTE_STARTS = new char[]{'X', 'Y', 'Z'};
    private final Log log = Log.getInstance(AbstractAlignmentMerger.class);
    private final ProgressLogger progress = new ProgressLogger(this.log, 1000000, "Merged", "records");
    private final File unmappedBamFile;
    private final File targetBamFile;
    private final SAMSequenceDictionary sequenceDictionary;
    private ReferenceSequenceFileWalker refSeq = null;
    private final boolean clipAdapters;
    private final boolean bisulfiteSequence;
    private SAMProgramRecord programRecord;
    private final boolean alignedReadsOnly;
    private final SAMFileHeader header;
    private final List<String> attributesToRetain = new ArrayList<String>();
    private final List<String> attributesToRemove = new ArrayList<String>();
    protected final File referenceFasta;
    private final Integer read1BasesTrimmed;
    private final Integer read2BasesTrimmed;
    private final List<SamPairUtil.PairOrientation> expectedOrientations;
    private final SAMFileHeader.SortOrder sortOrder;
    private MultiHitAlignedReadIterator alignedIterator = null;
    private boolean clipOverlappingReads = true;
    private int maxRecordsInRam = 500000;
    private final PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy;
    private boolean keepAlignerProperPairFlags = false;
    private boolean addMateCigar = false;
    private boolean unmapContaminantReads = false;
    private final SamRecordFilter alignmentFilter = new SamRecordFilter(){

        public boolean filterOut(SAMRecord sAMRecord) {
            return AbstractAlignmentMerger.this.ignoreAlignment(sAMRecord);
        }

        public boolean filterOut(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
            throw new UnsupportedOperationException("Paired SamRecordFilter not implemented!");
        }
    };
    private boolean includeSecondaryAlignments = true;

    protected abstract CloseableIterator<SAMRecord> getQuerynameSortedAlignedRecords();

    protected boolean ignoreAlignment(SAMRecord sAMRecord) {
        return false;
    }

    protected boolean isContaminant(HitsForInsert hitsForInsert) {
        return false;
    }

    public AbstractAlignmentMerger(File file, File file2, File file3, boolean bl, boolean bl2, boolean bl3, SAMProgramRecord sAMProgramRecord, List<String> list, List<String> list2, Integer n, Integer n2, List<SamPairUtil.PairOrientation> list3, SAMFileHeader.SortOrder sortOrder, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy, boolean bl4, boolean bl5) {
        IOUtil.assertFileIsReadable((File)file);
        IOUtil.assertFileIsWritable((File)file2);
        IOUtil.assertFileIsReadable((File)file3);
        this.unmappedBamFile = file;
        this.targetBamFile = file2;
        this.referenceFasta = file3;
        this.refSeq = new ReferenceSequenceFileWalker(file3);
        this.sequenceDictionary = this.refSeq.getSequenceDictionary();
        if (this.sequenceDictionary == null) {
            throw new PicardException("No sequence dictionary found for " + file3.getAbsolutePath() + ".  Use CreateSequenceDictionary.jar to create a sequence dictionary.");
        }
        this.clipAdapters = bl;
        this.bisulfiteSequence = bl2;
        this.alignedReadsOnly = bl3;
        this.header = new SAMFileHeader();
        this.sortOrder = sortOrder != null ? sortOrder : SAMFileHeader.SortOrder.coordinate;
        this.header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        if (sAMProgramRecord != null) {
            this.setProgramRecord(sAMProgramRecord);
        }
        this.header.setSequenceDictionary(this.sequenceDictionary);
        if (list != null) {
            this.attributesToRetain.addAll(list);
        }
        if (list2 != null) {
            this.attributesToRemove.addAll(list2);
            if (!this.attributesToRetain.isEmpty()) {
                for (String string : this.attributesToRemove) {
                    if (!this.attributesToRetain.contains(string)) continue;
                    this.log.info(new Object[]{"Overriding retaining the " + string + " tag since remove overrides retain."});
                    this.attributesToRetain.remove(string);
                }
            }
        }
        this.read1BasesTrimmed = n;
        this.read2BasesTrimmed = n2;
        this.expectedOrientations = list3;
        this.primaryAlignmentSelectionStrategy = primaryAlignmentSelectionStrategy;
        this.addMateCigar = bl4;
        this.unmapContaminantReads = bl5;
    }

    public void setMaxRecordsInRam(int n) {
        this.maxRecordsInRam = n;
    }

    private void maybeSetPgTag(SAMRecord sAMRecord) {
        if (this.programRecord != null) {
            sAMRecord.setAttribute(ReservedTagConstants.PROGRAM_GROUP_ID, (Object)this.programRecord.getProgramGroupId());
        }
    }

    public void mergeAlignment(File file) {
        Object object;
        SAMFileWriter sAMFileWriter;
        Object object2;
        SAMFileHeader sAMFileHeader2;
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(file).open(this.unmappedBamFile);
        SAMRecordIterator sAMRecordIterator = samReader.iterator();
        this.header.setReadGroups(samReader.getFileHeader().getReadGroups());
        int n = 0;
        int n2 = 0;
        this.alignedIterator = new MultiHitAlignedReadIterator((CloseableIterator<SAMRecord>)new FilteringIterator(this.getQuerynameSortedAlignedRecords(), this.alignmentFilter), this.primaryAlignmentSelectionStrategy);
        HitsForInsert hitsForInsert = this.nextAligned();
        if (this.getProgramRecord() != null) {
            for (SAMFileHeader sAMFileHeader2 : samReader.getFileHeader().getProgramRecords()) {
                if (!sAMFileHeader2.getId().equals(this.getProgramRecord().getId())) continue;
                throw new PicardException("Program Record ID already in use in unmapped BAM file.");
            }
        }
        if (this.sortOrder == SAMFileHeader.SortOrder.coordinate) {
            sAMFileHeader2 = SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(this.header), (Comparator)new SAMRecordCoordinateComparator(), (int)500000);
            object2 = new Sink((SortingCollection<SAMRecord>)sAMFileHeader2);
        } else {
            sAMFileHeader2 = this.header.clone();
            sAMFileHeader2.setSortOrder(this.sortOrder);
            sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader2, true, this.targetBamFile);
            sAMFileWriter.setProgressLogger((ProgressLoggerInterface)new ProgressLogger(this.log, 10000000, "Wrote", "records to output in queryname order"));
            object2 = new Sink(sAMFileWriter);
        }
        while (sAMRecordIterator.hasNext()) {
            sAMFileHeader2 = (SAMRecord)sAMRecordIterator.next();
            sAMFileHeader2.setHeader(this.header);
            this.maybeSetPgTag((SAMRecord)sAMFileHeader2);
            if (sAMFileHeader2.getReadPairedFlag()) {
                sAMFileWriter = (SAMRecord)sAMRecordIterator.next();
                sAMFileWriter.setHeader(this.header);
                this.maybeSetPgTag((SAMRecord)sAMFileWriter);
                if (!sAMFileHeader2.getReadName().equals(sAMFileWriter.getReadName())) {
                    throw new PicardException("Second read from pair not found in unmapped bam: " + sAMFileHeader2.getReadName() + ", " + sAMFileWriter.getReadName());
                }
                if (!sAMFileHeader2.getFirstOfPairFlag()) {
                    throw new PicardException("First record in unmapped bam is not first of pair: " + sAMFileHeader2.getReadName());
                }
                if (!sAMFileWriter.getReadPairedFlag()) {
                    throw new PicardException("Second record in unmapped bam is not marked as paired: " + sAMFileWriter.getReadName());
                }
                if (!sAMFileWriter.getSecondOfPairFlag()) {
                    throw new PicardException("Second record in unmapped bam is not second of pair: " + sAMFileWriter.getReadName());
                }
            } else {
                sAMFileWriter = null;
            }
            if (hitsForInsert != null && sAMFileHeader2.getReadName().equals(hitsForInsert.getReadName())) {
                boolean bl;
                boolean bl2 = hitsForInsert.numHits() > 1 || hitsForInsert.hasSupplementalHits();
                SAMRecord sAMRecord = null;
                object = null;
                boolean bl3 = bl = this.unmapContaminantReads && this.isContaminant(hitsForInsert);
                if (sAMFileHeader2.getReadPairedFlag()) {
                    SAMFileWriter sAMFileWriter2;
                    Object object3;
                    for (int i = 0; i < hitsForInsert.numHits(); ++i) {
                        Object object4;
                        SAMRecord sAMRecord2 = hitsForInsert.getFirstOfPair(i);
                        SAMRecord sAMRecord3 = hitsForInsert.getSecondOfPair(i);
                        boolean bl4 = object4 = sAMRecord2 != null && !sAMRecord2.isSecondaryOrSupplementary() || sAMRecord3 != null && !sAMRecord3.isSecondaryOrSupplementary();
                        if (bl2) {
                            object3 = this.clone((SAMRecord)sAMFileHeader2);
                            sAMFileWriter2 = this.clone((SAMRecord)sAMFileWriter);
                        } else {
                            object3 = sAMFileHeader2;
                            sAMFileWriter2 = sAMFileWriter;
                        }
                        if (object4) {
                            sAMRecord = object3;
                            object = sAMFileWriter2;
                        }
                        this.transferAlignmentInfoToPairedRead((SAMRecord)object3, (SAMRecord)sAMFileWriter2, sAMRecord2, sAMRecord3, bl);
                        if (!object3.getReadUnmappedFlag() || object4) {
                            this.addIfNotFiltered((Sink)object2, (SAMRecord)object3);
                            if (object3.getReadUnmappedFlag()) {
                                ++n2;
                            } else {
                                ++n;
                            }
                        }
                        if (sAMFileWriter2.getReadUnmappedFlag() && !object4) continue;
                        this.addIfNotFiltered((Sink)object2, (SAMRecord)sAMFileWriter2);
                        if (!sAMFileWriter2.getReadUnmappedFlag()) {
                            ++n;
                            continue;
                        }
                        ++n2;
                    }
                    for (Object object4 : (Object)new boolean[]{true, false}) {
                        object3 = object4 ? hitsForInsert.getSupplementalFirstOfPairOrFragment() : hitsForInsert.getSupplementalSecondOfPair();
                        sAMFileWriter2 = object4 ? sAMFileHeader2 : sAMFileWriter;
                        Object object5 = object4 ? object : sAMRecord;
                        Iterator iterator = object3.iterator();
                        while (iterator.hasNext()) {
                            SAMRecord sAMRecord4 = (SAMRecord)iterator.next();
                            SAMRecord sAMRecord5 = this.clone((SAMRecord)sAMFileWriter2);
                            this.transferAlignmentInfoToFragment(sAMRecord5, sAMRecord4, bl);
                            if (object5 != null) {
                                SamPairUtil.setMateInformationOnSupplementalAlignment((SAMRecord)sAMRecord5, (SAMRecord)object5, (boolean)this.addMateCigar);
                            }
                            if (!sAMRecord5.getReadUnmappedFlag()) {
                                this.addIfNotFiltered((Sink)object2, sAMRecord5);
                                ++n;
                                continue;
                            }
                            ++n2;
                        }
                    }
                } else {
                    for (int i = 0; i < hitsForInsert.numHits(); ++i) {
                        SAMFileHeader sAMFileHeader3 = bl2 ? this.clone((SAMRecord)sAMFileHeader2) : sAMFileHeader2;
                        boolean bl5 = !hitsForInsert.getFragment(i).isSecondaryOrSupplementary();
                        this.transferAlignmentInfoToFragment((SAMRecord)sAMFileHeader3, hitsForInsert.getFragment(i), bl);
                        if (!sAMFileHeader3.getReadUnmappedFlag() || bl5) {
                            this.addIfNotFiltered((Sink)object2, (SAMRecord)sAMFileHeader3);
                        }
                        if (sAMFileHeader3.getReadUnmappedFlag()) {
                            ++n2;
                            continue;
                        }
                        ++n;
                    }
                    for (SAMRecord sAMRecord6 : hitsForInsert.getSupplementalFirstOfPairOrFragment()) {
                        SAMRecord sAMRecord7 = this.clone((SAMRecord)sAMFileHeader2);
                        this.transferAlignmentInfoToFragment(sAMRecord7, sAMRecord6, bl);
                        if (!sAMRecord7.getReadUnmappedFlag()) {
                            this.addIfNotFiltered((Sink)object2, sAMRecord7);
                            ++n;
                            continue;
                        }
                        ++n2;
                    }
                }
                hitsForInsert = this.nextAligned();
                continue;
            }
            if (hitsForInsert != null && SAMRecordQueryNameComparator.compareReadNames((String)sAMFileHeader2.getReadName(), (String)hitsForInsert.getReadName()) > 0) {
                throw new IllegalStateException("Aligned record iterator (" + hitsForInsert.getReadName() + ") is behind the unmapped reads (" + sAMFileHeader2.getReadName() + ")");
            }
            if (this.alignedReadsOnly) continue;
            ((Sink)object2).add((SAMRecord)sAMFileHeader2);
            ++n2;
            if (sAMFileWriter == null) continue;
            ((Sink)object2).add((SAMRecord)sAMFileWriter);
            ++n2;
        }
        sAMRecordIterator.close();
        if (this.alignedIterator.hasNext()) {
            throw new IllegalStateException("Reads remaining on alignment iterator: " + this.alignedIterator.next().getReadName() + "!");
        }
        this.alignedIterator.close();
        ((Sink)object2).close();
        if (this.sortOrder == SAMFileHeader.SortOrder.coordinate) {
            this.header.setSortOrder(this.sortOrder);
            sAMFileHeader2 = new SAMFileWriterFactory().makeSAMOrBAMWriter(this.header, true, this.targetBamFile);
            sAMFileHeader2.setProgressLogger((ProgressLoggerInterface)new ProgressLogger(this.log, 10000000, "Wrote", "records from a sorting collection"));
            sAMFileWriter = new ProgressLogger(this.log, 10000000, "Written in coordinate order to output", "records");
            for (SAMRecord sAMRecord : ((Sink)object2).sorter) {
                if (!sAMRecord.getReadUnmappedFlag() && this.refSeq != null) {
                    object = this.refSeq.get(this.sequenceDictionary.getSequenceIndex(sAMRecord.getReferenceName())).getBases();
                    sAMRecord.setAttribute(SAMTag.NM.name(), (Object)SequenceUtil.calculateSamNmTag((SAMRecord)sAMRecord, (byte[])object, (int)0, (boolean)this.bisulfiteSequence));
                    if (sAMRecord.getBaseQualities() != SAMRecord.NULL_QUALS) {
                        sAMRecord.setAttribute(SAMTag.UQ.name(), (Object)SequenceUtil.sumQualitiesOfMismatches((SAMRecord)sAMRecord, (byte[])object, (int)0, (boolean)this.bisulfiteSequence));
                    }
                }
                sAMFileHeader2.addAlignment(sAMRecord);
                sAMFileWriter.record(sAMRecord);
            }
            sAMFileHeader2.close();
            ((Sink)object2).sorter.cleanup();
        }
        CloserUtil.close((Object)samReader);
        this.log.info(new Object[]{"Wrote " + n + " alignment records and " + (this.alignedReadsOnly ? 0 : n2) + " unmapped reads."});
    }

    private void addIfNotFiltered(Sink sink, SAMRecord sAMRecord) {
        if (this.includeSecondaryAlignments || !sAMRecord.getNotPrimaryAlignmentFlag()) {
            sink.add(sAMRecord);
            this.progress.record(sAMRecord);
        }
    }

    private SAMRecord clone(SAMRecord sAMRecord) {
        try {
            return (SAMRecord)sAMRecord.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PicardException("Should never happen.");
        }
    }

    private HitsForInsert nextAligned() {
        if (this.alignedIterator.hasNext()) {
            return this.alignedIterator.next();
        }
        return null;
    }

    private void transferAlignmentInfoToFragment(SAMRecord sAMRecord, SAMRecord sAMRecord2, boolean bl) {
        this.setValuesFromAlignment(sAMRecord, sAMRecord2);
        this.updateCigarForTrimmedOrClippedBases(sAMRecord, sAMRecord2);
        if (SAMUtils.cigarMapsNoBasesToRef((Cigar)sAMRecord.getCigar())) {
            this.log.warn(new Object[]{"Record contains no unclipped bases; making unmapped: " + sAMRecord2});
            SAMUtils.makeReadUnmapped((SAMRecord)sAMRecord);
        } else if (SAMUtils.recordMapsEntirelyBeyondEndOfReference((SAMRecord)sAMRecord2)) {
            this.log.warn(new Object[]{"Record mapped off end of reference; making unmapped: " + sAMRecord2});
            SAMUtils.makeReadUnmapped((SAMRecord)sAMRecord);
        } else if (bl) {
            this.log.warn(new Object[]{"Record looks like foreign contamination; making unmapped: " + sAMRecord2});
            sAMRecord.setReadUnmappedFlag(true);
            sAMRecord.setMappingQuality(0);
            sAMRecord.setAttribute(SAMTag.FT.name(), (Object)"Cross-species contamination");
        }
    }

    private void transferAlignmentInfoToPairedRead(SAMRecord sAMRecord, SAMRecord sAMRecord2, SAMRecord sAMRecord3, SAMRecord sAMRecord4, boolean bl) {
        if (sAMRecord3 != null) {
            this.transferAlignmentInfoToFragment(sAMRecord, sAMRecord3, bl);
        }
        if (sAMRecord4 != null) {
            this.transferAlignmentInfoToFragment(sAMRecord2, sAMRecord4, bl);
        }
        if (this.isClipOverlappingReads()) {
            this.clipForOverlappingReads(sAMRecord, sAMRecord2);
        }
        SamPairUtil.setMateInfo((SAMRecord)sAMRecord2, (SAMRecord)sAMRecord, (SAMFileHeader)this.header, (boolean)this.addMateCigar);
        if (!this.keepAlignerProperPairFlags) {
            SamPairUtil.setProperPairFlags((SAMRecord)sAMRecord2, (SAMRecord)sAMRecord, this.expectedOrientations);
        }
    }

    protected void clipForOverlappingReads(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        if (!sAMRecord.getReadUnmappedFlag() && !sAMRecord2.getReadUnmappedFlag() && sAMRecord.getReadNegativeStrandFlag() != sAMRecord2.getReadNegativeStrandFlag()) {
            SAMRecord sAMRecord3;
            SAMRecord sAMRecord4 = sAMRecord.getReadNegativeStrandFlag() ? sAMRecord2 : sAMRecord;
            SAMRecord sAMRecord5 = sAMRecord3 = sAMRecord.getReadNegativeStrandFlag() ? sAMRecord : sAMRecord2;
            if (sAMRecord4.getAlignmentStart() < sAMRecord3.getAlignmentEnd()) {
                int n = sAMRecord4.getAlignmentEnd() - sAMRecord3.getAlignmentEnd();
                int n2 = sAMRecord4.getAlignmentStart() - sAMRecord3.getAlignmentStart();
                if (n > 0) {
                    CigarUtil.softClip3PrimeEndOfRead((SAMRecord)sAMRecord4, (int)Math.min(sAMRecord4.getReadLength(), sAMRecord4.getReadLength() - n + 1));
                }
                if (n2 > 0) {
                    CigarUtil.softClip3PrimeEndOfRead((SAMRecord)sAMRecord3, (int)Math.min(sAMRecord3.getReadLength(), sAMRecord3.getReadLength() - n2 + 1));
                }
            }
        }
    }

    protected void setValuesFromAlignment(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        for (SAMRecord.SAMTagAndValue sAMTagAndValue : sAMRecord2.getAttributes()) {
            if (this.isReservedTag(sAMTagAndValue.tag) && !this.attributesToRetain.contains(sAMTagAndValue.tag) || this.attributesToRemove.contains(sAMTagAndValue.tag)) continue;
            sAMRecord.setAttribute(sAMTagAndValue.tag, sAMTagAndValue.value);
        }
        sAMRecord.setReadUnmappedFlag(sAMRecord2.getReadUnmappedFlag());
        sAMRecord.setReferenceName(sAMRecord2.getReferenceName());
        sAMRecord.setAlignmentStart(sAMRecord2.getAlignmentStart());
        sAMRecord.setReadNegativeStrandFlag(sAMRecord2.getReadNegativeStrandFlag());
        sAMRecord.setNotPrimaryAlignmentFlag(sAMRecord2.getNotPrimaryAlignmentFlag());
        sAMRecord.setSupplementaryAlignmentFlag(sAMRecord2.getSupplementaryAlignmentFlag());
        if (!sAMRecord2.getReadUnmappedFlag()) {
            sAMRecord.setCigar(sAMRecord2.getCigar());
            sAMRecord.setMappingQuality(sAMRecord2.getMappingQuality());
        }
        if (sAMRecord.getReadPairedFlag()) {
            sAMRecord.setProperPairFlag(sAMRecord2.getProperPairFlag());
        }
        if (sAMRecord.getReadNegativeStrandFlag()) {
            SAMRecordUtil.reverseComplement((SAMRecord)sAMRecord);
        }
    }

    private static Cigar createNewCigarIfMapsOffEndOfReference(SAMFileHeader sAMFileHeader, boolean bl, int n, int n2, int n3, Cigar cigar) {
        SAMSequenceRecord sAMSequenceRecord;
        int n4;
        Cigar cigar2 = null;
        if (!bl && (n4 = n2 - (sAMSequenceRecord = sAMFileHeader.getSequence(n)).getSequenceLength()) > 0) {
            int n5 = n3 - n4 + 1;
            CigarElement cigarElement = cigar.getCigarElement(cigar.getCigarElements().size() - 1);
            if (CigarOperator.SOFT_CLIP == cigarElement.getOperator()) {
                n5 -= cigarElement.getLength();
            }
            List list = CigarUtil.softClipEndOfRead((int)n5, (List)cigar.getCigarElements());
            cigar2 = new Cigar(list);
        }
        return cigar2;
    }

    public static void createNewCigarsIfMapsOffEndOfReference(SAMRecord sAMRecord) {
        Cigar cigar;
        if (!sAMRecord.getReadUnmappedFlag() && null != (cigar = AbstractAlignmentMerger.createNewCigarIfMapsOffEndOfReference(sAMRecord.getHeader(), sAMRecord.getReadUnmappedFlag(), sAMRecord.getReferenceIndex(), sAMRecord.getAlignmentEnd(), sAMRecord.getReadLength(), sAMRecord.getCigar()))) {
            sAMRecord.setCigar(cigar);
        }
        if (SAMUtils.hasMateCigar((SAMRecord)sAMRecord)) {
            cigar = SAMUtils.getMateCigar((SAMRecord)sAMRecord);
            cigar = AbstractAlignmentMerger.createNewCigarIfMapsOffEndOfReference(sAMRecord.getHeader(), sAMRecord.getMateUnmappedFlag(), sAMRecord.getMateReferenceIndex(), SAMUtils.getMateAlignmentEnd((SAMRecord)sAMRecord), cigar.getReadLength(), cigar);
            if (null != cigar) {
                sAMRecord.setAttribute(SAMTag.MC.name(), (Object)cigar.toString());
            }
        }
    }

    protected void updateCigarForTrimmedOrClippedBases(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        int n = sAMRecord2.getReadLength();
        int n2 = sAMRecord.getReadLength();
        int n3 = !sAMRecord.getReadPairedFlag() || sAMRecord.getFirstOfPairFlag() ? (this.read1BasesTrimmed != null ? this.read1BasesTrimmed : 0) : (this.read2BasesTrimmed != null ? this.read2BasesTrimmed : 0);
        int n4 = n2 - (n + n3);
        AbstractAlignmentMerger.createNewCigarsIfMapsOffEndOfReference(sAMRecord);
        sAMRecord.setCigar(CigarUtil.addSoftClippedBasesToEndsOfCigar((Cigar)sAMRecord.getCigar(), (boolean)sAMRecord.getReadNegativeStrandFlag(), (int)n4, (int)n3));
        if (this.clipAdapters && sAMRecord.getAttribute("XT") != null) {
            CigarUtil.softClip3PrimeEndOfRead((SAMRecord)sAMRecord, (int)sAMRecord.getIntegerAttribute("XT"));
        }
    }

    protected SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    protected SAMProgramRecord getProgramRecord() {
        return this.programRecord;
    }

    protected void setProgramRecord(SAMProgramRecord sAMProgramRecord) {
        if (this.programRecord != null) {
            throw new IllegalStateException("Cannot set program record more than once on alignment merger.");
        }
        this.programRecord = sAMProgramRecord;
        this.header.addProgramRecord(sAMProgramRecord);
        SAMUtils.chainSAMProgramRecord((SAMFileHeader)this.header, (SAMProgramRecord)sAMProgramRecord);
    }

    protected boolean isReservedTag(String string) {
        char c = string.charAt(0);
        if (Character.isLowerCase(c)) {
            return true;
        }
        for (char c2 : RESERVED_ATTRIBUTE_STARTS) {
            if (c != c2) continue;
            return true;
        }
        return false;
    }

    protected SAMFileHeader getHeader() {
        return this.header;
    }

    protected void resetRefSeqFileWalker() {
        this.refSeq = new ReferenceSequenceFileWalker(this.referenceFasta);
    }

    public boolean isClipOverlappingReads() {
        return this.clipOverlappingReads;
    }

    public void setClipOverlappingReads(boolean bl) {
        this.clipOverlappingReads = bl;
    }

    public boolean isKeepAlignerProperPairFlags() {
        return this.keepAlignerProperPairFlags;
    }

    public void setKeepAlignerProperPairFlags(boolean bl) {
        this.keepAlignerProperPairFlags = bl;
    }

    public void setIncludeSecondaryAlignments(boolean bl) {
        this.includeSecondaryAlignments = bl;
    }

    public void close() {
        CloserUtil.close((Object)this.refSeq);
    }

    private static class Sink {
        private final SAMFileWriter writer;
        private final SortingCollection<SAMRecord> sorter;

        public Sink(SAMFileWriter sAMFileWriter) {
            this.writer = sAMFileWriter;
            this.sorter = null;
        }

        public Sink(SortingCollection<SAMRecord> sortingCollection) {
            this.writer = null;
            this.sorter = sortingCollection;
        }

        void add(SAMRecord sAMRecord) {
            if (this.writer != null) {
                this.writer.addAlignment(sAMRecord);
            }
            if (this.sorter != null) {
                this.sorter.add((Object)sAMRecord);
            }
        }

        void close() {
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.sorter != null) {
                this.sorter.doneAdding();
            }
        }
    }
}

