/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Generates BAM index statistics, including the number of aligned and unaligned SAMRecords for each reference sequence, and the number of SAMRecords with no coordinate.Input BAM file must have a corresponding index file.\n", usageShort="Generates index statistics from a BAM file", programGroup=SamOrBam.class)
public class BamIndexStats
extends CommandLineProgram {
    private static final Log log = Log.getInstance(BamIndexStats.class);
    @Option(shortName="I", doc="A BAM file to process.")
    public File INPUT;

    public static void main(String[] stringArray) {
        System.exit(new BamIndexStats().instanceMain(stringArray));
    }

    @Override
    protected int doWork() {
        if (this.INPUT.getName().endsWith(".bai")) {
            log.warn(new Object[]{"INPUT should be BAM file not index file"});
        }
        IOUtil.assertFileIsReadable((File)this.INPUT);
        BAMIndexMetaData.printIndexStats((File)this.INPUT);
        return 0;
    }
}

