/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMUtils;
import java.util.ArrayList;
import java.util.Random;
import picard.sam.HitsForInsert;
import picard.sam.PrimaryAlignmentSelectionStrategy;

public class BestMapqPrimaryAlignmentSelectionStrategy
implements PrimaryAlignmentSelectionStrategy {
    private final Random random = new Random(1L);

    @Override
    public void pickPrimaryAlignment(HitsForInsert hitsForInsert) {
        if (hitsForInsert.numHits() == 0) {
            throw new IllegalArgumentException("No alignments to pick from");
        }
        hitsForInsert.coordinateByHitIndex();
        HitsForInsert.NumPrimaryAlignmentState numPrimaryAlignmentState = hitsForInsert.tallyPrimaryAlignments(true);
        HitsForInsert.NumPrimaryAlignmentState numPrimaryAlignmentState2 = hitsForInsert.tallyPrimaryAlignments(false);
        if (numPrimaryAlignmentState == HitsForInsert.NumPrimaryAlignmentState.NONE && numPrimaryAlignmentState2 == HitsForInsert.NumPrimaryAlignmentState.NONE || numPrimaryAlignmentState == HitsForInsert.NumPrimaryAlignmentState.MORE_THAN_ONE || numPrimaryAlignmentState2 == HitsForInsert.NumPrimaryAlignmentState.MORE_THAN_ONE) {
            int n;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(hitsForInsert.numHits());
            int n2 = -1;
            for (n = 0; n < hitsForInsert.numHits(); ++n) {
                int n3;
                int n4 = hitsForInsert.getFirstOfPair(n) != null ? hitsForInsert.getFirstOfPair(n).getMappingQuality() : 0;
                int n5 = SAMUtils.combineMapqs((int)n4, (int)(n3 = hitsForInsert.getSecondOfPair(n) != null ? hitsForInsert.getSecondOfPair(n).getMappingQuality() : 0));
                if (n5 > n2) {
                    n2 = n5;
                    arrayList.clear();
                }
                if (n5 != n2) continue;
                arrayList.add(n);
            }
            if (arrayList.size() == 1) {
                n = (Integer)arrayList.get(0);
            } else if (arrayList.size() > 1) {
                n = (Integer)arrayList.get(this.random.nextInt(arrayList.size()));
            } else {
                throw new IllegalStateException("Never found a best MAPQ -- should never happen");
            }
            hitsForInsert.setPrimaryAlignment(n);
        }
    }
}

