/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;
import picard.sam.AbstractAlignmentMerger;

@CommandLineProgramProperties(usage="Cleans the provided SAM/BAM, soft-clipping beyond-end-of-reference alignments and setting MAPQ to 0 for unmapped reads", usageShort="Cleans the provided SAM/BAM, soft-clipping beyond-end-of-reference alignments and setting MAPQ to 0 for unmapped reads", programGroup=SamOrBam.class)
public class CleanSam
extends CommandLineProgram {
    static final String USAGE = "Cleans the provided SAM/BAM, soft-clipping beyond-end-of-reference alignments and setting MAPQ to 0 for unmapped reads";
    @Option(shortName="I", doc="Input SAM to be cleaned.")
    public File INPUT;
    @Option(shortName="O", doc="Where to write cleaned SAM.")
    public File OUTPUT;

    public static void main(String[] stringArray) {
        new CleanSam().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SamReaderFactory samReaderFactory = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE);
        if (this.VALIDATION_STRINGENCY == ValidationStringency.STRICT) {
            samReaderFactory.validationStringency(ValidationStringency.LENIENT);
        }
        SamReader samReader = samReaderFactory.open(this.INPUT);
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(samReader.getFileHeader(), true, this.OUTPUT);
        SAMRecordIterator sAMRecordIterator = samReader.iterator();
        ProgressLogger progressLogger = new ProgressLogger(Log.getInstance(CleanSam.class));
        while (sAMRecordIterator.hasNext()) {
            SAMRecord sAMRecord = (SAMRecord)sAMRecordIterator.next();
            AbstractAlignmentMerger.createNewCigarsIfMapsOffEndOfReference(sAMRecord);
            if (sAMRecord.getReadUnmappedFlag() && 0 != sAMRecord.getMappingQuality()) {
                sAMRecord.setMappingQuality(0);
            }
            sAMFileWriter.addAlignment(sAMRecord);
            progressLogger.record(sAMRecord);
        }
        sAMFileWriter.close();
        sAMRecordIterator.close();
        CloserUtil.close((Object)samReader);
        return 0;
    }
}

