/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.DownsamplingIterator;
import htsjdk.samtools.DownsamplingIteratorFactory;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Random;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Randomly down-sample a SAM or BAM file to retain only a subset of the reads in the file. All reads for a templates are kept or discarded as a unit, with the goal of retaining readsfrom PROBABILITY * input templates. While this will usually result in approximately PROBABILITY * input reads being retained also, for very small PROBABILITIES this may not be the case.\nA number of different downsampling strategies are supported using the STRATEGY option:\n\nConstantMemory: Downsamples a stream or file of SAMRecords using a hash-projection strategy such that it can run in constant memory. The downsampling is stochastic, and therefore the actual retained proportion will vary around the requested proportion. Due to working in fixed memory this strategy is good for large inputs, and due to the stochastic nature the accuracy of this strategy is highest with a high number of output records, and diminishes at low output volumes.\n\nHighAccuracy: Attempts (but does not guarantee) to provide accuracy up to a specified limit. Accuracy is defined as emitting a proportion of reads as close to the requested proportion as possible. In order to do so this strategy requires memory that is proportional to the number of template names in the incoming stream of reads, and will thus require large amounts of memory when running on large input files.\n\nChained: Attempts to provide a compromise strategy that offers some of the advantages of both the ConstantMemory and HighAccuracy strategies. Uses a ConstantMemory strategy to downsample the incoming stream to approximately the desired proportion, and then a HighAccuracy strategy to finish. Works in a single pass, and will provide accuracy close to (but often not as good as) HighAccuracy while requiring memory proportional to the set of reads emitted from the ConstantMemory strategy to the HighAccuracy strategy. Works well when downsampling large inputs to small proportions (e.g. downsampling hundreds of millions of reads and retaining only 2%. Should be accurate 99.9% of the time when the input contains >= 50,000 templates (read names). For smaller inputs, HighAccuracy is recommended instead.\n", usageShort="Down-sample a SAM or BAM file to retain a random subset of the reads", programGroup=SamOrBam.class)
public class DownsampleSam
extends CommandLineProgram {
    @Option(shortName="I", doc="The input SAM or BAM file to downsample.")
    public File INPUT;
    @Option(shortName="O", doc="The output, downsampled, SAM or BAM file to write.")
    public File OUTPUT;
    @Option(shortName="S", doc="The downsampling strategy to use. See usage for discussion.")
    public DownsamplingIteratorFactory.Strategy STRATEGY = DownsamplingIteratorFactory.Strategy.ConstantMemory;
    @Option(shortName="R", doc="Random seed to use if reproducibilty is desired.  Setting to null will cause multiple invocations to produce different results.")
    public Integer RANDOM_SEED = 1;
    @Option(shortName="P", doc="The probability of keeping any individual read, between 0 and 1.")
    public double PROBABILITY = 1.0;
    @Option(shortName="A", doc="The accuracy that the downsampler should try to achieve if the selected strategy supports it. Note that accuracy is never guaranteed, but some strategies will attempt to provide accuracy within the requested bounds.Higher accuracy will generally require more memory.")
    public double ACCURACY = 1.0E-4;
    private final Log log = Log.getInstance(DownsampleSam.class);

    public static void main(String[] stringArray) {
        new DownsampleSam().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        Object object;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (this.PROBABILITY == 1.0) {
            this.log.warn(new Object[]{"Running DownsampleSam with PROBABILITY=1! This will likely just recreate the input file."});
        }
        Random random = this.RANDOM_SEED == null ? new Random() : new Random(this.RANDOM_SEED.intValue());
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(samReader.getFileHeader(), true, this.OUTPUT);
        ProgressLogger progressLogger = new ProgressLogger(this.log, 10000000, "Wrote");
        DownsamplingIterator downsamplingIterator = DownsamplingIteratorFactory.make((File)this.INPUT, (DownsamplingIteratorFactory.Strategy)this.STRATEGY, (double)this.PROBABILITY, (double)this.ACCURACY, (int)this.RANDOM_SEED);
        while (downsamplingIterator.hasNext()) {
            object = (SAMRecord)downsamplingIterator.next();
            sAMFileWriter.addAlignment((SAMRecord)object);
            progressLogger.record((SAMRecord)object);
        }
        sAMFileWriter.close();
        CloserUtil.close((Object)samReader);
        object = new DecimalFormat("0.00%");
        this.log.info(new Object[]{"Finished downsampling."});
        this.log.info(new Object[]{"Kept ", downsamplingIterator.getAcceptedCount(), " out of ", downsamplingIterator.getSeenCount(), " reads (", ((NumberFormat)object).format(downsamplingIterator.getAcceptedFraction()), ")."});
        return 0;
    }
}

