/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CoordMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import picard.sam.HitsForInsert;
import picard.sam.PrimaryAlignmentSelectionStrategy;

public class EarliestFragmentPrimaryAlignmentSelectionStrategy
implements PrimaryAlignmentSelectionStrategy {
    private final Random random = new Random(1L);

    @Override
    public void pickPrimaryAlignment(HitsForInsert hitsForInsert) {
        if (hitsForInsert.numHits() == 0) {
            throw new IllegalArgumentException("No alignments to pick from");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        for (int i = 0; i < hitsForInsert.numHits(); ++i) {
            SAMRecord sAMRecord = hitsForInsert.getFragment(i);
            if (sAMRecord.getReadUnmappedFlag()) continue;
            int n3 = this.getIndexOfFirstAlignedBase(sAMRecord);
            int n4 = sAMRecord.getMappingQuality();
            if (n3 < n || n3 == n && n4 > n2) {
                arrayList.clear();
                arrayList.add(i);
                n = n3;
                n2 = n4;
                continue;
            }
            if (n3 != n || n4 != n2) continue;
            arrayList.add(i);
        }
        if (arrayList.size() == 1) {
            hitsForInsert.setPrimaryAlignment((Integer)arrayList.get(0));
        } else {
            hitsForInsert.setPrimaryAlignment((Integer)arrayList.get(this.random.nextInt(arrayList.size())));
        }
    }

    int getIndexOfFirstAlignedBase(SAMRecord sAMRecord) {
        List list = sAMRecord.getAlignmentBlocks();
        if (sAMRecord.getReadNegativeStrandFlag()) {
            AlignmentBlock alignmentBlock = (AlignmentBlock)list.get(list.size() - 1);
            return sAMRecord.getReadLength() - CoordMath.getEnd((int)alignmentBlock.getReadStart(), (int)alignmentBlock.getLength()) + 1;
        }
        return ((AlignmentBlock)list.get(0)).getReadStart();
    }
}

