/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class HitsForInsert {
    private static final HitIndexComparator comparator = new HitIndexComparator();
    final List<SAMRecord> firstOfPairOrFragment = new ArrayList<SAMRecord>();
    final List<SAMRecord> secondOfPair = new ArrayList<SAMRecord>();
    private final List<SAMRecord> supplementalFirstOfPairOrFragment = new ArrayList<SAMRecord>();
    private final List<SAMRecord> supplementalSecondOfPair = new ArrayList<SAMRecord>();

    HitsForInsert() {
    }

    public String getReadName() {
        return this.getRepresentativeRead().getReadName();
    }

    public boolean isPaired() {
        return this.getRepresentativeRead().getReadPairedFlag();
    }

    public SAMRecord getRepresentativeRead() {
        for (SAMRecord sAMRecord : this.firstOfPairOrFragment) {
            if (sAMRecord == null) continue;
            return sAMRecord;
        }
        for (SAMRecord sAMRecord : this.secondOfPair) {
            if (sAMRecord == null) continue;
            return sAMRecord;
        }
        throw new IllegalStateException("Should not be called if numHits == 0");
    }

    public int numHits() {
        return Math.max(this.firstOfPairOrFragment.size(), this.secondOfPair.size());
    }

    public boolean hasSupplementalHits() {
        return !this.supplementalFirstOfPairOrFragment.isEmpty() || !this.supplementalSecondOfPair.isEmpty();
    }

    public SAMRecord getFirstOfPair(int n) {
        if (n >= this.firstOfPairOrFragment.size()) {
            return null;
        }
        return this.firstOfPairOrFragment.get(n);
    }

    public void addFirstOfPairOrFragment(SAMRecord sAMRecord) {
        this.firstOfPairOrFragment.add(sAMRecord);
    }

    public void addSecondOfPair(SAMRecord sAMRecord) {
        this.secondOfPair.add(sAMRecord);
    }

    public void addSupplementalFirstOfPairOrFragment(SAMRecord sAMRecord) {
        this.supplementalFirstOfPairOrFragment.add(sAMRecord);
    }

    public void addSupplementalSecondOfPair(SAMRecord sAMRecord) {
        this.supplementalSecondOfPair.add(sAMRecord);
    }

    public SAMRecord getFragment(int n) {
        SAMRecord sAMRecord = this.firstOfPairOrFragment.get(n);
        if (sAMRecord.getReadPairedFlag()) {
            throw new UnsupportedOperationException("getFragment called for paired read");
        }
        return sAMRecord;
    }

    public SAMRecord getSecondOfPair(int n) {
        if (n >= this.secondOfPair.size()) {
            return null;
        }
        return this.secondOfPair.get(n);
    }

    public int getIndexOfEarliestPrimary() {
        for (int i = 0; i < this.numHits(); ++i) {
            boolean bl;
            SAMRecord sAMRecord = this.getFirstOfPair(i);
            SAMRecord sAMRecord2 = this.getSecondOfPair(i);
            boolean bl2 = bl = sAMRecord != null && !sAMRecord.isSecondaryOrSupplementary() || sAMRecord2 != null && !sAMRecord2.isSecondaryOrSupplementary();
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    public void setPrimaryAlignment(int n) {
        if (n < 0 || n >= this.numHits()) {
            throw new IllegalArgumentException("primaryAlignmentIndex(" + n + ") out of range for numHits(" + this.numHits() + ")");
        }
        for (int i = 0; i < this.numHits(); ++i) {
            boolean bl;
            boolean bl2 = bl = i != n;
            if (this.getFirstOfPair(i) != null) {
                this.getFirstOfPair(i).setNotPrimaryAlignmentFlag(bl);
            }
            if (this.getSecondOfPair(i) == null) continue;
            this.getSecondOfPair(i).setNotPrimaryAlignmentFlag(bl);
        }
    }

    public void coordinateByHitIndex() {
        Object object;
        int n;
        Collections.sort(this.firstOfPairOrFragment, comparator);
        Collections.sort(this.secondOfPair, comparator);
        for (n = 0; n < Math.min(this.firstOfPairOrFragment.size(), this.secondOfPair.size()); ++n) {
            Integer n2 = this.firstOfPairOrFragment.get(n).getIntegerAttribute(SAMTag.HI.name());
            object = this.secondOfPair.get(n).getIntegerAttribute(SAMTag.HI.name());
            if (n2 != null) {
                if (object == null) continue;
                if (n2 < (Integer)object) {
                    this.secondOfPair.add(n, null);
                    continue;
                }
                if ((Integer)object >= n2) continue;
                this.firstOfPairOrFragment.add(n, null);
                continue;
            }
            if (object != null) {
                this.firstOfPairOrFragment.add(n, null);
                continue;
            }
            this.secondOfPair.add(n, null);
        }
        n = 0;
        for (int i = 0; i < this.numHits(); ++i) {
            object = this.getFirstOfPair(i);
            SAMRecord sAMRecord = this.getSecondOfPair(i);
            if (object != null && sAMRecord != null) {
                object.setAttribute(SAMTag.HI.name(), (Object)i);
                sAMRecord.setAttribute(SAMTag.HI.name(), (Object)i);
                ++n;
                continue;
            }
            if (object != null) {
                object.setAttribute(SAMTag.HI.name(), null);
                continue;
            }
            sAMRecord.setAttribute(SAMTag.HI.name(), null);
        }
    }

    private NumPrimaryAlignmentState tallyPrimaryAlignments(List<SAMRecord> list) {
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null || list.get(i).isSecondaryOrSupplementary()) continue;
            if (bl) {
                return NumPrimaryAlignmentState.MORE_THAN_ONE;
            }
            bl = true;
        }
        if (bl) {
            return NumPrimaryAlignmentState.ONE;
        }
        return NumPrimaryAlignmentState.NONE;
    }

    public NumPrimaryAlignmentState tallyPrimaryAlignments(boolean bl) {
        if (bl) {
            return this.tallyPrimaryAlignments(this.firstOfPairOrFragment);
        }
        return this.tallyPrimaryAlignments(this.secondOfPair);
    }

    List<SAMRecord> getSupplementalFirstOfPairOrFragment() {
        return this.supplementalFirstOfPairOrFragment;
    }

    List<SAMRecord> getSupplementalSecondOfPair() {
        return this.supplementalSecondOfPair;
    }

    private static class HitIndexComparator
    implements Comparator<SAMRecord> {
        private HitIndexComparator() {
        }

        @Override
        public int compare(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
            Integer n = sAMRecord.getIntegerAttribute(SAMTag.HI.name());
            Integer n2 = sAMRecord2.getIntegerAttribute(SAMTag.HI.name());
            if (n == null) {
                if (n2 == null) {
                    return 0;
                }
                return 1;
            }
            if (n2 == null) {
                return -1;
            }
            return n.compareTo(n2);
        }
    }

    public static enum NumPrimaryAlignmentState {
        NONE,
        ONE,
        MORE_THAN_ONE;

    }
}

