/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.CoordMath;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import picard.sam.HitsForInsert;
import picard.sam.PrimaryAlignmentSelectionStrategy;

public class MostDistantPrimaryAlignmentSelectionStrategy
implements PrimaryAlignmentSelectionStrategy {
    private final Random random = new Random(1L);

    @Override
    public void pickPrimaryAlignment(HitsForInsert hitsForInsert) {
        Object object;
        Object object2;
        Object object32;
        BestEndAlignmentsAccumulator bestEndAlignmentsAccumulator = new BestEndAlignmentsAccumulator();
        BestEndAlignmentsAccumulator bestEndAlignmentsAccumulator2 = new BestEndAlignmentsAccumulator();
        CollectionUtil.MultiMap multiMap = new CollectionUtil.MultiMap();
        BestPairAlignmentsAccumulator bestPairAlignmentsAccumulator = new BestPairAlignmentsAccumulator();
        for (Object object32 : hitsForInsert.firstOfPairOrFragment) {
            if (object32.getReadUnmappedFlag()) {
                throw new IllegalStateException();
            }
            bestEndAlignmentsAccumulator.considerBest((SAMRecord)object32);
            multiMap.append((Object)object32.getReferenceIndex(), object32);
        }
        for (Object object32 : hitsForInsert.secondOfPair) {
            if (object32.getReadUnmappedFlag()) {
                throw new IllegalStateException();
            }
            bestEndAlignmentsAccumulator2.considerBest((SAMRecord)object32);
            object2 = (Collection)multiMap.get((Object)object32.getReferenceIndex());
            if (object2 == null) continue;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                SAMRecord sAMRecord = (SAMRecord)iterator.next();
                bestPairAlignmentsAccumulator.considerBest(sAMRecord, (SAMRecord)object32);
            }
        }
        if (bestPairAlignmentsAccumulator.hasBest()) {
            object2 = this.pickRandomlyFromList(bestPairAlignmentsAccumulator.bestAlignmentPairs);
            object = object2.getKey();
            object32 = object2.getValue();
        } else {
            object = bestEndAlignmentsAccumulator.hasBest() ? this.pickRandomlyFromList(bestEndAlignmentsAccumulator.bestAlignments) : null;
            object32 = bestEndAlignmentsAccumulator2.hasBest() ? this.pickRandomlyFromList(bestEndAlignmentsAccumulator2.bestAlignments) : null;
        }
        if (hitsForInsert.firstOfPairOrFragment.isEmpty() != (object == null)) {
            throw new IllegalStateException("Should not happen");
        }
        if (hitsForInsert.secondOfPair.isEmpty() != (object32 == null)) {
            throw new IllegalStateException("Should not happen");
        }
        if (object != null) {
            this.moveToHead(hitsForInsert.firstOfPairOrFragment, (SAMRecord)object);
        }
        if (object32 != null) {
            this.moveToHead(hitsForInsert.secondOfPair, (SAMRecord)object32);
        }
        hitsForInsert.setPrimaryAlignment(0);
        if (hitsForInsert.firstOfPairOrFragment.size() <= 1 || hitsForInsert.secondOfPair.size() <= 1) {
            return;
        }
        int n = hitsForInsert.firstOfPairOrFragment.size() - 1;
        for (int i = 0; i < n; ++i) {
            hitsForInsert.secondOfPair.add(1, null);
        }
    }

    private <T> T pickRandomlyFromList(List<T> list) {
        return list.get(this.random.nextInt(list.size()));
    }

    private void moveToHead(List<SAMRecord> list, SAMRecord sAMRecord) {
        if (list.get(0) == sAMRecord) {
            return;
        }
        for (int i = 1; i < list.size(); ++i) {
            if (list.get(i) != sAMRecord) continue;
            list.remove(i);
            list.add(0, sAMRecord);
            return;
        }
        throw new IllegalStateException("Should not be reached");
    }

    private static class BestPairAlignmentsAccumulator {
        public int bestDistance = -1;
        public int bestPairMapq = -1;
        public List<Map.Entry<SAMRecord, SAMRecord>> bestAlignmentPairs = new ArrayList<Map.Entry<SAMRecord, SAMRecord>>();

        private BestPairAlignmentsAccumulator() {
        }

        public void considerBest(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
            int n = SAMUtils.combineMapqs((int)sAMRecord.getMappingQuality(), (int)sAMRecord2.getMappingQuality());
            int n2 = CoordMath.getLength((int)Math.min(sAMRecord.getAlignmentStart(), sAMRecord2.getAlignmentStart()), (int)Math.max(sAMRecord.getAlignmentEnd(), sAMRecord2.getAlignmentEnd()));
            if (n2 > this.bestDistance || n2 == this.bestDistance && n > this.bestPairMapq) {
                this.bestDistance = n2;
                this.bestPairMapq = n;
                this.bestAlignmentPairs.clear();
                this.bestAlignmentPairs.add(new AbstractMap.SimpleEntry<SAMRecord, SAMRecord>(sAMRecord, sAMRecord2));
            } else if (n2 == this.bestDistance && n == this.bestPairMapq) {
                this.bestAlignmentPairs.add(new AbstractMap.SimpleEntry<SAMRecord, SAMRecord>(sAMRecord, sAMRecord2));
            }
        }

        public boolean hasBest() {
            return this.bestDistance != -1;
        }
    }

    private static class BestEndAlignmentsAccumulator {
        public int bestMapq = -1;
        public List<SAMRecord> bestAlignments = new ArrayList<SAMRecord>();

        private BestEndAlignmentsAccumulator() {
        }

        public void considerBest(SAMRecord sAMRecord) {
            if (this.bestMapq == -1) {
                this.bestMapq = sAMRecord.getMappingQuality();
                this.bestAlignments.add(sAMRecord);
            } else {
                int n = SAMUtils.compareMapqs((int)this.bestMapq, (int)sAMRecord.getMappingQuality());
                if (n < 0) {
                    this.bestMapq = sAMRecord.getMappingQuality();
                    this.bestAlignments.clear();
                    this.bestAlignments.add(sAMRecord);
                } else if (n == 0) {
                    this.bestAlignments.add(sAMRecord);
                }
            }
        }

        public boolean hasBest() {
            return this.bestMapq != -1;
        }
    }
}

