/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.filter.FilteringIterator;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.PeekableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import picard.PicardException;
import picard.sam.HitsForInsert;
import picard.sam.PrimaryAlignmentSelectionStrategy;

class MultiHitAlignedReadIterator
implements CloseableIterator<HitsForInsert> {
    private final PeekableIterator<SAMRecord> peekIterator;
    private final SAMRecordQueryNameComparator queryNameComparator = new SAMRecordQueryNameComparator();
    private final PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy;
    private HitsForInsert theNext = null;

    MultiHitAlignedReadIterator(CloseableIterator<SAMRecord> closeableIterator, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy) {
        this.primaryAlignmentSelectionStrategy = primaryAlignmentSelectionStrategy;
        this.peekIterator = new PeekableIterator((Iterator)new FilteringIterator(closeableIterator, new SamRecordFilter(){

            public boolean filterOut(SAMRecord sAMRecord) {
                return sAMRecord.getReadUnmappedFlag() || SAMUtils.cigarMapsNoBasesToRef((Cigar)sAMRecord.getCigar());
            }

            public boolean filterOut(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
                return !(!sAMRecord.getReadUnmappedFlag() && !SAMUtils.cigarMapsNoBasesToRef((Cigar)sAMRecord.getCigar()) || !sAMRecord2.getReadUnmappedFlag() && !SAMUtils.cigarMapsNoBasesToRef((Cigar)sAMRecord2.getCigar()));
            }
        }));
        this.advance();
    }

    public void close() {
        this.peekIterator.close();
    }

    public boolean hasNext() {
        return this.theNext != null;
    }

    public HitsForInsert next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        HitsForInsert hitsForInsert = this.theNext;
        this.advance();
        return hitsForInsert;
    }

    private void advance() {
        while (this.peekIterator.hasNext()) {
            this.theNext = this.nextMaybeEmpty();
            if (this.theNext.numHits() <= 0) continue;
            return;
        }
        this.theNext = null;
    }

    private HitsForInsert nextMaybeEmpty() {
        if (!this.peekIterator.hasNext()) {
            throw new IllegalStateException();
        }
        String string = ((SAMRecord)this.peekIterator.peek()).getReadName();
        HitsForInsert hitsForInsert = new HitsForInsert();
        Boolean bl = null;
        do {
            SAMRecord sAMRecord = (SAMRecord)this.peekIterator.next();
            this.replaceHardWithSoftClips(sAMRecord);
            if (this.peekIterator.hasNext() && this.queryNameComparator.fileOrderCompare(sAMRecord, (SAMRecord)this.peekIterator.peek()) > 0) {
                throw new IllegalStateException("Underlying iterator is not queryname sorted: " + sAMRecord + " > " + this.peekIterator.peek());
            }
            if (bl == null) {
                bl = sAMRecord.getReadPairedFlag();
            } else if (bl.booleanValue() != sAMRecord.getReadPairedFlag()) {
                throw new PicardException("Got a mix of paired and unpaired alignments for read " + string);
            }
            if (!sAMRecord.getReadPairedFlag() || sAMRecord.getFirstOfPairFlag()) {
                if (sAMRecord.getSupplementaryAlignmentFlag()) {
                    hitsForInsert.addSupplementalFirstOfPairOrFragment(sAMRecord);
                    continue;
                }
                hitsForInsert.addFirstOfPairOrFragment(sAMRecord);
                continue;
            }
            if (sAMRecord.getSecondOfPairFlag()) {
                if (sAMRecord.getSupplementaryAlignmentFlag()) {
                    hitsForInsert.addSupplementalSecondOfPair(sAMRecord);
                    continue;
                }
                hitsForInsert.addSecondOfPair(sAMRecord);
                continue;
            }
            throw new PicardException("Read is marked as pair but neither first or second: " + string);
        } while (this.peekIterator.hasNext() && ((SAMRecord)this.peekIterator.peek()).getReadName().equals(string));
        if (hitsForInsert.numHits() <= 1) {
            if (hitsForInsert.getFirstOfPair(0) != null) {
                hitsForInsert.getFirstOfPair(0).setAttribute(SAMTag.HI.name(), null);
                hitsForInsert.getFirstOfPair(0).setNotPrimaryAlignmentFlag(false);
            }
            if (hitsForInsert.getSecondOfPair(0) != null) {
                hitsForInsert.getSecondOfPair(0).setAttribute(SAMTag.HI.name(), null);
                hitsForInsert.getSecondOfPair(0).setNotPrimaryAlignmentFlag(false);
            }
        } else {
            this.primaryAlignmentSelectionStrategy.pickPrimaryAlignment(hitsForInsert);
        }
        return hitsForInsert;
    }

    private void replaceHardWithSoftClips(SAMRecord sAMRecord) {
        int n;
        if (sAMRecord.getReadUnmappedFlag()) {
            return;
        }
        if (sAMRecord.getCigar().isEmpty()) {
            return;
        }
        ArrayList<CigarElement> arrayList = sAMRecord.getCigar().getCigarElements();
        CigarElement cigarElement = (CigarElement)arrayList.get(0);
        CigarElement cigarElement2 = arrayList.size() == 1 ? null : (CigarElement)arrayList.get(arrayList.size() - 1);
        int n2 = cigarElement.getOperator() == CigarOperator.H ? cigarElement.getLength() : 0;
        int n3 = n = cigarElement2 != null && cigarElement2.getOperator() == CigarOperator.H ? cigarElement2.getLength() : 0;
        if (n2 + n > 0) {
            int n4 = sAMRecord.getReadBases().length + n2 + n;
            byte[] byArray = new byte[n4];
            Arrays.fill(byArray, (byte)78);
            System.arraycopy(sAMRecord.getReadBases(), 0, byArray, n2, sAMRecord.getReadBases().length);
            byte[] byArray2 = new byte[n4];
            Arrays.fill(byArray2, (byte)2);
            System.arraycopy(sAMRecord.getBaseQualities(), 0, byArray2, n2, sAMRecord.getBaseQualities().length);
            arrayList = new ArrayList<CigarElement>(arrayList);
            if (n2 > 0) {
                arrayList.set(0, new CigarElement(cigarElement.getLength(), CigarOperator.S));
            }
            if (n > 0) {
                arrayList.set(arrayList.size() - 1, new CigarElement(cigarElement2.getLength(), CigarOperator.S));
            }
            sAMRecord.setReadBases(byArray);
            sAMRecord.setBaseQualities(byArray2);
            sAMRecord.setCigar(new Cigar(arrayList));
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

