/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Not to be confused with SortSam which sorts a SAM or BAM file with a valid sequence dictionary, ReorderSam reorders reads in a SAM/BAM file to match the contig ordering in a provided reference file, as determined by exact name matching of contigs.  Reads mapped to contigs absent in the new reference are dropped. Runs substantially faster if the input is an indexed BAM file.", usageShort="Reorders reads in a SAM or BAM file to match ordering in reference", programGroup=SamOrBam.class)
public class ReorderSam
extends CommandLineProgram {
    @Option(shortName="I", doc="Input file (bam or sam) to extract reads from.")
    public File INPUT;
    @Option(shortName="O", doc="Output file (bam or sam) to write extracted reads to.")
    public File OUTPUT;
    @Option(shortName="R", doc="Reference sequence to reorder reads to match.  A sequence dictionary corresponding to the reference fasta is required.  Create one with CreateSequenceDictionary.jar.")
    public File REFERENCE;
    @Option(shortName="S", doc="If true, then allows only a partial overlap of the BAM contigs with the new reference sequence contigs.  By default, this tool requires a corresponding contig in the new reference for each read contig")
    public boolean ALLOW_INCOMPLETE_DICT_CONCORDANCE = false;
    @Option(shortName="U", doc="If true, then permits mapping from a read contig to a new reference contig with the same name but a different length.  Highly dangerous, only use if you know what you are doing.")
    public boolean ALLOW_CONTIG_LENGTH_DISCORDANCE = false;
    private final Log log = Log.getInstance(ReorderSam.class);

    public static void main(String[] stringArray) {
        new ReorderSam().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsReadable((File)this.REFERENCE);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        ReferenceSequenceFile referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)this.REFERENCE);
        SAMSequenceDictionary sAMSequenceDictionary = referenceSequenceFile.getSequenceDictionary();
        if (sAMSequenceDictionary == null) {
            this.log.error(new Object[]{"No reference sequence dictionary found. Aborting.  You can create a sequence dictionary for the reference fasta using CreateSequenceDictionary.jar."});
            CloserUtil.close((Object)samReader);
            return 1;
        }
        this.printDictionary("SAM/BAM file", samReader.getFileHeader().getSequenceDictionary());
        this.printDictionary("Reference", sAMSequenceDictionary);
        Map<Integer, Integer> map = this.buildSequenceDictionaryMap(sAMSequenceDictionary, samReader.getFileHeader().getSequenceDictionary());
        SAMFileHeader sAMFileHeader = samReader.getFileHeader().clone();
        sAMFileHeader.setSequenceDictionary(sAMSequenceDictionary);
        this.log.info(new Object[]{"Writing reads..."});
        if (samReader.hasIndex()) {
            SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader, true, this.OUTPUT);
            for (SAMSequenceRecord sAMSequenceRecord : sAMSequenceDictionary.getSequences()) {
                SAMRecordIterator sAMRecordIterator = samReader.query(sAMSequenceRecord.getSequenceName(), 0, 0, false);
                this.writeReads(sAMFileWriter, sAMRecordIterator, map, sAMSequenceRecord.getSequenceName());
            }
            this.writeReads(sAMFileWriter, samReader.queryUnmapped(), map, "unmapped");
            sAMFileWriter.close();
        } else {
            SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader, false, this.OUTPUT);
            this.writeReads(sAMFileWriter, samReader.iterator(), map, "All reads");
            sAMFileWriter.close();
        }
        CloserUtil.close((Object)samReader);
        return 0;
    }

    private int newOrderIndex(SAMRecord sAMRecord, int n, Map<Integer, Integer> map) {
        if (n == -1) {
            return -1;
        }
        Integer n2 = map.get(n);
        if (n2 == null) {
            throw new PicardException("BUG: no mapping found for read " + sAMRecord.format());
        }
        return n2;
    }

    private void writeReads(SAMFileWriter sAMFileWriter, SAMRecordIterator sAMRecordIterator, Map<Integer, Integer> map, String string) {
        long l = 0L;
        this.log.info(new Object[]{"  Processing " + string});
        while (sAMRecordIterator.hasNext()) {
            ++l;
            SAMRecord sAMRecord = (SAMRecord)sAMRecordIterator.next();
            int n = sAMRecord.getReferenceIndex();
            int n2 = sAMRecord.getMateReferenceIndex();
            int n3 = this.newOrderIndex(sAMRecord, n, map);
            sAMRecord.setHeader(sAMFileWriter.getFileHeader());
            sAMRecord.setReferenceIndex(n3);
            int n4 = this.newOrderIndex(sAMRecord, n2, map);
            if (n2 != -1 && n4 == -1) {
                sAMRecord.setMateAlignmentStart(0);
                sAMRecord.setMateUnmappedFlag(true);
                sAMRecord.setAttribute(SAMTag.MC.name(), null);
            }
            sAMRecord.setMateReferenceIndex(n4);
            sAMFileWriter.addAlignment(sAMRecord);
        }
        sAMRecordIterator.close();
        this.log.info(new Object[]{"Wrote " + l + " reads"});
    }

    private Map<Integer, Integer> buildSequenceDictionaryMap(SAMSequenceDictionary sAMSequenceDictionary, SAMSequenceDictionary sAMSequenceDictionary2) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        this.log.info(new Object[]{"Reordering SAM/BAM file:"});
        for (SAMSequenceRecord sAMSequenceRecord : sAMSequenceDictionary.getSequences()) {
            SAMSequenceRecord sAMSequenceRecord2 = sAMSequenceDictionary2.getSequence(sAMSequenceRecord.getSequenceName());
            if (sAMSequenceRecord2 == null) continue;
            if (sAMSequenceRecord.getSequenceLength() != sAMSequenceRecord2.getSequenceLength()) {
                String string = String.format("Discordant contig lengths: read %s LN=%d, ref %s LN=%d", sAMSequenceRecord2.getSequenceName(), sAMSequenceRecord2.getSequenceLength(), sAMSequenceRecord.getSequenceName(), sAMSequenceRecord.getSequenceLength());
                if (this.ALLOW_CONTIG_LENGTH_DISCORDANCE) {
                    this.log.warn(new Object[]{string});
                } else {
                    throw new PicardException(string);
                }
            }
            this.log.info(new Object[]{String.format("  Reordering read contig %s [index=%d] to => ref contig %s [index=%d]%n", sAMSequenceRecord2.getSequenceName(), sAMSequenceRecord2.getSequenceIndex(), sAMSequenceRecord.getSequenceName(), sAMSequenceRecord.getSequenceIndex())});
            hashMap.put(sAMSequenceRecord2.getSequenceIndex(), sAMSequenceRecord.getSequenceIndex());
        }
        for (SAMSequenceRecord sAMSequenceRecord : sAMSequenceDictionary2.getSequences()) {
            if (hashMap.containsKey(sAMSequenceRecord.getSequenceIndex())) continue;
            if (this.ALLOW_INCOMPLETE_DICT_CONCORDANCE) {
                hashMap.put(sAMSequenceRecord.getSequenceIndex(), -1);
                continue;
            }
            throw new PicardException("New reference sequence does not contain a matching contig for " + sAMSequenceRecord.getSequenceName());
        }
        return hashMap;
    }

    private void printDictionary(String string, SAMSequenceDictionary sAMSequenceDictionary) {
        this.log.info(new Object[]{string});
        for (SAMSequenceRecord sAMSequenceRecord : sAMSequenceDictionary.getSequences()) {
            this.log.info(new Object[]{"  SN=%s LN=%d%n", sAMSequenceRecord.getSequenceName(), sAMSequenceRecord.getSequenceLength()});
        }
    }
}

