/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;
import picard.sam.AbstractAlignmentMerger;

@CommandLineProgramProperties(usage="Reverts the original base qualities and adds the mate cigar tag to read-group BAMs.", usageShort="Reverts the original base qualities and adds the mate cigar tag to read-group BAMs", programGroup=SamOrBam.class)
public class RevertOriginalBaseQualitiesAndAddMateCigar
extends CommandLineProgram {
    @Option(shortName="I", doc="The input SAM/BAM file to revert the state of.")
    public File INPUT;
    @Option(shortName="O", doc="The output SAM/BAM file to create.")
    public File OUTPUT;
    @Option(shortName="SO", doc="The sort order to create the reverted output file with.By default, the sort order will be the same as the input.", optional=true)
    public SAMFileHeader.SortOrder SORT_ORDER = null;
    @Option(shortName="OQ", doc="True to restore original qualities from the OQ field to the QUAL field if available.")
    public boolean RESTORE_ORIGINAL_QUALITIES = true;
    @Option(doc="The maximum number of records to examine to determine if we can exit early and not output, given that there are a no original base qualities (if we are to restore) and mate cigars exist. Set to 0 to never skip the file.")
    public int MAX_RECORDS_TO_EXAMINE = 10000;
    private static final Log log = Log.getInstance(RevertOriginalBaseQualitiesAndAddMateCigar.class);

    public RevertOriginalBaseQualitiesAndAddMateCigar() {
        this.CREATE_INDEX = true;
        this.CREATE_MD5_FILE = true;
    }

    public static void main(String[] stringArray) {
        new RevertOriginalBaseQualitiesAndAddMateCigar().instanceMainWithExit(stringArray);
    }

    @Override
    public int doWork() {
        SAMRecord sAMRecord2;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        boolean bl = false;
        CanSkipSamFile canSkipSamFile = RevertOriginalBaseQualitiesAndAddMateCigar.canSkipSAMFile(this.INPUT, this.MAX_RECORDS_TO_EXAMINE, this.RESTORE_ORIGINAL_QUALITIES, this.REFERENCE_SEQUENCE);
        log.info(new Object[]{canSkipSamFile.getMessage(this.MAX_RECORDS_TO_EXAMINE)});
        if (canSkipSamFile.canSkip()) {
            return 0;
        }
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.EAGERLY_DECODE}).open(this.INPUT);
        SAMFileHeader sAMFileHeader = samReader.getFileHeader();
        SAMFileHeader sAMFileHeader2 = sAMFileHeader.clone();
        if (null == this.SORT_ORDER) {
            this.SORT_ORDER = sAMFileHeader.getSortOrder();
        }
        sAMFileHeader2.setSortOrder(this.SORT_ORDER);
        SAMFileWriterFactory.setDefaultCreateIndexWhileWriting((boolean)this.CREATE_INDEX);
        SAMFileWriterFactory.setDefaultCreateMd5File((boolean)this.CREATE_MD5_FILE);
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader2, false, this.OUTPUT);
        SortingCollection sortingCollection = SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(sAMFileHeader2), (Comparator)new SAMRecordQueryNameComparator(), (int)this.MAX_RECORDS_IN_RAM);
        ProgressLogger progressLogger = new ProgressLogger(log, 1000000, " reverted OQs");
        int n = 0;
        for (SAMRecord sAMRecord2 : samReader) {
            AbstractAlignmentMerger.createNewCigarsIfMapsOffEndOfReference(sAMRecord2);
            if (this.RESTORE_ORIGINAL_QUALITIES && null != sAMRecord2.getOriginalBaseQualities()) {
                sAMRecord2.setBaseQualities(sAMRecord2.getOriginalBaseQualities());
                sAMRecord2.setOriginalBaseQualities(null);
                ++n;
            }
            if (!bl && sAMRecord2.getReadPairedFlag() && !sAMRecord2.getReadUnmappedFlag()) {
                bl = true;
            }
            progressLogger.record(sAMRecord2);
            sortingCollection.add((Object)sAMRecord2);
        }
        CloserUtil.close((Object)samReader);
        log.info(new Object[]{"Reverted the original base qualities for " + n + " records"});
        SAMRecordIterator sAMRecordIterator = new SamPairUtil.SetMateInfoIterator((Iterator)sortingCollection.iterator(), true);
        sAMRecord2 = new ProgressLogger(log, 1000000, " mate cigars added");
        while (sAMRecordIterator.hasNext()) {
            SAMRecord sAMRecord3 = sAMRecordIterator.next();
            sAMFileWriter.addAlignment(sAMRecord3);
            sAMRecord2.record(sAMRecord3);
        }
        sAMRecordIterator.close();
        CloserUtil.close((Object)sAMFileWriter);
        log.info(new Object[]{"Updated " + sAMRecordIterator.getNumMateCigarsAdded() + " records with mate cigar"});
        if (!bl) {
            log.info(new Object[]{"Did not find any paired mapped reads."});
        }
        return 0;
    }

    public static CanSkipSamFile canSkipSAMFile(File file, int n, boolean bl, File file2) {
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(file2).enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.EAGERLY_DECODE}).open(file);
        SAMRecordIterator sAMRecordIterator = samReader.iterator();
        CanSkipSamFile canSkipSamFile = CanSkipSamFile.FOUND_NO_EVIDENCE;
        for (int i = 0; sAMRecordIterator.hasNext() && i < n; ++i) {
            SAMRecord sAMRecord = (SAMRecord)sAMRecordIterator.next();
            if (bl && null != sAMRecord.getOriginalBaseQualities()) {
                canSkipSamFile = CanSkipSamFile.CANNOT_SKIP_FOUND_OQ;
                break;
            }
            if (!sAMRecord.getReadPairedFlag() || sAMRecord.getMateUnmappedFlag()) continue;
            if (null == SAMUtils.getMateCigar((SAMRecord)sAMRecord)) {
                canSkipSamFile = CanSkipSamFile.CANNOT_SKIP_FOUND_NO_MC;
                break;
            }
            canSkipSamFile = CanSkipSamFile.CAN_SKIP;
            break;
        }
        if (!sAMRecordIterator.hasNext() && CanSkipSamFile.FOUND_NO_EVIDENCE == canSkipSamFile) {
            canSkipSamFile = CanSkipSamFile.CAN_SKIP;
        }
        CloserUtil.close((Object)samReader);
        return canSkipSamFile;
    }

    public static enum CanSkipSamFile {
        CAN_SKIP("Can skip the BAM file", true),
        CANNOT_SKIP_FOUND_OQ("Cannot skip the BAM as we found a record with an OQ", false),
        CANNOT_SKIP_FOUND_NO_MC("Cannot skip the BAM as we found a mate with no mate cigar tag", false),
        FOUND_NO_EVIDENCE("Found no evidence of OQ or mate with no mate cigar in the first %d records.  Will continue...", false);

        private final String format;
        private final boolean skip;

        private CanSkipSamFile(String string2, boolean bl) {
            this.format = string2;
            this.skip = bl;
        }

        public String getMessage(int n) {
            return String.format(this.format, n);
        }

        public boolean canSkip() {
            return this.skip;
        }
    }
}

