/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.MergingSamRecordIterator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.filter.OverclippedReadFilter;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.DelegatingIterator;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import picard.sam.AbstractAlignmentMerger;
import picard.sam.HitsForInsert;
import picard.sam.PrimaryAlignmentSelectionStrategy;

public class SamAlignmentMerger
extends AbstractAlignmentMerger {
    private final Log log = Log.getInstance(SamAlignmentMerger.class);
    private final List<File> alignedSamFile;
    private final List<File> read1AlignedSamFile;
    private final List<File> read2AlignedSamFile;
    private final int maxGaps;
    private final int minUnclippedBases;
    private boolean forceSort = false;
    private final OverclippedReadFilter contaminationFilter;

    public SamAlignmentMerger(File file, File file2, File file3, SAMProgramRecord sAMProgramRecord, boolean bl, boolean bl2, boolean bl3, List<File> list, int n, List<String> list2, List<String> list3, Integer n2, Integer n3, List<File> list4, List<File> list5, List<SamPairUtil.PairOrientation> list6, SAMFileHeader.SortOrder sortOrder, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy, boolean bl4, boolean bl5, int n4) {
        super(file, file2, file3, bl, bl2, bl3, sAMProgramRecord, list2, list3, n2, n3, list6, sortOrder, primaryAlignmentSelectionStrategy, bl4, bl5);
        if (!(list != null && list.size() != 0 || list4 != null && list4.size() != 0 && list5 != null && list5.size() != 0)) {
            throw new IllegalArgumentException("Either alignedSamFile or BOTH of read1AlignedSamFile and read2AlignedSamFile must be specified.");
        }
        if (list != null) {
            for (File file4 : list) {
                IOUtil.assertFileIsReadable((File)file4);
            }
        } else {
            for (File file5 : list4) {
                IOUtil.assertFileIsReadable((File)file5);
            }
            for (File file5 : list5) {
                IOUtil.assertFileIsReadable((File)file5);
            }
        }
        this.alignedSamFile = list;
        this.read1AlignedSamFile = list4;
        this.read2AlignedSamFile = list5;
        this.maxGaps = n;
        this.minUnclippedBases = n4;
        this.contaminationFilter = new OverclippedReadFilter(n4, false);
        this.log.info(new Object[]{"Processing SAM file(s): " + list != null ? list : list4 + "," + list5});
    }

    @Override
    public void mergeAlignment(File file) {
        try {
            super.mergeAlignment(file);
        }
        catch (IllegalStateException illegalStateException) {
            this.log.warn(new Object[]{"Exception merging bam alignment - attempting to sort aligned reads and try again: ", illegalStateException.getMessage()});
            this.forceSort = true;
            this.resetRefSeqFileWalker();
            super.mergeAlignment(file);
        }
    }

    @Override
    protected CloseableIterator<SAMRecord> getQuerynameSortedAlignedRecords() {
        SAMFileHeader sAMFileHeader;
        SeparateEndAlignmentIterator separateEndAlignmentIterator;
        SortingCollection sortingCollection;
        if (this.alignedSamFile != null && this.alignedSamFile.size() > 0) {
            sortingCollection = new ArrayList(this.alignedSamFile.size());
            ArrayList<SamReader> arrayList = new ArrayList<SamReader>(this.alignedSamFile.size());
            for (File file : this.alignedSamFile) {
                SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.referenceFasta).open(file);
                sortingCollection.add(samReader.getFileHeader());
                arrayList.add(samReader);
                if (this.getProgramRecord() != null || samReader.getFileHeader().getProgramRecords().size() != 1) continue;
                this.setProgramRecord((SAMProgramRecord)samReader.getFileHeader().getProgramRecords().iterator().next());
            }
            SamFileHeaderMerger samFileHeaderMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.queryname, sortingCollection, false);
            separateEndAlignmentIterator = new MergingSamRecordIterator(samFileHeaderMerger, arrayList, true);
            sAMFileHeader = samFileHeaderMerger.getMergedHeader();
        } else {
            separateEndAlignmentIterator = new SeparateEndAlignmentIterator(this.read1AlignedSamFile, this.read2AlignedSamFile, this.referenceFasta);
            sAMFileHeader = separateEndAlignmentIterator.getHeader();
            if (this.getProgramRecord() == null && sAMFileHeader.getProgramRecords().size() == 1) {
                this.setProgramRecord((SAMProgramRecord)sAMFileHeader.getProgramRecords().iterator().next());
            }
        }
        if (!this.forceSort) {
            return separateEndAlignmentIterator;
        }
        sortingCollection = SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(sAMFileHeader), (Comparator)new SAMRecordQueryNameComparator(), (int)500000);
        int n = 0;
        while (separateEndAlignmentIterator.hasNext()) {
            sortingCollection.add(separateEndAlignmentIterator.next());
            if (++n <= 0 || n % 1000000 != 0) continue;
            this.log.info(new Object[]{"Read " + n + " records from alignment SAM/BAM."});
        }
        this.log.info(new Object[]{"Finished reading " + n + " total records from alignment SAM/BAM."});
        separateEndAlignmentIterator.close();
        return new DelegatingIterator<SAMRecord>((Iterator)sortingCollection.iterator()){

            public void close() {
                super.close();
                sortingCollection.cleanup();
            }
        };
    }

    @Override
    protected boolean ignoreAlignment(SAMRecord sAMRecord) {
        if (this.maxGaps == -1) {
            return false;
        }
        int n = 0;
        for (CigarElement cigarElement : sAMRecord.getCigar().getCigarElements()) {
            if (cigarElement.getOperator() != CigarOperator.I && cigarElement.getOperator() != CigarOperator.D) continue;
            ++n;
        }
        return n > this.maxGaps;
    }

    @Override
    protected boolean isContaminant(HitsForInsert hitsForInsert) {
        boolean bl = false;
        if (hitsForInsert.numHits() > 0) {
            int n = hitsForInsert.getIndexOfEarliestPrimary();
            if (n < 0) {
                throw new IllegalStateException("No primary alignment was found, despite having nonzero hits.");
            }
            SAMRecord sAMRecord = hitsForInsert.getFirstOfPair(n);
            SAMRecord sAMRecord2 = hitsForInsert.getSecondOfPair(n);
            if (sAMRecord != null && sAMRecord2 != null) {
                bl = this.contaminationFilter.filterOut(sAMRecord, sAMRecord2);
            } else if (sAMRecord != null) {
                bl = this.contaminationFilter.filterOut(sAMRecord);
            } else if (sAMRecord2 != null) {
                bl = this.contaminationFilter.filterOut(sAMRecord2);
            } else {
                throw new IllegalStateException("Neither read1 or read2 exist for chosen primary alignment");
            }
        }
        return bl;
    }

    public boolean getForceSort() {
        return this.forceSort;
    }

    private class SeparateEndAlignmentIterator
    implements CloseableIterator<SAMRecord> {
        private final PeekableIterator<SAMRecord> read1Iterator;
        private final PeekableIterator<SAMRecord> read2Iterator;
        private final SAMFileHeader header;

        public SeparateEndAlignmentIterator(List<File> list, List<File> list2, File file) {
            SamReader samReader;
            ArrayList<SAMFileHeader> arrayList = new ArrayList<SAMFileHeader>();
            ArrayList<SamReader> arrayList2 = new ArrayList<SamReader>(list.size());
            ArrayList<SamReader> arrayList3 = new ArrayList<SamReader>(list2.size());
            for (File file2 : list) {
                samReader = SamReaderFactory.makeDefault().referenceSequence(file).open(file2);
                arrayList.add(samReader.getFileHeader());
                arrayList2.add(samReader);
            }
            for (File file2 : list2) {
                samReader = SamReaderFactory.makeDefault().referenceSequence(file).open(file2);
                arrayList.add(samReader.getFileHeader());
                arrayList3.add(samReader);
            }
            SamFileHeaderMerger samFileHeaderMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.coordinate, arrayList, false);
            this.read1Iterator = new PeekableIterator((Iterator)((Object)new SuffixTrimingSamRecordIterator((CloseableIterator)new MergingSamRecordIterator(samFileHeaderMerger, arrayList2, true), "/1")));
            this.read2Iterator = new PeekableIterator((Iterator)((Object)new SuffixTrimingSamRecordIterator((CloseableIterator)new MergingSamRecordIterator(samFileHeaderMerger, arrayList3, true), "/2")));
            this.header = samFileHeaderMerger.getMergedHeader();
        }

        public void close() {
            this.read1Iterator.close();
            this.read2Iterator.close();
        }

        public boolean hasNext() {
            return this.read1Iterator.hasNext() || this.read2Iterator.hasNext();
        }

        public SAMRecord next() {
            if (this.read1Iterator.hasNext()) {
                if (this.read2Iterator.hasNext()) {
                    return ((SAMRecord)this.read1Iterator.peek()).getReadName().compareTo(((SAMRecord)this.read2Iterator.peek()).getReadName()) <= 0 ? this.setPairFlags((SAMRecord)this.read1Iterator.next(), true) : this.setPairFlags((SAMRecord)this.read2Iterator.next(), false);
                }
                return this.setPairFlags((SAMRecord)this.read1Iterator.next(), true);
            }
            return this.setPairFlags((SAMRecord)this.read2Iterator.next(), false);
        }

        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }

        public SAMFileHeader getHeader() {
            return this.header;
        }

        private SAMRecord setPairFlags(SAMRecord sAMRecord, boolean bl) {
            sAMRecord.setReadPairedFlag(true);
            sAMRecord.setFirstOfPairFlag(bl);
            sAMRecord.setSecondOfPairFlag(!bl);
            return sAMRecord;
        }
    }

    private class SuffixTrimingSamRecordIterator
    implements CloseableIterator<SAMRecord> {
        private final CloseableIterator<SAMRecord> underlyingIterator;
        private final String suffixToTrim;

        private SuffixTrimingSamRecordIterator(CloseableIterator<SAMRecord> closeableIterator, String string) {
            this.underlyingIterator = closeableIterator;
            this.suffixToTrim = string;
        }

        public void close() {
            this.underlyingIterator.close();
        }

        public boolean hasNext() {
            return this.underlyingIterator.hasNext();
        }

        public SAMRecord next() {
            SAMRecord sAMRecord = (SAMRecord)this.underlyingIterator.next();
            String string = sAMRecord.getReadName();
            if (string.endsWith(this.suffixToTrim)) {
                sAMRecord.setReadName(string.substring(0, string.length() - this.suffixToTrim.length()));
            }
            return sAMRecord;
        }

        public void remove() {
            this.underlyingIterator.remove();
        }
    }
}

