/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.fastq.FastqRecord;
import htsjdk.samtools.fastq.FastqWriter;
import htsjdk.samtools.fastq.FastqWriterFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Lazy;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Extracts read sequences and qualities from the input SAM/BAM file and writes them into the output file in Sanger fastq format. In the RC mode (default is True), if the read is aligned and the alignment is to the reverse strand on the genome, the read's sequence from input SAM file will be reverse-complemented prior to writing it to fastq in order restore correctlythe original read sequence as it was generated by the sequencer.", usageShort="Converts a SAM/BAM into a FASTQ", programGroup=SamOrBam.class)
public class SamToFastq
extends CommandLineProgram {
    @Option(doc="Input SAM/BAM file to extract reads from", shortName="I")
    public File INPUT;
    @Option(shortName="F", doc="Output fastq file (single-end fastq or, if paired, first end of the pair fastq).", mutex={"OUTPUT_PER_RG"})
    public File FASTQ;
    @Option(shortName="F2", doc="Output fastq file (if paired, second end of the pair fastq).", optional=true, mutex={"OUTPUT_PER_RG"})
    public File SECOND_END_FASTQ;
    @Option(shortName="FU", doc="Output fastq file for unpaired reads; may only be provided in paired-fastq mode", optional=true, mutex={"OUTPUT_PER_RG"})
    public File UNPAIRED_FASTQ;
    @Option(shortName="OPRG", doc="Output a fastq file per read group (two fastq files per read group if the group is paired).", optional=true, mutex={"FASTQ", "SECOND_END_FASTQ", "UNPAIRED_FASTQ"})
    public boolean OUTPUT_PER_RG;
    @Option(shortName="RGT", doc="The read group tag (PU or ID) to be used to output a fastq file per read group.")
    public String RG_TAG = "PU";
    @Option(shortName="ODIR", doc="Directory in which to output the fastq file(s).  Used only when OUTPUT_PER_RG is true.", optional=true)
    public File OUTPUT_DIR;
    @Option(shortName="RC", doc="Re-reverse bases and qualities of reads with negative strand flag set before writing them to fastq", optional=true)
    public boolean RE_REVERSE = true;
    @Option(shortName="INTER", doc="Will generate an interleaved fastq if paired, each line will have /1 or /2 to describe which end it came from")
    public boolean INTERLEAVE = false;
    @Option(shortName="NON_PF", doc="Include non-PF reads from the SAM file into the output FASTQ files. PF means 'passes filtering'. Reads whose 'not passing quality controls' flag is set are non-PF reads.")
    public boolean INCLUDE_NON_PF_READS = false;
    @Option(shortName="CLIP_ATTR", doc="The attribute that stores the position at which the SAM record should be clipped", optional=true)
    public String CLIPPING_ATTRIBUTE;
    @Option(shortName="CLIP_ACT", doc="The action that should be taken with clipped reads: 'X' means the reads and qualities should be trimmed at the clipped position; 'N' means the bases should be changed to Ns in the clipped region; and any integer means that the base qualities should be set to that value in the clipped region.", optional=true)
    public String CLIPPING_ACTION;
    @Option(shortName="R1_TRIM", doc="The number of bases to trim from the beginning of read 1.")
    public int READ1_TRIM = 0;
    @Option(shortName="R1_MAX_BASES", doc="The maximum number of bases to write from read 1 after trimming. If there are fewer than this many bases left after trimming, all will be written.  If this value is null then all bases left after trimming will be written.", optional=true)
    public Integer READ1_MAX_BASES_TO_WRITE;
    @Option(shortName="R2_TRIM", doc="The number of bases to trim from the beginning of read 2.")
    public int READ2_TRIM = 0;
    @Option(shortName="R2_MAX_BASES", doc="The maximum number of bases to write from read 2 after trimming. If there are fewer than this many bases left after trimming, all will be written.  If this value is null then all bases left after trimming will be written.", optional=true)
    public Integer READ2_MAX_BASES_TO_WRITE;
    @Option(doc="If true, include non-primary alignments in the output.  Support of non-primary alignments in SamToFastq is not comprehensive, so there may be exceptions if this is set to true and there are paired reads with non-primary alignments.")
    public boolean INCLUDE_NON_PRIMARY_ALIGNMENTS = false;
    private final Log log = Log.getInstance(SamToFastq.class);

    public static void main(String[] stringArray) {
        System.exit(new SamToFastq().instanceMain(stringArray));
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        HashMap<String, SAMRecord> hashMap = new HashMap<String, SAMRecord>();
        FastqWriterFactory fastqWriterFactory = new FastqWriterFactory();
        fastqWriterFactory.setCreateMd5(this.CREATE_MD5_FILE);
        Map<SAMReadGroupRecord, FastqWriters> map = this.generateWriters(samReader.getFileHeader().getReadGroups(), fastqWriterFactory);
        ProgressLogger progressLogger = new ProgressLogger(this.log);
        for (SAMRecord object : samReader) {
            if (object.isSecondaryOrSupplementary() && !this.INCLUDE_NON_PRIMARY_ALIGNMENTS || object.getReadFailsVendorQualityCheckFlag() && !this.INCLUDE_NON_PF_READS) continue;
            FastqWriters fastqWriters = map.get(object.getReadGroup());
            if (object.getReadPairedFlag()) {
                String string = object.getReadName();
                SAMRecord sAMRecord = (SAMRecord)hashMap.remove(string);
                if (sAMRecord == null) {
                    hashMap.put(string, object);
                } else {
                    this.assertPairedMates(sAMRecord, object);
                    SAMRecord sAMRecord2 = object.getFirstOfPairFlag() ? object : sAMRecord;
                    SAMRecord sAMRecord3 = object.getFirstOfPairFlag() ? sAMRecord : object;
                    this.writeRecord(sAMRecord2, 1, fastqWriters.getFirstOfPair(), this.READ1_TRIM, this.READ1_MAX_BASES_TO_WRITE);
                    FastqWriter fastqWriter = fastqWriters.getSecondOfPair();
                    if (fastqWriter == null) {
                        throw new PicardException("Input contains paired reads but no SECOND_END_FASTQ specified.");
                    }
                    this.writeRecord(sAMRecord3, 2, fastqWriter, this.READ2_TRIM, this.READ2_MAX_BASES_TO_WRITE);
                }
            } else {
                this.writeRecord(object, null, fastqWriters.getUnpaired(), this.READ1_TRIM, this.READ1_MAX_BASES_TO_WRITE);
            }
            progressLogger.record(object);
        }
        CloserUtil.close((Object)samReader);
        for (FastqWriters fastqWriters : new HashSet<FastqWriters>(map.values())) {
            fastqWriters.closeAll();
        }
        if (hashMap.size() > 0) {
            SAMUtils.processValidationError((SAMValidationError)new SAMValidationError(SAMValidationError.Type.MATE_NOT_FOUND, "Found " + hashMap.size() + " unpaired mates", null), (ValidationStringency)this.VALIDATION_STRINGENCY);
        }
        return 0;
    }

    private Map<SAMReadGroupRecord, FastqWriters> generateWriters(List<SAMReadGroupRecord> list, final FastqWriterFactory fastqWriterFactory) {
        HashMap<SAMReadGroupRecord, FastqWriters> hashMap = new HashMap<SAMReadGroupRecord, FastqWriters>();
        if (!this.OUTPUT_PER_RG) {
            FastqWriter fastqWriter;
            IOUtil.assertFileIsWritable((File)this.FASTQ);
            FastqWriter fastqWriter2 = fastqWriterFactory.newWriter(this.FASTQ);
            if (this.INTERLEAVE) {
                fastqWriter = fastqWriter2;
            } else if (this.SECOND_END_FASTQ != null) {
                IOUtil.assertFileIsWritable((File)this.SECOND_END_FASTQ);
                fastqWriter = fastqWriterFactory.newWriter(this.SECOND_END_FASTQ);
            } else {
                fastqWriter = null;
            }
            FastqWriter fastqWriter3 = this.UNPAIRED_FASTQ == null ? fastqWriter2 : fastqWriterFactory.newWriter(this.UNPAIRED_FASTQ);
            FastqWriters fastqWriters = new FastqWriters(fastqWriter2, fastqWriter, fastqWriter3);
            hashMap.put(null, fastqWriters);
            for (SAMReadGroupRecord sAMReadGroupRecord : list) {
                hashMap.put(sAMReadGroupRecord, fastqWriters);
            }
        } else {
            for (final SAMReadGroupRecord sAMReadGroupRecord : list) {
                final FastqWriter fastqWriter = fastqWriterFactory.newWriter(this.makeReadGroupFile(sAMReadGroupRecord, "_1"));
                Lazy lazy = new Lazy((Lazy.LazyInitializer)new Lazy.LazyInitializer<FastqWriter>(){

                    public FastqWriter make() {
                        return SamToFastq.this.INTERLEAVE ? fastqWriter : fastqWriterFactory.newWriter(SamToFastq.this.makeReadGroupFile(sAMReadGroupRecord, "_2"));
                    }
                });
                hashMap.put(sAMReadGroupRecord, new FastqWriters(fastqWriter, lazy, fastqWriter));
            }
        }
        return hashMap;
    }

    private File makeReadGroupFile(SAMReadGroupRecord sAMReadGroupRecord, String string) {
        String string2 = null;
        if (this.RG_TAG.equalsIgnoreCase("PU")) {
            string2 = sAMReadGroupRecord.getPlatformUnit();
        } else if (this.RG_TAG.equalsIgnoreCase("ID")) {
            string2 = sAMReadGroupRecord.getReadGroupId();
        }
        if (string2 == null) {
            throw new PicardException("The selected RG_TAG: " + this.RG_TAG + " is not present in the bam header.");
        }
        string2 = IOUtil.makeFileNameSafe((String)string2);
        if (string != null) {
            string2 = string2 + string;
        }
        string2 = string2 + ".fastq";
        File file = this.OUTPUT_DIR != null ? new File(this.OUTPUT_DIR, string2) : new File(string2);
        IOUtil.assertFileIsWritable((File)file);
        return file;
    }

    void writeRecord(SAMRecord sAMRecord, Integer n, FastqWriter fastqWriter, int n2, Integer n3) {
        Integer n4;
        String string = n == null ? sAMRecord.getReadName() : sAMRecord.getReadName() + "/" + n;
        String string2 = sAMRecord.getReadString();
        String string3 = sAMRecord.getBaseQualityString();
        if (this.CLIPPING_ATTRIBUTE != null && (n4 = (Integer)sAMRecord.getAttribute(this.CLIPPING_ATTRIBUTE)) != null) {
            if (this.CLIPPING_ACTION.equalsIgnoreCase("X")) {
                string2 = this.clip(string2, n4, null, !sAMRecord.getReadNegativeStrandFlag());
                string3 = this.clip(string3, n4, null, !sAMRecord.getReadNegativeStrandFlag());
            } else if (this.CLIPPING_ACTION.equalsIgnoreCase("N")) {
                string2 = this.clip(string2, n4, Character.valueOf('N'), !sAMRecord.getReadNegativeStrandFlag());
            } else {
                char c = SAMUtils.phredToFastq((byte[])new byte[]{(byte)Integer.parseInt(this.CLIPPING_ACTION)}).charAt(0);
                string3 = this.clip(string3, n4, Character.valueOf(c), !sAMRecord.getReadNegativeStrandFlag());
            }
        }
        if (this.RE_REVERSE && sAMRecord.getReadNegativeStrandFlag()) {
            string2 = SequenceUtil.reverseComplement((String)string2);
            string3 = StringUtil.reverseString((String)string3);
        }
        if (n2 > 0) {
            string2 = string2.substring(n2);
            string3 = string3.substring(n2);
        }
        if (n3 != null && n3 < string2.length()) {
            string2 = string2.substring(0, n3);
            string3 = string3.substring(0, n3);
        }
        fastqWriter.write(new FastqRecord(string, string2, "", string3));
    }

    private String clip(String string, int n, Character c, boolean bl) {
        String string2;
        block4: {
            int n2 = string.length();
            String string3 = string2 = bl ? string.substring(0, n - 1) : string.substring(n2 - n + 1);
            if (c == null) break block4;
            if (bl) {
                for (int i = n; i <= n2; ++i) {
                    string2 = string2 + c;
                }
            } else {
                for (int i = 0; i <= n2 - n; ++i) {
                    string2 = c + string2;
                }
            }
        }
        return string2;
    }

    private void assertPairedMates(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        if (!(sAMRecord.getFirstOfPairFlag() && sAMRecord2.getSecondOfPairFlag() || sAMRecord2.getFirstOfPairFlag() && sAMRecord.getSecondOfPairFlag())) {
            throw new PicardException("Illegal mate state: " + sAMRecord.getReadName());
        }
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.INTERLEAVE && this.SECOND_END_FASTQ != null) {
            return new String[]{"Cannot set INTERLEAVE to true and pass in a SECOND_END_FASTQ"};
        }
        if (this.UNPAIRED_FASTQ != null && this.SECOND_END_FASTQ == null) {
            return new String[]{"UNPAIRED_FASTQ may only be set when also emitting read1 and read2 fastqs (so SECOND_END_FASTQ must also be set)."};
        }
        if (this.CLIPPING_ATTRIBUTE != null && this.CLIPPING_ACTION == null || this.CLIPPING_ATTRIBUTE == null && this.CLIPPING_ACTION != null) {
            return new String[]{"Both or neither of CLIPPING_ATTRIBUTE and CLIPPING_ACTION should be set."};
        }
        if (this.CLIPPING_ACTION != null && !this.CLIPPING_ACTION.equals("N") && !this.CLIPPING_ACTION.equals("X")) {
            try {
                Integer.parseInt(this.CLIPPING_ACTION);
            }
            catch (NumberFormatException numberFormatException) {
                return new String[]{"CLIPPING ACTION must be one of: N, X, or an integer"};
            }
        }
        if (this.OUTPUT_PER_RG && this.OUTPUT_DIR == null || !this.OUTPUT_PER_RG && this.OUTPUT_DIR != null) {
            return new String[]{"If OUTPUT_PER_RG is true, then OUTPUT_DIR should be set. If "};
        }
        if (this.OUTPUT_PER_RG) {
            if (this.RG_TAG == null) {
                return new String[]{"If OUTPUT_PER_RG is true, then RG_TAG should be set."};
            }
            if (!this.RG_TAG.equalsIgnoreCase("PU") && !this.RG_TAG.equalsIgnoreCase("ID")) {
                return new String[]{"RG_TAG must be: PU or ID"};
            }
        }
        return null;
    }

    static class FastqWriters {
        private final FastqWriter firstOfPair;
        private final FastqWriter unpaired;
        private final Lazy<FastqWriter> secondOfPair;

        private FastqWriters(FastqWriter fastqWriter, Lazy<FastqWriter> lazy, FastqWriter fastqWriter2) {
            this.firstOfPair = fastqWriter;
            this.unpaired = fastqWriter2;
            this.secondOfPair = lazy;
        }

        private FastqWriters(FastqWriter fastqWriter, final FastqWriter fastqWriter2, FastqWriter fastqWriter3) {
            this(fastqWriter, (Lazy<FastqWriter>)new Lazy((Lazy.LazyInitializer)new Lazy.LazyInitializer<FastqWriter>(){

                public FastqWriter make() {
                    return fastqWriter2;
                }
            }), fastqWriter3);
        }

        public FastqWriter getFirstOfPair() {
            return this.firstOfPair;
        }

        public FastqWriter getSecondOfPair() {
            return (FastqWriter)this.secondOfPair.get();
        }

        public FastqWriter getUnpaired() {
            return this.unpaired;
        }

        public void closeAll() {
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.add(this.firstOfPair);
            hashSet.add(this.unpaired);
            if (this.secondOfPair.isInitialized()) {
                hashSet.add(this.secondOfPair.get());
            }
            for (FastqWriter fastqWriter : hashSet) {
                fastqWriter.close();
            }
        }
    }
}

