/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.ProgressLoggerInterface;
import java.io.File;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Sorts the input SAM or BAM.\nInput and output formats are determined by file extension.", usageShort="Sorts a SAM or BAM file", programGroup=SamOrBam.class)
public class SortSam
extends CommandLineProgram {
    @Option(doc="The BAM or SAM file to sort.", shortName="I")
    public File INPUT;
    @Option(doc="The sorted BAM or SAM output file. ", shortName="O")
    public File OUTPUT;
    @Option(shortName="SO", doc="Sort order of output file")
    public SAMFileHeader.SortOrder SORT_ORDER;
    private final Log log = Log.getInstance(SortSam.class);

    public static void main(String[] stringArray) {
        new SortSam().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        samReader.getFileHeader().setSortOrder(this.SORT_ORDER);
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(samReader.getFileHeader(), false, this.OUTPUT);
        sAMFileWriter.setProgressLogger((ProgressLoggerInterface)new ProgressLogger(this.log, 10000000, "Wrote", "records from a sorting collection"));
        ProgressLogger progressLogger = new ProgressLogger(this.log, 10000000, "Read");
        for (SAMRecord sAMRecord : samReader) {
            sAMFileWriter.addAlignment(sAMRecord);
            progressLogger.record(sAMRecord);
        }
        this.log.info(new Object[]{"Finished reading inputs, merging and writing to output now."});
        CloserUtil.close((Object)samReader);
        sAMFileWriter.close();
        return 0;
    }
}

