/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.AsciiWriter;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.SamRecordIntervalIteratorFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Prints a SAM or BAM file to the screen.", usageShort="Prints a SAM or BAM file to the screen", programGroup=SamOrBam.class)
public class ViewSam
extends CommandLineProgram {
    public final String USAGE = this.getStandardUsagePreamble() + "Prints a SAM or BAM file to the screen.";
    @Option(shortName="I", doc="The SAM or BAM file or GA4GH url to view.")
    public String INPUT;
    @Option(doc="Print out all reads, just the aligned reads or just the unaligned reads.")
    public AlignmentStatus ALIGNMENT_STATUS = AlignmentStatus.All;
    @Option(doc="Print out all reads, just the PF reads or just the non-PF reads.")
    public PfStatus PF_STATUS = PfStatus.All;
    @Option(doc="Print the SAM header only.", optional=true)
    public boolean HEADER_ONLY = false;
    @Option(doc="Print the alignment records only.", optional=true)
    public boolean RECORDS_ONLY = false;
    @Option(doc="An intervals file used to restrict what records are output.", optional=true)
    public File INTERVAL_LIST;

    public static void main(String[] stringArray) {
        new ViewSam().instanceMain(stringArray);
    }

    @Override
    protected int doWork() {
        return this.writeSamText(System.out);
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.HEADER_ONLY && this.RECORDS_ONLY) {
            return new String[]{"Cannot specify both HEADER_ONLY=true and RECORDS_ONLY=true."};
        }
        return super.customCommandLineValidation();
    }

    int writeSamText(PrintStream printStream) {
        try {
            Object object;
            SAMRecordIterator sAMRecordIterator;
            SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(SamInputResource.of((String)this.INPUT));
            if (this.HEADER_ONLY || this.INTERVAL_LIST == null) {
                sAMRecordIterator = samReader.iterator();
            } else {
                IOUtil.assertFileIsReadable((File)this.INTERVAL_LIST);
                object = IntervalList.fromFile((File)this.INTERVAL_LIST).uniqued().getIntervals();
                sAMRecordIterator = new SamRecordIntervalIteratorFactory().makeSamRecordIntervalIterator(samReader, (List)object, samReader.hasIndex());
            }
            object = new AsciiWriter((OutputStream)printStream);
            SAMFileHeader sAMFileHeader = samReader.getFileHeader();
            if (!this.RECORDS_ONLY) {
                if (sAMFileHeader.getTextHeader() != null) {
                    object.write(sAMFileHeader.getTextHeader());
                } else {
                    new SAMTextHeaderCodec().encode((Writer)object, sAMFileHeader, true);
                }
            }
            if (!this.HEADER_ONLY) {
                while (sAMRecordIterator.hasNext()) {
                    SAMRecord sAMRecord = (SAMRecord)sAMRecordIterator.next();
                    if (printStream.checkError()) {
                        return 1;
                    }
                    if (this.ALIGNMENT_STATUS == AlignmentStatus.Aligned && sAMRecord.getReadUnmappedFlag() || this.ALIGNMENT_STATUS == AlignmentStatus.Unaligned && !sAMRecord.getReadUnmappedFlag() || this.PF_STATUS == PfStatus.PF && sAMRecord.getReadFailsVendorQualityCheckFlag() || this.PF_STATUS == PfStatus.NonPF && !sAMRecord.getReadFailsVendorQualityCheckFlag()) continue;
                    object.write(sAMRecord.getSAMString());
                }
            }
            object.flush();
            if (printStream.checkError()) {
                return 1;
            }
            CloserUtil.close((Object)object);
            CloserUtil.close((Object)sAMRecordIterator);
            return 0;
        }
        catch (IOException iOException) {
            throw new PicardException("Exception writing SAM text", iOException);
        }
    }

    public static enum PfStatus {
        PF,
        NonPF,
        All;

    }

    public static enum AlignmentStatus {
        Aligned,
        Unaligned,
        All;

    }
}

