/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.samtools.util.StringUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import picard.PicardException;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.sam.DuplicationMetrics;
import picard.sam.markduplicates.util.AbstractOpticalDuplicateFinderCommandLineProgram;
import picard.sam.markduplicates.util.OpticalDuplicateFinder;

@CommandLineProgramProperties(usage="Attempts to estimate library complexity from sequence of read pairs alone. Does so by sorting all reads by the first N bases (5 by default) of each read and then comparing reads with the first N bases identical to each other for duplicates.  Reads are considered to be duplicates if they match each other with no gaps and an overall mismatch rate less than or equal to MAX_DIFF_RATE (0.03 by default).\n\nReads of poor quality are filtered out so as to provide a more accurate estimate. The filtering removes reads with any no-calls in the first N bases or with a mean base quality lower than MIN_MEAN_QUALITY across either the first or second read.\n\nUnpaired reads are ignored in this computation.\n\nThe algorithm attempts to detect optical duplicates separately from PCR duplicates and excludes these in the calculation of library size. Also, since there is no alignment to screen out technical reads one further filter is applied on the data.  After examining all reads a Histogram is built of [#reads in duplicate set -> #of duplicate sets] all bins that contain exactly one duplicate set are then removed from the Histogram as outliers before library size is estimated.", usageShort="Estimates library complexity from the sequence of read pairs", programGroup=Metrics.class)
public class EstimateLibraryComplexity
extends AbstractOpticalDuplicateFinderCommandLineProgram {
    @Option(shortName="I", doc="One or more files to combine and estimate library complexity from. Reads can be mapped or unmapped.")
    public List<File> INPUT;
    @Option(shortName="O", doc="Output file to writes per-library metrics to.")
    public File OUTPUT;
    @Option(doc="The minimum number of bases at the starts of reads that must be identical for reads to be grouped together for duplicate detection.  In effect total_reads / 4^max_id_bases reads will be compared at a time, so lower numbers will produce more accurate results but consume exponentially more memory and CPU.")
    public int MIN_IDENTICAL_BASES = 5;
    @Option(doc="The maximum rate of differences between two reads to call them identical.")
    public double MAX_DIFF_RATE = 0.03;
    @Option(doc="The minimum mean quality of the bases in a read pair for the read to be analyzed. Reads with lower average quality are filtered out and not considered in any calculations.")
    public int MIN_MEAN_QUALITY = 20;
    @Option(doc="Do not process self-similar groups that are this many times over the mean expected group size. I.e. if the input contains 10m read pairs and MIN_IDENTICAL_BASES is set to 5, then the mean expected group size would be approximately 10 reads.")
    public int MAX_GROUP_RATIO = 500;
    @Option(doc="Barcode SAM tag (ex. BC for 10X Genomics)", optional=true)
    public String BARCODE_TAG = null;
    @Option(doc="Read one barcode SAM tag (ex. BX for 10X Genomics)", optional=true)
    public String READ_ONE_BARCODE_TAG = null;
    @Option(doc="Read two barcode SAM tag (ex. BX for 10X Genomics)", optional=true)
    public String READ_TWO_BARCODE_TAG = null;
    private final Log log = Log.getInstance(EstimateLibraryComplexity.class);

    public int getBarcodeValue(SAMRecord sAMRecord) {
        return EstimateLibraryComplexity.getReadBarcodeValue(sAMRecord, this.BARCODE_TAG);
    }

    public static int getReadBarcodeValue(SAMRecord sAMRecord, String string) {
        if (null == string) {
            return 0;
        }
        String string2 = sAMRecord.getStringAttribute(string);
        if (null == string2) {
            return 0;
        }
        return string2.hashCode();
    }

    private int getReadOneBarcodeValue(SAMRecord sAMRecord) {
        return EstimateLibraryComplexity.getReadBarcodeValue(sAMRecord, this.READ_ONE_BARCODE_TAG);
    }

    private int getReadTwoBarcodeValue(SAMRecord sAMRecord) {
        return EstimateLibraryComplexity.getReadBarcodeValue(sAMRecord, this.READ_TWO_BARCODE_TAG);
    }

    public static void main(String[] stringArray) {
        new EstimateLibraryComplexity().instanceMainWithExit(stringArray);
    }

    public EstimateLibraryComplexity() {
        int n = null != this.BARCODE_TAG || null != this.READ_ONE_BARCODE_TAG || null != this.READ_TWO_BARCODE_TAG ? PairedReadSequenceWithBarcodes.getSizeInBytes() : PairedReadSequence.getSizeInBytes();
        this.MAX_RECORDS_IN_RAM = (int)(Runtime.getRuntime().maxMemory() / (long)n) / 2;
    }

    @Override
    protected int doWork() {
        Object object;
        Object object2;
        Object object3;
        HashMap<String, Object> hashMap;
        for (File file : this.INPUT) {
            IOUtil.assertFileIsReadable((File)file);
        }
        this.log.info(new Object[]{"Will store " + this.MAX_RECORDS_IN_RAM + " read pairs in memory before sorting."});
        ArrayList arrayList = new ArrayList();
        boolean bl = null != this.BARCODE_TAG || null != this.READ_ONE_BARCODE_TAG || null != this.READ_TWO_BARCODE_TAG;
        SortingCollection sortingCollection = !bl ? SortingCollection.newInstance(PairedReadSequence.class, (SortingCollection.Codec)new PairedReadCodec(), (Comparator)new PairedReadComparator(), (int)this.MAX_RECORDS_IN_RAM, (Collection)this.TMP_DIR) : SortingCollection.newInstance(PairedReadSequence.class, (SortingCollection.Codec)new PairedReadWithBarcodesCodec(), (Comparator)new PairedReadComparator(), (int)this.MAX_RECORDS_IN_RAM, (Collection)this.TMP_DIR);
        ProgressLogger progressLogger = new ProgressLogger(this.log, 1000000, "Read");
        for (File serializable2 : this.INPUT) {
            hashMap = new HashMap<String, Object>();
            SamReader n = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(serializable2);
            arrayList.addAll(n.getFileHeader().getReadGroups());
            for (SAMRecord sAMRecord : n) {
                Object object4;
                if (!sAMRecord.getReadPairedFlag() || !sAMRecord.getFirstOfPairFlag() && !sAMRecord.getSecondOfPairFlag()) continue;
                PairedReadSequence n2 = (PairedReadSequence)hashMap.remove(sAMRecord.getReadName());
                if (n2 == null) {
                    SAMReadGroupRecord list;
                    PairedReadSequence pairedReadSequence = n2 = bl ? new PairedReadSequenceWithBarcodes() : new PairedReadSequence();
                    if (this.opticalDuplicateFinder.addLocationInformation(sAMRecord.getReadName(), n2) && (list = sAMRecord.getReadGroup()) != null) {
                        n2.setReadGroup((short)arrayList.indexOf(list));
                    }
                    hashMap.put(sAMRecord.getReadName(), n2);
                }
                boolean sAMReadGroupRecord = this.passesQualityCheck(sAMRecord.getReadBases(), sAMRecord.getBaseQualities(), this.MIN_IDENTICAL_BASES, this.MIN_MEAN_QUALITY);
                n2.qualityOk = n2.qualityOk && sAMReadGroupRecord;
                object3 = sAMRecord.getReadBases();
                if (sAMRecord.getReadNegativeStrandFlag()) {
                    SequenceUtil.reverseComplement((byte[])object3);
                }
                Object object5 = object4 = bl ? (PairedReadSequenceWithBarcodes)n2 : null;
                if (sAMRecord.getFirstOfPairFlag()) {
                    n2.read1 = (byte[])object3;
                    if (bl) {
                        ((PairedReadSequenceWithBarcodes)object4).barcode = this.getBarcodeValue(sAMRecord);
                        ((PairedReadSequenceWithBarcodes)object4).readOneBarcode = this.getReadOneBarcodeValue(sAMRecord);
                    }
                } else {
                    n2.read2 = (byte[])object3;
                    if (bl) {
                        ((PairedReadSequenceWithBarcodes)object4).readTwoBarcode = this.getReadTwoBarcodeValue(sAMRecord);
                    }
                }
                if (n2.read1 != null && n2.read2 != null && n2.qualityOk) {
                    sortingCollection.add((Object)n2);
                }
                progressLogger.record(sAMRecord);
            }
            CloserUtil.close((Object)n);
        }
        this.log.info(new Object[]{"Finished reading - moving on to scanning for duplicates."});
        PeekableIterator peekableIterator = new PeekableIterator((Iterator)sortingCollection.iterator());
        HashMap<Histogram, Histogram> hashMap2 = new HashMap<Histogram, Histogram>();
        hashMap = new HashMap();
        int n = 0;
        long l = System.currentTimeMillis();
        int n2 = Math.max(1, 0 / (int)Math.pow(4.0, this.MIN_IDENTICAL_BASES * 2));
        while (peekableIterator.hasNext()) {
            List<PairedReadSequence> metricsFile = this.getNextGroup((PeekableIterator<PairedReadSequence>)peekableIterator);
            if (metricsFile.size() > n2 * this.MAX_GROUP_RATIO) {
                object3 = metricsFile.get(0);
                this.log.warn(new Object[]{"Omitting group with over " + this.MAX_GROUP_RATIO + " times the expected mean number of read pairs. " + "Mean=" + n2 + ", Actual=" + metricsFile.size() + ". Prefixes: " + StringUtil.bytesToString((byte[])((PairedReadSequence)object3).read1, (int)0, (int)this.MIN_IDENTICAL_BASES) + " / " + StringUtil.bytesToString((byte[])((PairedReadSequence)object3).read1, (int)0, (int)this.MIN_IDENTICAL_BASES)});
                continue;
            }
            object3 = this.splitByLibrary(metricsFile, arrayList);
            for (Map.Entry entry : object3.entrySet()) {
                object2 = (String)entry.getKey();
                object = (List)entry.getValue();
                Histogram histogram = (Histogram)hashMap2.get(object2);
                Object object6 = (Histogram)hashMap.get(object2);
                if (histogram == null) {
                    histogram = new Histogram("duplication_group_count", (String)object2);
                    object6 = new Histogram("duplication_group_count", "optical_duplicates");
                    hashMap2.put((Histogram)object2, histogram);
                    hashMap.put((String)object2, object6);
                }
                for (int i = 0; i < object.size(); ++i) {
                    Object object7;
                    int n3;
                    PairedReadSequence pairedReadSequence = (PairedReadSequence)object.get(i);
                    if (pairedReadSequence == null) continue;
                    ArrayList<PairedReadSequence> arrayList2 = new ArrayList<PairedReadSequence>();
                    for (n3 = i + 1; n3 < object.size(); ++n3) {
                        object7 = (PairedReadSequence)object.get(n3);
                        if (object7 == null || !this.matches(pairedReadSequence, (PairedReadSequence)object7, this.MAX_DIFF_RATE, bl)) continue;
                        arrayList2.add((PairedReadSequence)object7);
                        object.set(n3, null);
                    }
                    if (arrayList2.size() > 0) {
                        arrayList2.add(pairedReadSequence);
                        n3 = arrayList2.size();
                        histogram.increment((Comparable)Integer.valueOf(n3));
                        for (Object object8 : object7 = (Object)this.opticalDuplicateFinder.findOpticalDuplicates(arrayList2)) {
                            if (object8 == false) continue;
                            object6.increment((Comparable)Integer.valueOf(n3));
                        }
                        continue;
                    }
                    histogram.increment((Comparable)Integer.valueOf(1));
                }
            }
            ++n;
            if (l >= System.currentTimeMillis() - 60000L) continue;
            this.log.info(new Object[]{"Processed " + n + " groups."});
            l = System.currentTimeMillis();
        }
        peekableIterator.close();
        sortingCollection.cleanup();
        MetricsFile metricsFile = this.getMetricsFile();
        for (Object object4 : hashMap2.keySet()) {
            Histogram histogram = (Histogram)hashMap2.get(object4);
            object2 = (Histogram)hashMap.get(object4);
            object = new DuplicationMetrics();
            ((DuplicationMetrics)((Object)object)).LIBRARY = object4;
            for (Object object6 : histogram.keySet()) {
                double d;
                double d2 = ((Histogram.Bin)histogram.get(object6)).getValue();
                double d3 = d = object2.get(object6) == null ? 0.0 : ((Histogram.Bin)object2.get(object6)).getValue();
                if (!(d2 > 1.0)) continue;
                ((DuplicationMetrics)((Object)object)).READ_PAIRS_EXAMINED = (long)((double)((DuplicationMetrics)((Object)object)).READ_PAIRS_EXAMINED + (double)((Integer)object6).intValue() * d2);
                ((DuplicationMetrics)((Object)object)).READ_PAIR_DUPLICATES = (long)((double)((DuplicationMetrics)((Object)object)).READ_PAIR_DUPLICATES + (double)((Integer)object6 - 1) * d2);
                ((DuplicationMetrics)((Object)object)).READ_PAIR_OPTICAL_DUPLICATES = (long)((double)((DuplicationMetrics)((Object)object)).READ_PAIR_OPTICAL_DUPLICATES + d);
            }
            ((DuplicationMetrics)((Object)object)).calculateDerivedMetrics();
            metricsFile.addMetric((MetricBase)object);
            metricsFile.addHistogram(histogram);
        }
        metricsFile.write(this.OUTPUT);
        return 0;
    }

    private boolean matches(PairedReadSequence pairedReadSequence, PairedReadSequence pairedReadSequence2, double d, boolean bl) {
        int n;
        int n2 = Math.min(pairedReadSequence.read1.length, pairedReadSequence2.read1.length);
        int n3 = Math.min(pairedReadSequence.read2.length, pairedReadSequence2.read2.length);
        int n4 = (int)Math.floor((double)(n2 + n3) * d);
        int n5 = 0;
        if (bl) {
            PairedReadSequenceWithBarcodes pairedReadSequenceWithBarcodes = (PairedReadSequenceWithBarcodes)pairedReadSequence;
            PairedReadSequenceWithBarcodes pairedReadSequenceWithBarcodes2 = (PairedReadSequenceWithBarcodes)pairedReadSequence2;
            if (pairedReadSequenceWithBarcodes.barcode != pairedReadSequenceWithBarcodes2.barcode || pairedReadSequenceWithBarcodes.readOneBarcode != pairedReadSequenceWithBarcodes2.readOneBarcode || pairedReadSequenceWithBarcodes.readTwoBarcode != pairedReadSequenceWithBarcodes2.readTwoBarcode) {
                return false;
            }
        }
        for (n = this.MIN_IDENTICAL_BASES; n < n2; ++n) {
            if (pairedReadSequence.read1[n] == pairedReadSequence2.read1[n] || ++n5 <= n4) continue;
            return false;
        }
        for (n = this.MIN_IDENTICAL_BASES; n < n3; ++n) {
            if (pairedReadSequence.read2[n] == pairedReadSequence2.read2[n] || ++n5 <= n4) continue;
            return false;
        }
        return true;
    }

    List<PairedReadSequence> getNextGroup(PeekableIterator<PairedReadSequence> peekableIterator) {
        ArrayList<PairedReadSequence> arrayList = new ArrayList<PairedReadSequence>();
        PairedReadSequence pairedReadSequence = (PairedReadSequence)peekableIterator.next();
        arrayList.add(pairedReadSequence);
        block0: while (peekableIterator.hasNext()) {
            PairedReadSequence pairedReadSequence2 = (PairedReadSequence)peekableIterator.peek();
            for (int i = 0; i < this.MIN_IDENTICAL_BASES; ++i) {
                if (pairedReadSequence.read1[i] != pairedReadSequence2.read1[i] || pairedReadSequence.read2[i] != pairedReadSequence2.read2[i]) break block0;
            }
            arrayList.add((PairedReadSequence)peekableIterator.next());
        }
        return arrayList;
    }

    Map<String, List<PairedReadSequence>> splitByLibrary(List<PairedReadSequence> list, List<SAMReadGroupRecord> list2) {
        HashMap<String, List<PairedReadSequence>> hashMap = new HashMap<String, List<PairedReadSequence>>();
        for (PairedReadSequence pairedReadSequence : list) {
            ArrayList<PairedReadSequence> arrayList;
            String string = null;
            if (pairedReadSequence.getReadGroup() != -1) {
                string = list2.get(pairedReadSequence.getReadGroup()).getLibrary();
                if (string == null) {
                    string = "Unknown";
                }
            } else {
                string = "Unknown";
            }
            if ((arrayList = (ArrayList<PairedReadSequence>)hashMap.get(string)) == null) {
                arrayList = new ArrayList<PairedReadSequence>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(pairedReadSequence);
        }
        return hashMap;
    }

    boolean passesQualityCheck(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3;
        if (byArray.length < n) {
            return false;
        }
        for (n3 = 0; n3 < n; ++n3) {
            if (!SequenceUtil.isNoCall((byte)byArray[n3])) continue;
            return false;
        }
        n3 = 0;
        for (byte by : byArray2) {
            n3 += by;
        }
        return n3 / byArray2.length >= n2;
    }

    class PairedReadComparator
    implements Comparator<PairedReadSequence> {
        final int BASES;

        PairedReadComparator() {
            this.BASES = EstimateLibraryComplexity.this.MIN_IDENTICAL_BASES;
        }

        @Override
        public int compare(PairedReadSequence pairedReadSequence, PairedReadSequence pairedReadSequence2) {
            int n;
            int n2;
            for (n2 = 0; n2 < this.BASES; ++n2) {
                n = pairedReadSequence.read1[n2] - pairedReadSequence2.read1[n2];
                if (n == 0) continue;
                return n;
            }
            for (n2 = 0; n2 < this.BASES; ++n2) {
                n = pairedReadSequence.read2[n2] - pairedReadSequence2.read2[n2];
                if (n == 0) continue;
                return n;
            }
            return System.identityHashCode(pairedReadSequence) - System.identityHashCode(pairedReadSequence2);
        }
    }

    static class PairedReadWithBarcodesCodec
    extends PairedReadCodec {
        PairedReadWithBarcodesCodec() {
        }

        @Override
        public void encode(PairedReadSequence pairedReadSequence) {
            if (!(pairedReadSequence instanceof PairedReadSequenceWithBarcodes)) {
                throw new PicardException("Val was not a PairedReadSequenceWithBarcodes");
            }
            PairedReadSequenceWithBarcodes pairedReadSequenceWithBarcodes = (PairedReadSequenceWithBarcodes)pairedReadSequence;
            super.encode(pairedReadSequence);
            try {
                this.out.writeInt(pairedReadSequenceWithBarcodes.barcode);
                this.out.writeInt(pairedReadSequenceWithBarcodes.readOneBarcode);
                this.out.writeInt(pairedReadSequenceWithBarcodes.readTwoBarcode);
            }
            catch (IOException iOException) {
                throw new PicardException("Error write out read pair.", iOException);
            }
        }

        @Override
        public PairedReadSequence decode() {
            try {
                PairedReadSequence pairedReadSequence = super.decode();
                if (null == pairedReadSequence) {
                    return null;
                }
                PairedReadSequenceWithBarcodes pairedReadSequenceWithBarcodes = new PairedReadSequenceWithBarcodes(pairedReadSequence);
                pairedReadSequenceWithBarcodes.barcode = this.in.readInt();
                pairedReadSequenceWithBarcodes.readOneBarcode = this.in.readInt();
                pairedReadSequenceWithBarcodes.readTwoBarcode = this.in.readInt();
                return pairedReadSequenceWithBarcodes;
            }
            catch (IOException iOException) {
                throw new PicardException("Exception reading read pair.", iOException);
            }
        }

        @Override
        public SortingCollection.Codec<PairedReadSequence> clone() {
            return new PairedReadWithBarcodesCodec();
        }
    }

    static class PairedReadCodec
    implements SortingCollection.Codec<PairedReadSequence> {
        protected DataOutputStream out;
        protected DataInputStream in;

        PairedReadCodec() {
        }

        public void setOutputStream(OutputStream outputStream) {
            this.out = new DataOutputStream(outputStream);
        }

        public void setInputStream(InputStream inputStream) {
            this.in = new DataInputStream(inputStream);
        }

        public void encode(PairedReadSequence pairedReadSequence) {
            try {
                this.out.writeShort(pairedReadSequence.readGroup);
                this.out.writeShort(pairedReadSequence.tile);
                this.out.writeShort(pairedReadSequence.x);
                this.out.writeShort(pairedReadSequence.y);
                this.out.writeInt(pairedReadSequence.read1.length);
                this.out.write(pairedReadSequence.read1);
                this.out.writeInt(pairedReadSequence.read2.length);
                this.out.write(pairedReadSequence.read2);
            }
            catch (IOException iOException) {
                throw new PicardException("Error write out read pair.", iOException);
            }
        }

        public PairedReadSequence decode() {
            try {
                PairedReadSequence pairedReadSequence = new PairedReadSequence();
                try {
                    pairedReadSequence.readGroup = this.in.readShort();
                }
                catch (EOFException eOFException) {
                    return null;
                }
                pairedReadSequence.tile = this.in.readShort();
                pairedReadSequence.x = this.in.readShort();
                pairedReadSequence.y = this.in.readShort();
                int n = this.in.readInt();
                pairedReadSequence.read1 = new byte[n];
                if (this.in.read(pairedReadSequence.read1) != n) {
                    throw new PicardException("Could not read " + n + " bytes from temporary file.");
                }
                n = this.in.readInt();
                pairedReadSequence.read2 = new byte[n];
                if (this.in.read(pairedReadSequence.read2) != n) {
                    throw new PicardException("Could not read " + n + " bytes from temporary file.");
                }
                return pairedReadSequence;
            }
            catch (IOException iOException) {
                throw new PicardException("Exception reading read pair.", iOException);
            }
        }

        public SortingCollection.Codec<PairedReadSequence> clone() {
            return new PairedReadCodec();
        }
    }

    static class PairedReadSequenceWithBarcodes
    extends PairedReadSequence {
        int barcode;
        int readOneBarcode;
        int readTwoBarcode;

        public PairedReadSequenceWithBarcodes() {
        }

        public PairedReadSequenceWithBarcodes(PairedReadSequence pairedReadSequence) {
            if (null == pairedReadSequence) {
                throw new PicardException("val was null");
            }
            this.readGroup = pairedReadSequence.getReadGroup();
            this.tile = pairedReadSequence.getTile();
            this.x = pairedReadSequence.getX();
            this.y = pairedReadSequence.getY();
            this.qualityOk = pairedReadSequence.qualityOk;
            this.read1 = (byte[])pairedReadSequence.read1.clone();
            this.read2 = (byte[])pairedReadSequence.read2.clone();
            this.libraryId = pairedReadSequence.getLibraryId();
        }

        public static int getSizeInBytes() {
            return PairedReadSequence.getSizeInBytes() + 12;
        }
    }

    static class PairedReadSequence
    implements OpticalDuplicateFinder.PhysicalLocation {
        short readGroup = (short)-1;
        short tile = (short)-1;
        short x = (short)-1;
        short y = (short)-1;
        boolean qualityOk = true;
        byte[] read1;
        byte[] read2;
        short libraryId;

        PairedReadSequence() {
        }

        public static int getSizeInBytes() {
            return 308;
        }

        @Override
        public short getReadGroup() {
            return this.readGroup;
        }

        @Override
        public void setReadGroup(short s) {
            this.readGroup = s;
        }

        @Override
        public short getTile() {
            return this.tile;
        }

        @Override
        public void setTile(short s) {
            this.tile = s;
        }

        @Override
        public short getX() {
            return this.x;
        }

        @Override
        public void setX(short s) {
            this.x = s;
        }

        @Override
        public short getY() {
            return this.y;
        }

        @Override
        public void setY(short s) {
            this.y = s;
        }

        @Override
        public short getLibraryId() {
            return this.libraryId;
        }

        @Override
        public void setLibraryId(short s) {
            this.libraryId = s;
        }

        public static SortingCollection.Codec<PairedReadSequence> getCodec() {
            return new PairedReadCodec();
        }
    }
}

