/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IterableAdapter;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;
import picard.sam.markduplicates.MarkDuplicatesWithMateCigarIterator;
import picard.sam.markduplicates.util.AbstractMarkDuplicatesCommandLineProgram;

@CommandLineProgramProperties(usage="Examines aligned records in the supplied SAM or BAM file to locate duplicate molecules. All records are then written to the output file with the duplicate records flagged.", usageShort="Examines aligned records in the supplied SAM or BAM file to locate duplicate molecules.", programGroup=SamOrBam.class)
public class MarkDuplicatesWithMateCigar
extends AbstractMarkDuplicatesCommandLineProgram {
    private final Log log = Log.getInstance(MarkDuplicatesWithMateCigar.class);
    @Option(doc="The minimum distance to buffer records to account for clipping on the 5' end of the records.Set this number to -1 to use twice the first read's read length (or 100, whichever is smaller).", optional=true)
    public int MINIMUM_DISTANCE = -1;
    @Option(doc="Skip record pairs with no mate cigar and include them in the output.")
    boolean SKIP_PAIRS_WITH_NO_MATE_CIGAR = true;
    @Option(doc="The block size for use in the coordinate-sorted record buffer.", optional=true)
    public int BLOCK_SIZE = 100000;
    private boolean warnedNullProgramRecords = false;
    private boolean warnedMissingProgramRecords = false;

    public static void main(String[] stringArray) {
        new MarkDuplicatesWithMateCigar().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        String string2;
        IOUtil.assertInputsAreValid((List)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IOUtil.assertFileIsWritable((File)this.METRICS_FILE);
        AbstractMarkDuplicatesCommandLineProgram.SamHeaderAndIterator samHeaderAndIterator = this.openInputs();
        SAMFileHeader sAMFileHeader = samHeaderAndIterator.header;
        SAMFileHeader sAMFileHeader2 = sAMFileHeader.clone();
        sAMFileHeader2.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        for (String string2 : this.COMMENT) {
            sAMFileHeader2.addComment(string2);
        }
        this.setPGIdsSeen(sAMFileHeader2);
        Map<String, String> map = this.getChainedPgIds(sAMFileHeader2);
        string2 = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader2, true, this.OUTPUT);
        MarkDuplicatesWithMateCigarIterator markDuplicatesWithMateCigarIterator = new MarkDuplicatesWithMateCigarIterator(samHeaderAndIterator.header, samHeaderAndIterator.iterator, this.opticalDuplicateFinder, this.DUPLICATE_SCORING_STRATEGY, this.MINIMUM_DISTANCE, this.REMOVE_DUPLICATES, this.SKIP_PAIRS_WITH_NO_MATE_CIGAR, this.MAX_RECORDS_IN_RAM, this.BLOCK_SIZE, this.TMP_DIR);
        ProgressLogger progressLogger = new ProgressLogger(this.log, 1000000, "Read");
        for (SAMRecord sAMRecord : new IterableAdapter((Iterator)((Object)markDuplicatesWithMateCigarIterator))) {
            if (progressLogger.record(sAMRecord)) {
                markDuplicatesWithMateCigarIterator.logMemoryStats(this.log);
            }
            this.updateProgramRecord(sAMRecord, map);
            string2.addAlignment(sAMRecord);
        }
        markDuplicatesWithMateCigarIterator.close();
        string2.close();
        Histogram<Short> histogram = markDuplicatesWithMateCigarIterator.getOpticalDupesByLibraryId();
        this.log.info(new Object[]{"Processed " + progressLogger.getCount() + " records"});
        this.log.info(new Object[]{"Found " + markDuplicatesWithMateCigarIterator.getNumRecordsWithNoMateCigar() + " records with no mate cigar optional tag."});
        this.log.info(new Object[]{"Marking " + markDuplicatesWithMateCigarIterator.getNumDuplicates() + " records as duplicates."});
        this.log.info(new Object[]{"Found " + (long)histogram.getSumOfValues() + " optical duplicate clusters."});
        this.finalizeAndWriteMetrics(markDuplicatesWithMateCigarIterator.getLibraryIdGenerator());
        return 0;
    }

    private void updateProgramRecord(SAMRecord sAMRecord, Map<String, String> map) {
        if (this.PROGRAM_RECORD_ID != null) {
            String string = sAMRecord.getStringAttribute(SAMTag.PG.name());
            if (null == string) {
                if (!this.warnedNullProgramRecords) {
                    this.warnedNullProgramRecords = true;
                    this.log.warn(new Object[]{"Encountered a record with no program record, program group chaining will not occur for this read: " + sAMRecord});
                }
            } else if (!map.containsKey(string)) {
                if (!this.warnedMissingProgramRecords) {
                    this.warnedMissingProgramRecords = true;
                    this.log.warn(new Object[]{"Encountered a record with an intermediate program record, program group chaining will not occur for this read: " + sAMRecord});
                }
            } else {
                sAMRecord.setAttribute(SAMTag.PG.name(), (Object)map.get(string));
            }
        }
    }

    private void setPGIdsSeen(SAMFileHeader sAMFileHeader) {
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        for (SAMProgramRecord sAMProgramRecord : sAMFileHeader.getProgramRecords()) {
            string = sAMProgramRecord.getPreviousProgramGroupId();
            if (null == string) continue;
            hashSet.add(string);
        }
        for (SAMProgramRecord sAMProgramRecord : sAMFileHeader.getProgramRecords()) {
            string = sAMProgramRecord.getId();
            if (hashSet.contains(string)) continue;
            this.pgIdsSeen.add(string);
        }
    }
}

