/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.DuplicateScoringStrategy;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordCoordinateComparator;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.SamRecordTrackingBuffer;
import htsjdk.samtools.util.SamRecordWithOrdinal;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import picard.PicardException;
import picard.sam.DuplicationMetrics;
import picard.sam.markduplicates.util.AbstractMarkDuplicatesCommandLineProgram;
import picard.sam.markduplicates.util.LibraryIdGenerator;
import picard.sam.markduplicates.util.MarkQueue;
import picard.sam.markduplicates.util.OpticalDuplicateFinder;
import picard.sam.markduplicates.util.ReadEnds;
import picard.sam.markduplicates.util.ReadEndsForMateCigar;
import picard.sam.markduplicates.util.SamRecordWithOrdinalAndSetDuplicateReadFlag;

public class MarkDuplicatesWithMateCigarIterator
implements SAMRecordIterator {
    private SAMFileHeader header = null;
    private PeekableIterator<SAMRecord> backingIterator = null;
    private int backingIteratorRecordIndex = 0;
    private boolean removeDuplicates = false;
    private boolean skipPairsWithNoMateCigar = true;
    private int numRecordsWithNoMateCigar = 0;
    private boolean foundUnmappedEOFReads = false;
    private int referenceIndex = 0;
    private SamRecordTrackingBuffer outputBuffer = null;
    private final MarkQueue toMarkQueue;
    private SAMRecord nextRecord = null;
    private final LibraryIdGenerator libraryIdGenerator;
    private OpticalDuplicateFinder opticalDuplicateFinder = null;
    private final SAMRecordCoordinateComparator sortComparator = new SAMRecordCoordinateComparator();
    boolean isClosed = false;

    public MarkDuplicatesWithMateCigarIterator(SAMFileHeader sAMFileHeader, CloseableIterator<SAMRecord> closeableIterator, OpticalDuplicateFinder opticalDuplicateFinder, DuplicateScoringStrategy.ScoringStrategy scoringStrategy, int n, boolean bl, boolean bl2, int n2, int n3, List<File> list) throws PicardException {
        if (sAMFileHeader.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new PicardException(this.getClass().getName() + " expects the input to be in coordinate sort order.");
        }
        this.header = sAMFileHeader;
        this.backingIterator = new PeekableIterator(closeableIterator);
        this.outputBuffer = new SamRecordTrackingBuffer(n2, n3, list, sAMFileHeader, SamRecordWithOrdinalAndSetDuplicateReadFlag.class);
        this.removeDuplicates = bl;
        this.skipPairsWithNoMateCigar = bl2;
        this.opticalDuplicateFinder = opticalDuplicateFinder;
        this.toMarkQueue = new MarkQueue(scoringStrategy);
        this.libraryIdGenerator = new LibraryIdGenerator(sAMFileHeader);
        if (scoringStrategy == DuplicateScoringStrategy.ScoringStrategy.SUM_OF_BASE_QUALITIES) {
            throw new PicardException("SUM_OF_BASE_QUALITIES not supported as this may cause inconsistencies across ends in a pair.  Please use a different scoring strategy.");
        }
        for (SAMReadGroupRecord sAMReadGroupRecord : sAMFileHeader.getReadGroups()) {
            String string = sAMReadGroupRecord.getLibrary();
            DuplicationMetrics duplicationMetrics = this.libraryIdGenerator.getMetricsByLibrary(string);
            if (duplicationMetrics != null) continue;
            duplicationMetrics = new DuplicationMetrics();
            duplicationMetrics.LIBRARY = string;
            this.libraryIdGenerator.addMetricsByLibrary(string, duplicationMetrics);
        }
        this.toMarkQueue.setToMarkQueueMinimumDistance(n);
        this.nextRecord = this.markDuplicatesAndGetTheNextAvailable();
    }

    public void logMemoryStats(Log log) {
        System.gc();
        Runtime runtime = Runtime.getRuntime();
        log.info(new Object[]{"freeMemory: " + runtime.freeMemory() + "; totalMemory: " + runtime.totalMemory() + "; maxMemory: " + runtime.maxMemory() + "; output buffer size: " + this.outputBuffer.size() + "; duplicate queue size: " + this.toMarkQueue.size()});
    }

    public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
        if (sortOrder != SAMFileHeader.SortOrder.coordinate) {
            throw new IllegalStateException("Cannot assort " + sortOrder + " when expecting coordinate sorted input");
        }
        return this;
    }

    public boolean hasNext() {
        if (null != this.nextRecord) {
            return true;
        }
        return this.backingIterator.hasNext() || !this.outputBuffer.isEmpty();
    }

    public SAMRecord next() throws PicardException {
        SAMRecord sAMRecord = this.nextRecord;
        if (null == sAMRecord) {
            throw new NoSuchElementException();
        }
        this.nextRecord = this.hasNext() ? this.markDuplicatesAndGetTheNextAvailable() : null;
        if (null != this.nextRecord && 0 < this.sortComparator.fileOrderCompare(sAMRecord, this.nextRecord)) {
            System.err.print("Previous record: " + sAMRecord.getSAMString());
            System.err.print("Current record:" + this.nextRecord.getSAMString());
            throw new PicardException("Records were not found coordinate sort order");
        }
        return sAMRecord;
    }

    private boolean ignoreDueToMissingMateCigar(SamRecordWithOrdinal samRecordWithOrdinal) {
        SAMRecord sAMRecord = samRecordWithOrdinal.getRecord();
        if (sAMRecord.getReadPairedFlag() && !sAMRecord.getMateUnmappedFlag() && null == SAMUtils.getMateCigar((SAMRecord)sAMRecord)) {
            if (!sAMRecord.isSecondaryOrSupplementary()) {
                DuplicationMetrics duplicationMetrics = this.getMetrics(sAMRecord);
                if (sAMRecord.getReadUnmappedFlag()) {
                    ++duplicationMetrics.UNMAPPED_READS;
                } else if (!sAMRecord.getReadPairedFlag() || sAMRecord.getMateUnmappedFlag()) {
                    ++duplicationMetrics.UNPAIRED_READS_EXAMINED;
                } else {
                    ++duplicationMetrics.READ_PAIRS_EXAMINED;
                }
            }
            if (this.skipPairsWithNoMateCigar) {
                this.addRecordToTheOutputBuffer(samRecordWithOrdinal);
                ++this.backingIteratorRecordIndex;
                this.outputBuffer.setResultState(samRecordWithOrdinal, false);
                ++this.numRecordsWithNoMateCigar;
                this.backingIterator.next();
                return true;
            }
            throw new PicardException("Read " + sAMRecord.getReadName() + " was mapped and had a mapped mate, but no mate cigar (\"MC\") tag.");
        }
        return false;
    }

    private SAMRecord nextIfRecordIsUnmappedAtEOF(SAMRecord sAMRecord) {
        if (this.foundUnmappedEOFReads) {
            SAMRecord sAMRecord2 = (SAMRecord)this.backingIterator.next();
            if (!sAMRecord.isSecondaryOrSupplementary()) {
                DuplicationMetrics duplicationMetrics = this.getMetrics(sAMRecord);
                ++duplicationMetrics.UNMAPPED_READS;
            }
            if (!this.outputBuffer.isEmpty()) {
                throw new PicardException("Encountered unmapped reads at the end of the file, but the alignment start buffer was not empty.");
            }
            return sAMRecord2;
        }
        this.foundUnmappedEOFReads = true;
        this.referenceIndex = this.header.getSequenceDictionary().getSequences().size();
        this.tryPollingTheToMarkQueue(true, null);
        return this.markDuplicatesAndGetTheNextAvailable();
    }

    private void checkForMinimumDistanceFailure(ReadEndsForMateCigar readEndsForMateCigar) {
        if (!this.toMarkQueue.isEmpty()) {
            ReadEndsForMateCigar readEndsForMateCigar2 = this.toMarkQueue.peek();
            if (readEndsForMateCigar2.read1ReferenceIndex == readEndsForMateCigar.read1ReferenceIndex && this.toMarkQueue.getToMarkQueueMinimumDistance() <= readEndsForMateCigar2.read1Coordinate - readEndsForMateCigar.read1Coordinate) {
                if (this.checkCigarForSkips(readEndsForMateCigar2.getRecord().getCigar())) {
                    throw new PicardException("Found a samRecordWithOrdinal with sufficiently large code length that we may have\n missed including it in an early duplicate marking iteration.  Alignment contains skipped reference bases (N's). If this is an\n RNAseq aligned bam, please use MarkDuplicates instead, as this tool does not work well with spliced reads.\n Minimum distance set to " + this.toMarkQueue.getToMarkQueueMinimumDistance() + " but " + (readEndsForMateCigar2.read1Coordinate - readEndsForMateCigar.read1Coordinate - 1) + " would be required.\n" + "Record was: " + readEndsForMateCigar2.getRecord().getSAMString());
                }
                System.err.print("record #1: " + readEndsForMateCigar2.getRecord().getSAMString());
                System.err.print("record #2: " + readEndsForMateCigar.getRecord().getSAMString());
                throw new PicardException("Found a samRecordWithOrdinal with sufficiently large clipping that we may have\n missed including it in an early duplicate marking iteration.  Please increase the minimum distance to at least " + (readEndsForMateCigar2.read1Coordinate - readEndsForMateCigar.read1Coordinate - 1) + "bp\nto ensure it is considered (was " + this.toMarkQueue.getToMarkQueueMinimumDistance() + ").\n" + "Record was: " + readEndsForMateCigar2.getRecord().getSAMString());
            }
        }
    }

    private SAMRecord markDuplicatesAndGetTheNextAvailable() {
        SAMRecord sAMRecord = this.flush();
        if (null != sAMRecord) {
            return sAMRecord;
        }
        if (!this.backingIterator.hasNext()) {
            if (this.toMarkQueue.isEmpty()) {
                if (this.outputBuffer.isEmpty()) {
                    return null;
                }
            } else {
                this.tryPollingTheToMarkQueue(true, null);
            }
            this.referenceIndex = this.header.getSequenceDictionary().getSequences().size();
            return this.markDuplicatesAndGetTheNextAvailable();
        }
        while (this.backingIterator.hasNext()) {
            DuplicationMetrics duplicationMetrics;
            sAMRecord = (SAMRecord)this.backingIterator.peek();
            SamRecordWithOrdinalAndSetDuplicateReadFlag samRecordWithOrdinalAndSetDuplicateReadFlag = new SamRecordWithOrdinalAndSetDuplicateReadFlag(sAMRecord, this.backingIteratorRecordIndex);
            ReadEndsForMateCigar readEndsForMateCigar = null;
            boolean bl = false;
            sAMRecord.setDuplicateReadFlag(false);
            if (this.ignoreDueToMissingMateCigar(samRecordWithOrdinalAndSetDuplicateReadFlag)) continue;
            if (sAMRecord.getReadUnmappedFlag()) {
                if (-1 == sAMRecord.getReferenceIndex()) {
                    return this.nextIfRecordIsUnmappedAtEOF(sAMRecord);
                }
                if (!sAMRecord.isSecondaryOrSupplementary()) {
                    duplicationMetrics = this.getMetrics(sAMRecord);
                    ++duplicationMetrics.UNMAPPED_READS;
                }
            } else {
                if (-1 == this.toMarkQueue.getToMarkQueueMinimumDistance()) {
                    this.toMarkQueue.setToMarkQueueMinimumDistance(Math.max(2 * sAMRecord.getReadBases().length, 100));
                }
                readEndsForMateCigar = new ReadEndsForMateCigar(this.header, samRecordWithOrdinalAndSetDuplicateReadFlag, this.opticalDuplicateFinder, this.libraryIdGenerator.getLibraryId(samRecordWithOrdinalAndSetDuplicateReadFlag.getRecord()));
                this.checkForMinimumDistanceFailure(readEndsForMateCigar);
                bl = this.tryPollingTheToMarkQueue(false, readEndsForMateCigar);
            }
            this.backingIterator.next();
            this.addRecordToTheOutputBuffer(samRecordWithOrdinalAndSetDuplicateReadFlag);
            ++this.backingIteratorRecordIndex;
            if (sAMRecord.isSecondaryOrSupplementary() || sAMRecord.getReadUnmappedFlag()) {
                this.outputBuffer.setResultState((SamRecordWithOrdinal)samRecordWithOrdinalAndSetDuplicateReadFlag, false);
            } else {
                duplicationMetrics = this.getMetrics(sAMRecord);
                if (!sAMRecord.getReadPairedFlag() || sAMRecord.getMateUnmappedFlag()) {
                    ++duplicationMetrics.UNPAIRED_READS_EXAMINED;
                } else {
                    ++duplicationMetrics.READ_PAIRS_EXAMINED;
                }
                this.toMarkQueue.add(readEndsForMateCigar, this.outputBuffer, this.getMetrics(readEndsForMateCigar.getRecord()));
            }
            if (!bl || null == (sAMRecord = this.flush())) continue;
            return sAMRecord;
        }
        return this.markDuplicatesAndGetTheNextAvailable();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.backingIterator.close();
        this.outputBuffer.close();
        this.isClosed = true;
    }

    private boolean checkCigarForSkips(Cigar cigar) {
        List list = cigar.getCigarElements();
        for (CigarElement cigarElement : list) {
            if (cigarElement.getOperator() != CigarOperator.N) continue;
            return true;
        }
        return false;
    }

    private void enforceClosed() {
        if (!this.isClosed) {
            throw new PicardException("Calling a method that assumes the iterator is closed");
        }
    }

    public int getNumRecordsWithNoMateCigar() {
        this.enforceClosed();
        return this.numRecordsWithNoMateCigar;
    }

    public int getNumDuplicates() {
        this.enforceClosed();
        return this.toMarkQueue.getNumDuplicates();
    }

    public LibraryIdGenerator getLibraryIdGenerator() {
        this.enforceClosed();
        return this.libraryIdGenerator;
    }

    public Histogram<Short> getOpticalDupesByLibraryId() {
        this.enforceClosed();
        return this.libraryIdGenerator.getOpticalDuplicatesByLibraryIdMap();
    }

    private SAMRecord flush() {
        while (!this.outputBuffer.isEmpty() && this.outputBuffer.canEmit()) {
            SAMRecord sAMRecord = this.outputBuffer.next().getRecord();
            if (this.removeDuplicates && sAMRecord.getDuplicateReadFlag()) continue;
            return sAMRecord;
        }
        return null;
    }

    private void addRecordToTheOutputBuffer(SamRecordWithOrdinal samRecordWithOrdinal) throws PicardException {
        int n = samRecordWithOrdinal.getRecord().getReferenceIndex();
        if (n < this.referenceIndex) {
            throw new PicardException("Records out of order: " + n + " < " + this.referenceIndex);
        }
        if (this.referenceIndex < n) {
            this.tryPollingTheToMarkQueue(true, null);
            this.referenceIndex = n;
        }
        this.outputBuffer.add(samRecordWithOrdinal);
    }

    private boolean tryPollingTheToMarkQueue(boolean bl, ReadEndsForMateCigar readEndsForMateCigar) {
        boolean bl2 = false;
        if (!bl && null == readEndsForMateCigar) {
            throw new PicardException("Flush cannot be false and current be null");
        }
        if (this.toMarkQueue.isEmpty()) {
            return false;
        }
        if (!this.toMarkQueue.isEmpty() && this.outputBuffer.isEmpty()) {
            throw new PicardException("0 < toMarkQueue && outputBuffer.isEmpty()");
        }
        while (!this.toMarkQueue.isEmpty() && (bl || this.referenceIndex != readEndsForMateCigar.read1ReferenceIndex || this.toMarkQueue.getToMarkQueueMinimumDistance() < readEndsForMateCigar.read1Coordinate - this.toMarkQueue.peek().read1Coordinate)) {
            Set<ReadEnds> set;
            ReadEndsForMateCigar readEndsForMateCigar2 = this.toMarkQueue.poll(this.outputBuffer, this.header, this.opticalDuplicateFinder, this.libraryIdGenerator);
            bl2 = true;
            if (!this.toMarkQueue.shouldBeInLocations(readEndsForMateCigar2) || !readEndsForMateCigar2.getRecord().getFirstOfPairFlag() || (set = this.toMarkQueue.getLocations(readEndsForMateCigar2)).isEmpty()) continue;
            AbstractMarkDuplicatesCommandLineProgram.trackOpticalDuplicates(new ArrayList<ReadEnds>(set), this.opticalDuplicateFinder, this.libraryIdGenerator);
        }
        return bl2;
    }

    private DuplicationMetrics getMetrics(SAMRecord sAMRecord) {
        String string = LibraryIdGenerator.getLibraryName(this.header, sAMRecord);
        DuplicationMetrics duplicationMetrics = this.libraryIdGenerator.getMetricsByLibrary(string);
        if (duplicationMetrics == null) {
            duplicationMetrics = new DuplicationMetrics();
            duplicationMetrics.LIBRARY = string;
            this.libraryIdGenerator.addMetricsByLibrary(string, duplicationMetrics);
        }
        return duplicationMetrics;
    }
}

