/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.DuplicateScoringStrategy;
import htsjdk.samtools.MergingSamRecordIterator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.Histogram;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.cmdline.Option;
import picard.sam.DuplicationMetrics;
import picard.sam.markduplicates.util.AbstractOpticalDuplicateFinderCommandLineProgram;
import picard.sam.markduplicates.util.LibraryIdGenerator;
import picard.sam.markduplicates.util.OpticalDuplicateFinder;
import picard.sam.markduplicates.util.ReadEnds;

public abstract class AbstractMarkDuplicatesCommandLineProgram
extends AbstractOpticalDuplicateFinderCommandLineProgram {
    @Option(shortName="I", doc="One or more input SAM or BAM files to analyze. Must be coordinate sorted.")
    public List<String> INPUT;
    @Option(shortName="O", doc="The output file to write marked records to")
    public File OUTPUT;
    @Option(shortName="M", doc="File to write duplication metrics to")
    public File METRICS_FILE;
    @Option(doc="If true do not write duplicates to the output file instead of writing them with appropriate flags set.")
    public boolean REMOVE_DUPLICATES = false;
    @Option(shortName="AS", doc="If true, assume that the input file is coordinate sorted even if the header says otherwise.")
    public boolean ASSUME_SORTED = false;
    @Option(shortName="DS", doc="The scoring strategy for choosing the non-duplicate among candidates.")
    public DuplicateScoringStrategy.ScoringStrategy DUPLICATE_SCORING_STRATEGY = DuplicateScoringStrategy.ScoringStrategy.TOTAL_MAPPED_REFERENCE_LENGTH;
    @Option(shortName="PG", doc="The program record ID for the @PG record(s) created by this program. Set to null to disable PG record creation.  This string may have a suffix appended to avoid collision with other program record IDs.", optional=true)
    public String PROGRAM_RECORD_ID = "MarkDuplicates";
    @Option(shortName="PG_VERSION", doc="Value of VN tag of PG record to be created. If not specified, the version will be detected automatically.", optional=true)
    public String PROGRAM_GROUP_VERSION;
    @Option(shortName="PG_COMMAND", doc="Value of CL tag of PG record to be created. If not supplied the command line will be detected automatically.", optional=true)
    public String PROGRAM_GROUP_COMMAND_LINE;
    @Option(shortName="PG_NAME", doc="Value of PN tag of PG record to be created.")
    public String PROGRAM_GROUP_NAME = this.getClass().getSimpleName();
    @Option(shortName="CO", doc="Comment(s) to include in the output file's header.", optional=true)
    public List<String> COMMENT = new ArrayList<String>();
    protected final Set<String> pgIdsSeen = new HashSet<String>();

    protected Map<String, String> getChainedPgIds(SAMFileHeader sAMFileHeader) {
        HashMap<String, String> hashMap;
        if (this.PROGRAM_RECORD_ID != null) {
            SAMFileHeader.PgIdGenerator pgIdGenerator = new SAMFileHeader.PgIdGenerator(sAMFileHeader);
            if (this.PROGRAM_GROUP_VERSION == null) {
                this.PROGRAM_GROUP_VERSION = this.getVersion();
            }
            if (this.PROGRAM_GROUP_COMMAND_LINE == null) {
                this.PROGRAM_GROUP_COMMAND_LINE = this.getCommandLine();
            }
            hashMap = new HashMap<String, String>();
            for (String string : this.pgIdsSeen) {
                String string2 = pgIdGenerator.getNonCollidingId(this.PROGRAM_RECORD_ID);
                hashMap.put(string, string2);
                SAMProgramRecord sAMProgramRecord = new SAMProgramRecord(string2);
                sAMProgramRecord.setProgramVersion(this.PROGRAM_GROUP_VERSION);
                sAMProgramRecord.setCommandLine(this.PROGRAM_GROUP_COMMAND_LINE);
                sAMProgramRecord.setProgramName(this.PROGRAM_GROUP_NAME);
                sAMProgramRecord.setPreviousProgramGroupId(string);
                sAMFileHeader.addProgramRecord(sAMProgramRecord);
            }
        } else {
            hashMap = null;
        }
        return hashMap;
    }

    protected void finalizeAndWriteMetrics(LibraryIdGenerator libraryIdGenerator) {
        Map<String, DuplicationMetrics> map = libraryIdGenerator.getMetricsByLibraryMap();
        Histogram<Short> histogram = libraryIdGenerator.getOpticalDuplicatesByLibraryIdMap();
        Map<String, Short> map2 = libraryIdGenerator.getLibraryIdsMap();
        MetricsFile metricsFile = this.getMetricsFile();
        for (Map.Entry<String, DuplicationMetrics> entry : map.entrySet()) {
            Histogram.Bin bin;
            String string = entry.getKey();
            DuplicationMetrics duplicationMetrics = entry.getValue();
            duplicationMetrics.READ_PAIRS_EXAMINED /= 2L;
            duplicationMetrics.READ_PAIR_DUPLICATES /= 2L;
            Short s = map2.get(string);
            if (s != null && (bin = (Histogram.Bin)histogram.get((Object)s)) != null) {
                duplicationMetrics.READ_PAIR_OPTICAL_DUPLICATES = (long)bin.getValue();
            }
            duplicationMetrics.calculateDerivedMetrics();
            metricsFile.addMetric((MetricBase)duplicationMetrics);
        }
        if (map.size() == 1) {
            metricsFile.setHistogram(map.values().iterator().next().calculateRoiHistogram());
        }
        metricsFile.write(this.METRICS_FILE);
    }

    protected SamHeaderAndIterator openInputs() {
        String string2;
        ArrayList<SAMFileHeader> arrayList = new ArrayList<SAMFileHeader>(this.INPUT.size());
        ArrayList<SamReader> arrayList2 = new ArrayList<SamReader>(this.INPUT.size());
        for (String string2 : this.INPUT) {
            SamReader samReader = SamReaderFactory.makeDefault().enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.EAGERLY_DECODE}).open(SamInputResource.of((String)string2));
            SAMFileHeader sAMFileHeader = samReader.getFileHeader();
            if (!this.ASSUME_SORTED && sAMFileHeader.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
                throw new PicardException("Input file " + string2 + " is not coordinate sorted.");
            }
            arrayList.add(sAMFileHeader);
            arrayList2.add(samReader);
        }
        if (arrayList.size() == 1) {
            return new SamHeaderAndIterator((SAMFileHeader)arrayList.get(0), (CloseableIterator<SAMRecord>)((SamReader)arrayList2.get(0)).iterator());
        }
        SamFileHeaderMerger samFileHeaderMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.coordinate, arrayList, false);
        string2 = new MergingSamRecordIterator(samFileHeaderMerger, arrayList2, this.ASSUME_SORTED);
        return new SamHeaderAndIterator(samFileHeaderMerger.getMergedHeader(), (CloseableIterator<SAMRecord>)string2);
    }

    public static void trackOpticalDuplicates(List<? extends ReadEnds> list, OpticalDuplicateFinder opticalDuplicateFinder, LibraryIdGenerator libraryIdGenerator) {
        boolean bl = false;
        boolean bl2 = false;
        for (ReadEnds object : list) {
            if (3 == object.orientationForOpticalDuplicates) {
                bl = true;
                continue;
            }
            if (5 != object.orientationForOpticalDuplicates) continue;
            bl2 = true;
        }
        if (bl && bl2) {
            ArrayList arrayList = new ArrayList();
            ArrayList<ReadEnds> arrayList2 = new ArrayList<ReadEnds>();
            for (ReadEnds readEnds : list) {
                if (3 == readEnds.orientationForOpticalDuplicates) {
                    arrayList.add(readEnds);
                    continue;
                }
                if (5 == readEnds.orientationForOpticalDuplicates) {
                    arrayList2.add(readEnds);
                    continue;
                }
                throw new PicardException("Found an unexpected orientation: " + readEnds.orientation);
            }
            AbstractMarkDuplicatesCommandLineProgram.trackOpticalDuplicates(arrayList, opticalDuplicateFinder, libraryIdGenerator.getOpticalDuplicatesByLibraryIdMap());
            AbstractMarkDuplicatesCommandLineProgram.trackOpticalDuplicates(arrayList2, opticalDuplicateFinder, libraryIdGenerator.getOpticalDuplicatesByLibraryIdMap());
        } else {
            AbstractMarkDuplicatesCommandLineProgram.trackOpticalDuplicates(list, opticalDuplicateFinder, libraryIdGenerator.getOpticalDuplicatesByLibraryIdMap());
        }
    }

    private static void trackOpticalDuplicates(List<? extends OpticalDuplicateFinder.PhysicalLocation> list, OpticalDuplicateFinder opticalDuplicateFinder, Histogram<Short> histogram) {
        boolean[] blArray = opticalDuplicateFinder.findOpticalDuplicates(list);
        int n = 0;
        for (boolean bl : blArray) {
            if (!bl) continue;
            ++n;
        }
        if (n > 0) {
            histogram.increment((Comparable)Short.valueOf(list.get(0).getLibraryId()), (double)n);
        }
    }

    public static final class SamHeaderAndIterator {
        public final SAMFileHeader header;
        public final CloseableIterator<SAMRecord> iterator;

        public SamHeaderAndIterator(SAMFileHeader sAMFileHeader, CloseableIterator<SAMRecord> closeableIterator) {
            this.header = sAMFileHeader;
            this.iterator = closeableIterator;
        }
    }
}

