/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.DuplicateScoringStrategy;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.util.SamRecordTrackingBuffer;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import picard.PicardException;
import picard.sam.DuplicationMetrics;
import picard.sam.markduplicates.util.LibraryIdGenerator;
import picard.sam.markduplicates.util.OpticalDuplicateFinder;
import picard.sam.markduplicates.util.PhysicalLocationForMateCigarSet;
import picard.sam.markduplicates.util.ReadEnds;
import picard.sam.markduplicates.util.ReadEndsForMateCigar;

public class MarkQueue {
    private int toMarkQueueMinimumDistance = -1;
    private int numDuplicates = 0;
    private final TreeSet<ReadEndsForMateCigar> nonDuplicateReadEndsSet = new TreeSet<ReadEndsForMateCigar>(new MarkQueueComparator());
    private final TreeSet<ReadEndsForMateCigar> otherEndOfNonDuplicateReadEndsSet = new TreeSet<ReadEndsForMateCigar>(new MarkQueueComparator());
    private final Comparator<ReadEndsForMateCigar> comparator;
    private ReadEndsForMateCigar tmpReadEnds = null;

    public MarkQueue(DuplicateScoringStrategy.ScoringStrategy scoringStrategy) {
        this.comparator = new ReadEndsMCComparator(scoringStrategy);
    }

    public int getNumDuplicates() {
        return this.numDuplicates;
    }

    public int size() {
        return this.nonDuplicateReadEndsSet.size() + this.otherEndOfNonDuplicateReadEndsSet.size();
    }

    public boolean isEmpty() {
        return this.nonDuplicateReadEndsSet.isEmpty();
    }

    public void setToMarkQueueMinimumDistance(int n) {
        this.toMarkQueueMinimumDistance = n;
    }

    public int getToMarkQueueMinimumDistance() {
        return this.toMarkQueueMinimumDistance;
    }

    public boolean shouldBeInLocations(ReadEndsForMateCigar readEndsForMateCigar) {
        return readEndsForMateCigar.isPaired() && 0 == readEndsForMateCigar.hasUnmapped;
    }

    public Set<ReadEnds> getLocations(ReadEndsForMateCigar readEndsForMateCigar) {
        if (!this.shouldBeInLocations(readEndsForMateCigar)) {
            throw new PicardException("Not implemented");
        }
        Set<ReadEnds> set = readEndsForMateCigar.getReadEndSetForOpticalDuplicates();
        if (null == set) {
            throw new PicardException("Locations was empty: unexpected error");
        }
        return set;
    }

    public ReadEndsForMateCigar peek() {
        return this.nonDuplicateReadEndsSet.first();
    }

    private void updateDuplicationMetrics(ReadEndsForMateCigar readEndsForMateCigar, DuplicationMetrics duplicationMetrics) {
        if (!readEndsForMateCigar.getRecord().getReadPairedFlag() || readEndsForMateCigar.getRecord().getMateUnmappedFlag()) {
            ++duplicationMetrics.UNPAIRED_READ_DUPLICATES;
        } else {
            ++duplicationMetrics.READ_PAIR_DUPLICATES;
        }
        ++this.numDuplicates;
    }

    public ReadEndsForMateCigar poll(SamRecordTrackingBuffer samRecordTrackingBuffer, SAMFileHeader sAMFileHeader, OpticalDuplicateFinder opticalDuplicateFinder, LibraryIdGenerator libraryIdGenerator) {
        ReadEndsForMateCigar readEndsForMateCigar = this.nonDuplicateReadEndsSet.pollFirst();
        if (readEndsForMateCigar.isPaired()) {
            NavigableSet<ReadEndsForMateCigar> navigableSet;
            if (this.otherEndOfNonDuplicateReadEndsSet.contains(readEndsForMateCigar)) {
                navigableSet = (ReadEndsForMateCigar)this.otherEndOfNonDuplicateReadEndsSet.subSet(readEndsForMateCigar, true, readEndsForMateCigar, true).first();
                samRecordTrackingBuffer.setResultState(((ReadEndsForMateCigar)((Object)navigableSet)).getSamRecordIndex(), false);
                this.otherEndOfNonDuplicateReadEndsSet.remove(readEndsForMateCigar);
            }
            if (null == this.tmpReadEnds) {
                this.tmpReadEnds = new ReadEndsForMateCigar(sAMFileHeader, readEndsForMateCigar.getSamRecordIndex(), opticalDuplicateFinder, readEndsForMateCigar.libraryId);
                this.tmpReadEnds.read2Coordinate = -1;
                this.tmpReadEnds.read2ReferenceIndex = -1;
                this.tmpReadEnds.samRecordWithOrdinal = null;
            } else {
                this.tmpReadEnds.read1ReferenceIndex = readEndsForMateCigar.read1ReferenceIndex;
                this.tmpReadEnds.read1Coordinate = readEndsForMateCigar.read1Coordinate;
            }
            this.tmpReadEnds.orientation = readEndsForMateCigar.orientation == 2 || readEndsForMateCigar.orientation == 3 || readEndsForMateCigar.orientation == 0 ? (byte)0 : 1;
            if (this.nonDuplicateReadEndsSet.contains(this.tmpReadEnds)) {
                navigableSet = this.nonDuplicateReadEndsSet.subSet(this.tmpReadEnds, true, this.tmpReadEnds, true);
                if (1 != navigableSet.size()) {
                    throw new PicardException("SortedSet should have size one (has size " + navigableSet.size() + " )");
                }
                ReadEndsForMateCigar readEndsForMateCigar2 = (ReadEndsForMateCigar)navigableSet.first();
                samRecordTrackingBuffer.setResultState(readEndsForMateCigar2.getSamRecordIndex(), true);
                this.nonDuplicateReadEndsSet.remove(this.tmpReadEnds);
                this.updateDuplicationMetrics(readEndsForMateCigar2, libraryIdGenerator.getMetricsByLibrary(LibraryIdGenerator.getLibraryName(sAMFileHeader, readEndsForMateCigar2.getRecord())));
            }
        }
        samRecordTrackingBuffer.setResultState(readEndsForMateCigar.getSamRecordIndex(), false);
        return readEndsForMateCigar;
    }

    public void add(ReadEndsForMateCigar readEndsForMateCigar, SamRecordTrackingBuffer samRecordTrackingBuffer, DuplicationMetrics duplicationMetrics) {
        SAMRecord sAMRecord;
        PhysicalLocationForMateCigarSet physicalLocationForMateCigarSet = null;
        boolean bl = true;
        ReadEndsForMateCigar readEndsForMateCigar2 = null;
        if (this.nonDuplicateReadEndsSet.contains(readEndsForMateCigar)) {
            sAMRecord = this.nonDuplicateReadEndsSet.subSet(readEndsForMateCigar, true, readEndsForMateCigar, true);
            if (1 != sAMRecord.size()) {
                throw new PicardException("SortedSet should have size one (has size " + sAMRecord.size() + " )");
            }
            ReadEndsForMateCigar readEndsForMateCigar3 = (ReadEndsForMateCigar)sAMRecord.first();
            String string = SAMUtils.getCanonicalRecordName((SAMRecord)readEndsForMateCigar.getRecord());
            String string2 = SAMUtils.getCanonicalRecordName((SAMRecord)readEndsForMateCigar3.getRecord());
            int n = this.comparator.compare(readEndsForMateCigar3, readEndsForMateCigar);
            if (string2.equals(string)) {
                if (0 < n) {
                    this.nonDuplicateReadEndsSet.remove(readEndsForMateCigar3);
                    this.nonDuplicateReadEndsSet.add(readEndsForMateCigar);
                    this.otherEndOfNonDuplicateReadEndsSet.add(readEndsForMateCigar3);
                    if (this.shouldBeInLocations(readEndsForMateCigar)) {
                        physicalLocationForMateCigarSet = readEndsForMateCigar3.removeLocationSet();
                        physicalLocationForMateCigarSet.replace(readEndsForMateCigar3, readEndsForMateCigar);
                        readEndsForMateCigar.setLocationSet(physicalLocationForMateCigarSet);
                        bl = false;
                    }
                } else {
                    this.otherEndOfNonDuplicateReadEndsSet.add(readEndsForMateCigar);
                    if (this.shouldBeInLocations(readEndsForMateCigar3)) {
                        physicalLocationForMateCigarSet = readEndsForMateCigar3.getLocationSet();
                        bl = false;
                    }
                }
            } else if (0 < n) {
                physicalLocationForMateCigarSet = this.shouldBeInLocations(readEndsForMateCigar3) ? readEndsForMateCigar3.removeLocationSet() : new PhysicalLocationForMateCigarSet();
                readEndsForMateCigar.setLocationSet(physicalLocationForMateCigarSet);
                this.nonDuplicateReadEndsSet.remove(readEndsForMateCigar3);
                this.nonDuplicateReadEndsSet.add(readEndsForMateCigar);
                if (this.otherEndOfNonDuplicateReadEndsSet.contains(readEndsForMateCigar3)) {
                    ReadEndsForMateCigar readEndsForMateCigar4 = (ReadEndsForMateCigar)this.otherEndOfNonDuplicateReadEndsSet.subSet(readEndsForMateCigar3, true, readEndsForMateCigar3, true).first();
                    this.otherEndOfNonDuplicateReadEndsSet.remove(readEndsForMateCigar3);
                    samRecordTrackingBuffer.setResultState(readEndsForMateCigar4.getSamRecordIndex(), true);
                    this.updateDuplicationMetrics(readEndsForMateCigar4, duplicationMetrics);
                }
                readEndsForMateCigar2 = readEndsForMateCigar3;
            } else {
                if (this.shouldBeInLocations(readEndsForMateCigar3)) {
                    physicalLocationForMateCigarSet = readEndsForMateCigar3.getLocationSet();
                }
                readEndsForMateCigar2 = readEndsForMateCigar;
            }
        } else {
            if (this.shouldBeInLocations(readEndsForMateCigar)) {
                physicalLocationForMateCigarSet = new PhysicalLocationForMateCigarSet();
                readEndsForMateCigar.setLocationSet(physicalLocationForMateCigarSet);
            }
            this.nonDuplicateReadEndsSet.add(readEndsForMateCigar);
        }
        sAMRecord = readEndsForMateCigar.getRecord();
        if (sAMRecord.getReadPairedFlag() && !sAMRecord.getReadUnmappedFlag() && !sAMRecord.getMateUnmappedFlag() && bl) {
            if (null == physicalLocationForMateCigarSet) {
                throw new PicardException("location nonDuplicateReadEndsSet was null: " + sAMRecord.getSAMString());
            }
            physicalLocationForMateCigarSet.add(readEndsForMateCigar);
        }
        if (null != readEndsForMateCigar2) {
            samRecordTrackingBuffer.setResultState(readEndsForMateCigar2.getSamRecordIndex(), true);
            this.updateDuplicationMetrics(readEndsForMateCigar2, duplicationMetrics);
        }
    }

    class ReadEndsMCComparator
    implements Comparator<ReadEndsForMateCigar> {
        private final DuplicateScoringStrategy.ScoringStrategy duplicateScoringStrategy;

        public ReadEndsMCComparator(DuplicateScoringStrategy.ScoringStrategy scoringStrategy) {
            this.duplicateScoringStrategy = scoringStrategy;
        }

        @Override
        public int compare(ReadEndsForMateCigar readEndsForMateCigar, ReadEndsForMateCigar readEndsForMateCigar2) {
            int n = readEndsForMateCigar.libraryId - readEndsForMateCigar2.libraryId;
            if (n == 0) {
                n = readEndsForMateCigar.read1ReferenceIndex - readEndsForMateCigar2.read1ReferenceIndex;
            }
            if (n == 0) {
                n = readEndsForMateCigar.read1Coordinate - readEndsForMateCigar2.read1Coordinate;
            }
            if (n == 0) {
                n = readEndsForMateCigar2.orientation - readEndsForMateCigar.orientation;
            }
            if (n == 0 && readEndsForMateCigar.isPaired() != readEndsForMateCigar2.isPaired()) {
                return readEndsForMateCigar.isPaired() ? -1 : 1;
            }
            if (n == 0) {
                n = readEndsForMateCigar.hasUnmapped - readEndsForMateCigar2.hasUnmapped;
            }
            if (n == 0) {
                n = readEndsForMateCigar.read2ReferenceIndex - readEndsForMateCigar2.read2ReferenceIndex;
            }
            if (n == 0) {
                n = readEndsForMateCigar.read2Coordinate - readEndsForMateCigar2.read2Coordinate;
            }
            if (n == 0) {
                n = DuplicateScoringStrategy.compare((SAMRecord)readEndsForMateCigar.getRecord(), (SAMRecord)readEndsForMateCigar2.getRecord(), (DuplicateScoringStrategy.ScoringStrategy)this.duplicateScoringStrategy, (boolean)true);
            }
            if (n == 0) {
                n = readEndsForMateCigar.getRecordReadName().compareTo(readEndsForMateCigar2.getRecordReadName());
            }
            if (n == 0 && readEndsForMateCigar.isPaired() && readEndsForMateCigar2.isPaired() && null != readEndsForMateCigar.getSamRecordIndex()) {
                n = readEndsForMateCigar.getRecord().getFirstOfPairFlag() ? -1 : 1;
            }
            return n;
        }
    }

    private class MarkQueueComparator
    implements Comparator<ReadEndsForMateCigar> {
        private MarkQueueComparator() {
        }

        @Override
        public int compare(ReadEndsForMateCigar readEndsForMateCigar, ReadEndsForMateCigar readEndsForMateCigar2) {
            int n = readEndsForMateCigar.libraryId - readEndsForMateCigar2.libraryId;
            if (n == 0) {
                n = readEndsForMateCigar.read1ReferenceIndex - readEndsForMateCigar2.read1ReferenceIndex;
            }
            if (n == 0) {
                n = readEndsForMateCigar.read1Coordinate - readEndsForMateCigar2.read1Coordinate;
            }
            if (n == 0) {
                n = readEndsForMateCigar2.orientation - readEndsForMateCigar.orientation;
            }
            if (n == 0) {
                n = readEndsForMateCigar.read2ReferenceIndex - readEndsForMateCigar2.read2ReferenceIndex;
            }
            if (n == 0) {
                n = readEndsForMateCigar.read2Coordinate - readEndsForMateCigar2.read2Coordinate;
            }
            return n;
        }
    }
}

