/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.util.Log;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picard.sam.util.ReadNameParsingUtils;

public class OpticalDuplicateFinder {
    public static final String DEFAULT_READ_NAME_REGEX = "[a-zA-Z0-9]+:[0-9]:([0-9]+):([0-9]+):([0-9]+).*".intern();
    public static final int DEFAULT_OPTICAL_DUPLICATE_DISTANCE = 100;
    public String readNameRegex;
    public int opticalDuplicatePixelDistance;
    private Pattern readNamePattern;
    private boolean warnedAboutRegexNotMatching = false;
    private final Log log;
    private final int[] tmpLocationFields = new int[10];

    public OpticalDuplicateFinder() {
        this(DEFAULT_READ_NAME_REGEX, 100);
    }

    public OpticalDuplicateFinder(int n) {
        this(DEFAULT_READ_NAME_REGEX, n);
    }

    public OpticalDuplicateFinder(String string) {
        this(string, 100);
    }

    public OpticalDuplicateFinder(String string, int n) {
        this(string, n, null);
    }

    public OpticalDuplicateFinder(String string, int n, Log log) {
        this.readNameRegex = string;
        this.opticalDuplicatePixelDistance = n;
        this.log = log;
    }

    public boolean addLocationInformation(String string, PhysicalLocation physicalLocation) {
        Matcher matcher;
        if (this.readNameRegex == DEFAULT_READ_NAME_REGEX) {
            int n = ReadNameParsingUtils.getRapidDefaultReadNameRegexSplit(string, ':', this.tmpLocationFields);
            if (n != 5 && n != 7) {
                if (null != this.log && !this.warnedAboutRegexNotMatching) {
                    this.log.warn(new Object[]{String.format("Default READ_NAME_REGEX '%s' did not match read name '%s'.  You may need to specify a READ_NAME_REGEX in order to correctly identify optical duplicates.  Note that this message will not be emitted again even if other read names do not match the regex.", this.readNameRegex, string)});
                    this.warnedAboutRegexNotMatching = true;
                }
                return false;
            }
            int n2 = n == 7 ? 2 : 0;
            physicalLocation.setTile((short)this.tmpLocationFields[n2 + 2]);
            physicalLocation.setX((short)this.tmpLocationFields[n2 + 3]);
            physicalLocation.setY((short)this.tmpLocationFields[n2 + 4]);
            return true;
        }
        if (this.readNameRegex == null) {
            return false;
        }
        if (this.readNamePattern == null) {
            this.readNamePattern = Pattern.compile(this.readNameRegex);
        }
        if ((matcher = this.readNamePattern.matcher(string)).matches()) {
            physicalLocation.setTile((short)Integer.parseInt(matcher.group(1)));
            physicalLocation.setX((short)Integer.parseInt(matcher.group(2)));
            physicalLocation.setY((short)Integer.parseInt(matcher.group(3)));
            return true;
        }
        if (null != this.log && !this.warnedAboutRegexNotMatching) {
            this.log.warn(new Object[]{String.format("READ_NAME_REGEX '%s' did not match read name '%s'.  Your regex may not be correct.  Note that this message will not be emitted again even if other read names do not match the regex.", this.readNameRegex, string)});
            this.warnedAboutRegexNotMatching = true;
        }
        return false;
    }

    public boolean[] findOpticalDuplicates(List<? extends PhysicalLocation> list) {
        int n = list.size();
        boolean[] blArray = new boolean[n];
        Collections.sort(list, new Comparator<PhysicalLocation>(){

            @Override
            public int compare(PhysicalLocation physicalLocation, PhysicalLocation physicalLocation2) {
                int n = physicalLocation.getReadGroup() - physicalLocation2.getReadGroup();
                if (n == 0) {
                    n = physicalLocation.getTile() - physicalLocation2.getTile();
                }
                if (n == 0) {
                    n = physicalLocation.getX() - physicalLocation2.getX();
                }
                if (n == 0) {
                    n = physicalLocation.getY() - physicalLocation2.getY();
                }
                return n;
            }
        });
        block0: for (int i = 0; i < n; ++i) {
            PhysicalLocation physicalLocation = list.get(i);
            if (physicalLocation.getTile() < 0) continue;
            for (int j = i + 1; j < n; ++j) {
                PhysicalLocation physicalLocation2 = list.get(j);
                if (blArray[j]) continue;
                if (physicalLocation.getReadGroup() != physicalLocation2.getReadGroup() || physicalLocation.getTile() != physicalLocation2.getTile() || physicalLocation2.getX() > physicalLocation.getX() + this.opticalDuplicatePixelDistance) continue block0;
                if (Math.abs(physicalLocation.getY() - physicalLocation2.getY()) > this.opticalDuplicatePixelDistance) continue;
                blArray[j] = true;
            }
        }
        return blArray;
    }

    public static interface PhysicalLocation {
        public short getReadGroup();

        public void setReadGroup(short var1);

        public short getTile();

        public void setTile(short var1);

        public short getX();

        public void setX(short var1);

        public short getY();

        public void setY(short var1);

        public short getLibraryId();

        public void setLibraryId(short var1);
    }
}

