/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picard.PicardException;
import picard.sam.util.ReadNameParsingUtils;

public class PhysicalLocation {
    public static final String DEFAULT_READ_NAME_REGEX = "[a-zA-Z0-9]+:[0-9]:([0-9]+):([0-9]+):([0-9]+).*";
    private final String readNameRegex;
    private Pattern readNamePattern;
    private short tile = (short)-1;
    private int x = -1;
    private int y = -1;
    private final int[] tmpLocationFields = new int[10];

    public PhysicalLocation() {
        this(DEFAULT_READ_NAME_REGEX);
    }

    public PhysicalLocation(String string) {
        this.readNameRegex = string;
    }

    public short getTile() {
        return this.tile;
    }

    public void setTile(short s) {
        this.tile = s;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public boolean addLocationInformation(String string, PhysicalLocation physicalLocation) {
        Matcher matcher;
        if (this.readNameRegex == DEFAULT_READ_NAME_REGEX) {
            int n = ReadNameParsingUtils.getRapidDefaultReadNameRegexSplit(string, ':', this.tmpLocationFields);
            if (n != 5 && n != 7) {
                throw new PicardException(String.format(" READ_NAME_REGEX '%s' did not match read name '%s'.  ", this.readNameRegex, string));
            }
            int n2 = n == 7 ? 2 : 0;
            physicalLocation.setTile((short)this.tmpLocationFields[n2 + 2]);
            physicalLocation.setX(this.tmpLocationFields[n2 + 3]);
            physicalLocation.setY(this.tmpLocationFields[n2 + 4]);
            return true;
        }
        if (this.readNameRegex == null) {
            return false;
        }
        if (this.readNamePattern == null) {
            this.readNamePattern = Pattern.compile(this.readNameRegex);
        }
        if ((matcher = this.readNamePattern.matcher(string)).matches()) {
            physicalLocation.setTile((short)Integer.parseInt(matcher.group(1)));
            physicalLocation.setX(Integer.parseInt(matcher.group(2)));
            physicalLocation.setY(Integer.parseInt(matcher.group(3)));
            return true;
        }
        throw new PicardException(String.format("READ_NAME_REGEX '%s' did not match read name '%s'. ", this.readNameRegex, string));
    }
}

