/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import picard.util.AdapterPair;
import picard.util.ClippingUtility;

public class AdapterMarker {
    public static final int DEFAULT_ADAPTER_LENGTH = 30;
    public static final int DEFAULT_PRUNE_ADAPTER_LIST_AFTER_THIS_MANY_ADAPTERS_SEEN = 100;
    public static final int DEFAULT_NUM_ADAPTERS_TO_KEEP = 1;
    private int thresholdForSelectingAdaptersToKeep = 100;
    private int numAdaptersToKeep = 1;
    private int minSingleEndMatchBases = 12;
    private int minPairMatchBases = 6;
    private double maxSingleEndErrorRate = 0.1;
    private double maxPairErrorRate = 0.1;
    private final AtomicReference<AdapterPair[]> adapters = new AtomicReference();
    private boolean thresholdReached = false;
    private int numAdaptersSeen = 0;
    private final CollectionUtil.DefaultingMap<AdapterPair, Integer> seenCounts = new CollectionUtil.DefaultingMap((Object)0);

    public AdapterMarker(AdapterPair ... adapterPairArray) {
        this(30, adapterPairArray);
    }

    public AdapterMarker(int n, AdapterPair ... adapterPairArray) {
        ArrayList<TruncatedAdapterPair> arrayList = new ArrayList<TruncatedAdapterPair>();
        for (AdapterPair adapterPair : adapterPairArray) {
            TruncatedAdapterPair truncatedAdapterPair = this.makeTruncatedAdapterPair(adapterPair, n);
            int n2 = arrayList.indexOf(truncatedAdapterPair);
            if (n2 == -1) {
                arrayList.add(truncatedAdapterPair);
                continue;
            }
            TruncatedAdapterPair truncatedAdapterPair2 = (TruncatedAdapterPair)arrayList.get(n2);
            truncatedAdapterPair2.setName(truncatedAdapterPair2.getName() + "|" + adapterPair.getName());
        }
        this.adapters.set(arrayList.toArray(new AdapterPair[arrayList.size()]));
    }

    public int getNumAdaptersToKeep() {
        return this.numAdaptersToKeep;
    }

    public synchronized AdapterMarker setNumAdaptersToKeep(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.format("numAdaptersToKeep should be positive: %d", n));
        }
        this.numAdaptersToKeep = n;
        return this;
    }

    public int getThresholdForSelectingAdaptersToKeep() {
        return this.thresholdForSelectingAdaptersToKeep;
    }

    public synchronized AdapterMarker setThresholdForSelectingAdaptersToKeep(int n) {
        this.thresholdForSelectingAdaptersToKeep = n;
        return this;
    }

    public int getMinSingleEndMatchBases() {
        return this.minSingleEndMatchBases;
    }

    public synchronized AdapterMarker setMinSingleEndMatchBases(int n) {
        this.minSingleEndMatchBases = n;
        return this;
    }

    public int getMinPairMatchBases() {
        return this.minPairMatchBases;
    }

    public synchronized AdapterMarker setMinPairMatchBases(int n) {
        this.minPairMatchBases = n;
        return this;
    }

    public double getMaxSingleEndErrorRate() {
        return this.maxSingleEndErrorRate;
    }

    public synchronized AdapterMarker setMaxSingleEndErrorRate(double d) {
        this.maxSingleEndErrorRate = d;
        return this;
    }

    public double getMaxPairErrorRate() {
        return this.maxPairErrorRate;
    }

    public synchronized AdapterMarker setMaxPairErrorRate(double d) {
        this.maxPairErrorRate = d;
        return this;
    }

    public AdapterPair adapterTrimIlluminaSingleRead(SAMRecord sAMRecord) {
        return this.adapterTrimIlluminaSingleRead(sAMRecord, this.minSingleEndMatchBases, this.maxSingleEndErrorRate);
    }

    public AdapterPair adapterTrimIlluminaPairedReads(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        return this.adapterTrimIlluminaPairedReads(sAMRecord, sAMRecord2, this.minPairMatchBases, this.maxPairErrorRate);
    }

    public AdapterPair adapterTrimIlluminaSingleRead(SAMRecord sAMRecord, int n, double d) {
        AdapterPair adapterPair = ClippingUtility.adapterTrimIlluminaSingleRead(sAMRecord, n, d, this.adapters.get());
        if (adapterPair != null) {
            this.tallyFoundAdapter(adapterPair);
        }
        return adapterPair;
    }

    public AdapterPair adapterTrimIlluminaPairedReads(SAMRecord sAMRecord, SAMRecord sAMRecord2, int n, double d) {
        AdapterPair adapterPair = ClippingUtility.adapterTrimIlluminaPairedReads(sAMRecord, sAMRecord2, n, d, this.adapters.get());
        if (adapterPair != null) {
            this.tallyFoundAdapter(adapterPair);
        }
        return adapterPair;
    }

    AdapterPair[] getAdapters() {
        return this.adapters.get();
    }

    private TruncatedAdapterPair makeTruncatedAdapterPair(AdapterPair adapterPair, int n) {
        return new TruncatedAdapterPair("truncated " + adapterPair.getName(), this.substringAndRemoveTrailingNs(adapterPair.get3PrimeAdapterInReadOrder(), n), this.substringAndRemoveTrailingNs(adapterPair.get5PrimeAdapterInReadOrder(), n));
    }

    private String substringAndRemoveTrailingNs(String string, int n) {
        byte[] byArray = StringUtil.stringToBytes((String)string);
        for (n = Math.min(n, string.length()); n > 0 && SequenceUtil.isNoCall((byte)byArray[n - 1]); --n) {
        }
        return string.substring(0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tallyFoundAdapter(AdapterPair adapterPair) {
        if (this.thresholdForSelectingAdaptersToKeep < 1) {
            return;
        }
        AdapterMarker adapterMarker = this;
        synchronized (adapterMarker) {
            if (this.thresholdReached) {
                return;
            }
            this.seenCounts.put((Object)adapterPair, (Object)((Integer)this.seenCounts.get((Object)adapterPair) + 1));
            ++this.numAdaptersSeen;
            if (this.numAdaptersSeen >= this.thresholdForSelectingAdaptersToKeep) {
                TreeMap treeMap = new TreeMap(new Comparator<Integer>(){

                    @Override
                    public int compare(Integer n, Integer n2) {
                        return n2.compareTo(n);
                    }
                });
                for (Map.Entry entry : this.seenCounts.entrySet()) {
                    treeMap.put((Integer)entry.getValue(), entry.getKey());
                }
                ArrayList arrayList = new ArrayList(this.numAdaptersToKeep);
                int n = Integer.MAX_VALUE;
                for (Map.Entry entry : treeMap.entrySet()) {
                    if (arrayList.size() >= this.numAdaptersToKeep) {
                        if (entry.getKey() != n) break;
                        arrayList.add(entry.getValue());
                        continue;
                    }
                    n = entry.getKey();
                    arrayList.add(entry.getValue());
                }
                this.thresholdReached = true;
                this.adapters.set(arrayList.toArray(new AdapterPair[arrayList.size()]));
            }
        }
    }

    private static class TruncatedAdapterPair
    implements AdapterPair {
        String name;
        final String fivePrime;
        final String threePrime;
        final String fivePrimeReadOrder;
        final byte[] fivePrimeBytes;
        final byte[] threePrimeBytes;
        final byte[] fivePrimeReadOrderBytes;

        private TruncatedAdapterPair(String string, String string2, String string3) {
            this.name = string;
            this.threePrime = string2;
            this.threePrimeBytes = StringUtil.stringToBytes((String)string2);
            this.fivePrimeReadOrder = string3;
            this.fivePrimeReadOrderBytes = StringUtil.stringToBytes((String)string3);
            this.fivePrime = SequenceUtil.reverseComplement((String)string3);
            this.fivePrimeBytes = StringUtil.stringToBytes((String)this.fivePrime);
        }

        @Override
        public String get3PrimeAdapter() {
            return this.threePrime;
        }

        @Override
        public String get5PrimeAdapter() {
            return this.fivePrime;
        }

        @Override
        public String get3PrimeAdapterInReadOrder() {
            return this.threePrime;
        }

        @Override
        public String get5PrimeAdapterInReadOrder() {
            return this.fivePrimeReadOrder;
        }

        @Override
        public byte[] get3PrimeAdapterBytes() {
            return this.threePrimeBytes;
        }

        @Override
        public byte[] get5PrimeAdapterBytes() {
            return this.fivePrimeBytes;
        }

        @Override
        public byte[] get3PrimeAdapterBytesInReadOrder() {
            return this.threePrimeBytes;
        }

        @Override
        public byte[] get5PrimeAdapterBytesInReadOrder() {
            return this.fivePrimeReadOrderBytes;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TruncatedAdapterPair truncatedAdapterPair = (TruncatedAdapterPair)object;
            if (!this.fivePrime.equals(truncatedAdapterPair.fivePrime)) {
                return false;
            }
            return this.threePrime.equals(truncatedAdapterPair.threePrime);
        }

        public int hashCode() {
            int n = this.fivePrime.hashCode();
            n = 31 * n + this.threePrime.hashCode();
            return n;
        }

        public String toString() {
            return "TruncatedAdapterPair{fivePrimeReadOrder='" + this.fivePrimeReadOrder + '\'' + ", threePrime='" + this.threePrime + '\'' + ", name='" + this.name + '\'' + '}';
        }
    }
}

